/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.scope.internal.spi.scope.mapper;

import com.liferay.oauth2.provider.scope.internal.configuration.ConfigurableScopeMapperConfiguration;
import com.liferay.oauth2.provider.scope.spi.scope.mapper.ScopeMapper;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@Component(configurationPid={"com.liferay.oauth2.provider.scope.internal.configuration.ConfigurableScopeMapperConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={ScopeMapper.class})
public class ScopeMapperImpl
implements ScopeMapper {
    private static final Log _log = LogFactoryUtil.getLog(ScopeMapperImpl.class);
    private final Map<String, Set<String>> _mappingsByScope = new HashMap<String, Set<String>>();
    private boolean _passthrough;

    public Set<String> map(String scope) {
        Set<String> mappings = this._mappingsByScope.get(scope);
        HashSet<String> result = new HashSet<String>();
        if (mappings != null) {
            result.addAll(mappings);
        }
        if (this._passthrough || mappings == null) {
            result.add(scope);
        }
        return result;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._mappingsByScope.clear();
        ConfigurableScopeMapperConfiguration configurableScopeMapperConfiguration = (ConfigurableScopeMapperConfiguration)ConfigurableUtil.createConfigurable(ConfigurableScopeMapperConfiguration.class, properties);
        this._passthrough = configurableScopeMapperConfiguration.passthrough();
        for (String mapping : configurableScopeMapperConfiguration.mappings()) {
            String[] mappingParts = StringUtil.split((String)mapping, (String)"=");
            if (mappingParts.length != 2) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Invalid mapping " + mapping));
                continue;
            }
            String[] keys = StringUtil.split((String)mappingParts[0]);
            String[] values = StringUtil.split((String)mappingParts[1]);
            for (String key : keys) {
                Set set = this._mappingsByScope.computeIfAbsent(key, __ -> new HashSet());
                Collections.addAll(set, values);
            }
        }
    }
}

