/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.scope.internal.osgi.commands;

import com.liferay.oauth2.provider.scope.liferay.LiferayOAuth2Scope;
import com.liferay.oauth2.provider.scope.liferay.ScopeLocator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"osgi.command.function=listScopes", "osgi.command.scope=oauth2"}, service={OAuth2OSGiCommands.class})
public class OAuth2OSGiCommands {
    @Reference
    private Portal _portal;
    @Reference
    private ScopeLocator _scopeLocator;

    public void listScopes() {
        this.listScopes(this._portal.getDefaultCompanyId());
    }

    public void listScopes(long companyId) {
        List scopeAliases = ListUtil.sort(new ArrayList(this._scopeLocator.getScopeAliases(companyId)));
        for (String scopeAlias : scopeAliases) {
            System.out.println();
            System.out.println(scopeAlias);
            List liferayOAuth2Scopes = ListUtil.sort(new ArrayList(this._scopeLocator.getLiferayOAuth2Scopes(companyId, scopeAlias)), Comparator.comparing(LiferayOAuth2Scope::getScope));
            for (LiferayOAuth2Scope liferayOAuth2Scope : liferayOAuth2Scopes) {
                Bundle bundle = liferayOAuth2Scope.getBundle();
                System.out.println(StringBundler.concat((Object[])new Object[]{"    ", liferayOAuth2Scope.getScope(), " (", liferayOAuth2Scope.getApplicationName(), " [", bundle.getBundleId(), "])"}));
            }
        }
        System.out.println();
    }
}

