/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.scope.internal.liferay;

import com.liferay.oauth2.provider.scope.liferay.ScopeContext;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;

@Component(service={ScopeContext.class})
public class ThreadLocalScopeContext
implements ScopeContext {
    private final ThreadLocal<String> _accessTokenThreadLocal = ThreadLocal.withInitial(() -> "");
    private final ThreadLocal<String> _applicationNameThreadLocal = ThreadLocal.withInitial(() -> "");
    private final ThreadLocal<String> _bundleSymbolicNameThreadLocal = ThreadLocal.withInitial(() -> "");
    private final ThreadLocal<Long> _companyIdThreadLocal = ThreadLocal.withInitial(() -> 0L);

    public void clear() {
        this._accessTokenThreadLocal.remove();
        this._applicationNameThreadLocal.remove();
        this._bundleSymbolicNameThreadLocal.remove();
        this._companyIdThreadLocal.remove();
    }

    public String getAccessToken() {
        return this._accessTokenThreadLocal.get();
    }

    public String getApplicationName() {
        return this._applicationNameThreadLocal.get();
    }

    public String getBundleSymbolicName() {
        return this._bundleSymbolicNameThreadLocal.get();
    }

    public Long getCompanyId() {
        return this._companyIdThreadLocal.get();
    }

    public void setAccessToken(String accessToken) {
        this._accessTokenThreadLocal.set(accessToken);
    }

    public void setApplicationName(String applicationName) {
        this._applicationNameThreadLocal.set(applicationName);
    }

    public void setBundle(Bundle bundle) {
        String symbolicName = null;
        if (bundle != null) {
            symbolicName = bundle.getSymbolicName();
        }
        this._bundleSymbolicNameThreadLocal.set(symbolicName);
    }

    public void setCompanyId(long companyId) {
        this._companyIdThreadLocal.set(companyId);
    }
}

