/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.service.impl;

import com.liferay.oauth2.provider.exception.DuplicateOAuth2ScopeGrantException;
import com.liferay.oauth2.provider.model.OAuth2Authorization;
import com.liferay.oauth2.provider.model.OAuth2ScopeGrant;
import com.liferay.oauth2.provider.scope.liferay.LiferayOAuth2Scope;
import com.liferay.oauth2.provider.service.base.OAuth2ScopeGrantLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.oauth2.provider.model.OAuth2ScopeGrant"}, service={AopService.class})
public class OAuth2ScopeGrantLocalServiceImpl
extends OAuth2ScopeGrantLocalServiceBaseImpl {
    public OAuth2ScopeGrant createOAuth2ScopeGrant(long companyId, long oAuth2ApplicationScopeAliasesId, String applicationName, String bundleSymbolicName, String scope) throws DuplicateOAuth2ScopeGrantException {
        throw new UnsupportedOperationException();
    }

    public OAuth2ScopeGrant createOAuth2ScopeGrant(long companyId, long oAuth2ApplicationScopeAliasesId, String applicationName, String bundleSymbolicName, String scope, List<String> scopeAliases) throws DuplicateOAuth2ScopeGrantException {
        OAuth2ScopeGrant oAuth2ScopeGrant = this.oAuth2ScopeGrantPersistence.fetchByC_O_A_B_S(companyId, oAuth2ApplicationScopeAliasesId, applicationName, bundleSymbolicName, scope);
        if (oAuth2ScopeGrant != null) {
            throw new DuplicateOAuth2ScopeGrantException();
        }
        long oAuth2ScopeGrantId = this.counterLocalService.increment(OAuth2ScopeGrant.class.getName());
        oAuth2ScopeGrant = this.oAuth2ScopeGrantPersistence.create(oAuth2ScopeGrantId);
        oAuth2ScopeGrant.setCompanyId(companyId);
        oAuth2ScopeGrant.setOAuth2ApplicationScopeAliasesId(oAuth2ApplicationScopeAliasesId);
        oAuth2ScopeGrant.setApplicationName(applicationName);
        oAuth2ScopeGrant.setBundleSymbolicName(bundleSymbolicName);
        oAuth2ScopeGrant.setScope(scope);
        oAuth2ScopeGrant.setScopeAliasesList(scopeAliases);
        return (OAuth2ScopeGrant)this.oAuth2ScopeGrantPersistence.update((BaseModel)oAuth2ScopeGrant);
    }

    public Collection<LiferayOAuth2Scope> getFilteredLiferayOAuth2Scopes(long oAuth2ApplicationScopeAliasesId, Collection<LiferayOAuth2Scope> liferayOAuth2Scopes) {
        ArrayList<LiferayOAuth2Scope> filteredLiferayOAuth2Scopes = new ArrayList<LiferayOAuth2Scope>(liferayOAuth2Scopes.size());
        List oAuth2ScopeGrants = this.oAuth2ScopeGrantPersistence.findByOAuth2ApplicationScopeAliasesId(oAuth2ApplicationScopeAliasesId);
        block0: for (LiferayOAuth2Scope liferayOAuth2Scope : liferayOAuth2Scopes) {
            for (OAuth2ScopeGrant oAuth2ScopeGrant : oAuth2ScopeGrants) {
                if (!this._isMatch(oAuth2ScopeGrant, liferayOAuth2Scope)) continue;
                filteredLiferayOAuth2Scopes.add(liferayOAuth2Scope);
                continue block0;
            }
        }
        return filteredLiferayOAuth2Scopes;
    }

    public Collection<OAuth2ScopeGrant> getOAuth2ScopeGrants(long oAuth2ApplicationScopeAliasesId, int start, int end, OrderByComparator<OAuth2ScopeGrant> orderByComparator) {
        return this.oAuth2ScopeGrantPersistence.findByOAuth2ApplicationScopeAliasesId(oAuth2ApplicationScopeAliasesId, start, end, orderByComparator);
    }

    public Collection<OAuth2ScopeGrant> getOAuth2ScopeGrants(long companyId, String applicationName, String bundleSymbolicName, String accessTokenContent) {
        return this.oAuth2ScopeGrantFinder.findByC_A_B_A(companyId, applicationName, bundleSymbolicName, accessTokenContent);
    }

    public Collection<OAuth2ScopeGrant> grantLiferayOAuth2Scopes(long oAuth2AuthorizationId, Collection<LiferayOAuth2Scope> liferayOAuth2Scopes) throws PortalException {
        if (liferayOAuth2Scopes.isEmpty()) {
            return Collections.emptyList();
        }
        OAuth2Authorization oAuth2Authorization = this.oAuth2AuthorizationPersistence.findByPrimaryKey(oAuth2AuthorizationId);
        List oAuth2ScopeGrants = this.oAuth2ScopeGrantPersistence.findByOAuth2ApplicationScopeAliasesId(oAuth2Authorization.getOAuth2ApplicationScopeAliasesId());
        ArrayList<OAuth2ScopeGrant> resultOAuth2ScopeGrants = new ArrayList<OAuth2ScopeGrant>(oAuth2ScopeGrants.size());
        block0: for (LiferayOAuth2Scope liferayOAuth2Scope : liferayOAuth2Scopes) {
            for (OAuth2ScopeGrant oAuth2ScopeGrant : oAuth2ScopeGrants) {
                if (!this._isMatch(oAuth2ScopeGrant, liferayOAuth2Scope)) continue;
                resultOAuth2ScopeGrants.add(oAuth2ScopeGrant);
                continue block0;
            }
        }
        this.addOAuth2AuthorizationOAuth2ScopeGrants(oAuth2AuthorizationId, resultOAuth2ScopeGrants);
        return resultOAuth2ScopeGrants;
    }

    private boolean _isMatch(OAuth2ScopeGrant oAuth2ScopeGrant, LiferayOAuth2Scope liferayOAuth2Scope) {
        if (!Objects.equals(oAuth2ScopeGrant.getApplicationName(), liferayOAuth2Scope.getApplicationName()) || !Objects.equals(oAuth2ScopeGrant.getScope(), liferayOAuth2Scope.getScope())) {
            return false;
        }
        Bundle bundle = liferayOAuth2Scope.getBundle();
        String bundleSymbolicName = bundle.getSymbolicName();
        return Objects.equals(oAuth2ScopeGrant.getBundleSymbolicName(), bundleSymbolicName);
    }
}

