/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.dynamic.data.mapping.internal.storage;

import com.liferay.dynamic.data.mapping.exception.StorageException;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceSettings;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapter;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterDeleteRequest;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterDeleteResponse;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterGetRequest;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterGetResponse;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterSaveRequest;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterSaveResponse;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldModel;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerTracker;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"ddm.storage.adapter.type=object"}, service={DDMStorageAdapter.class})
public class ObjectDDMStorageAdapter
implements DDMStorageAdapter {
    private static final Log _log = LogFactoryUtil.getLog(ObjectDDMStorageAdapter.class);
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryManagerTracker _objectEntryManagerTracker;
    @Reference
    private ObjectEntryService _objectEntryService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    @Reference
    private UserLocalService _userLocalService;

    public DDMStorageAdapterDeleteResponse delete(DDMStorageAdapterDeleteRequest ddmStorageAdapterDeleteRequest) throws StorageException {
        try {
            long objectEntryId = ddmStorageAdapterDeleteRequest.getPrimaryKey();
            ObjectDefinition objectDefinition = this._fetchObjectDefinition(objectEntryId);
            ObjectEntryManager objectEntryManager = this._objectEntryManagerTracker.getObjectEntryManager(objectDefinition.getStorageType());
            com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry = objectEntryManager.fetchObjectEntry((DTOConverterContext)this._getDTOConverterContext(null, null, LocaleUtil.getSiteDefault()), objectDefinition, objectEntryId);
            if (objectEntry != null) {
                objectEntryManager.deleteObjectEntry(objectDefinition, objectEntry.getId().longValue());
            }
            return DDMStorageAdapterDeleteResponse.Builder.newBuilder().build();
        }
        catch (Exception exception) {
            throw new StorageException((Throwable)exception);
        }
    }

    public DDMStorageAdapterGetResponse get(DDMStorageAdapterGetRequest ddmStorageAdapterGetRequest) throws StorageException {
        try {
            DDMForm ddmForm = ddmStorageAdapterGetRequest.getDDMForm();
            long objectEntryId = ddmStorageAdapterGetRequest.getPrimaryKey();
            ObjectDefinition objectDefinition = this._fetchObjectDefinition(objectEntryId);
            ObjectEntryManager objectEntryManager = this._objectEntryManagerTracker.getObjectEntryManager(objectDefinition.getStorageType());
            return DDMStorageAdapterGetResponse.Builder.newBuilder((DDMFormValues)this._getDDMFormValues(ddmForm, objectEntryManager.getObjectEntry((DTOConverterContext)this._getDTOConverterContext(objectEntryId, null, ddmForm.getDefaultLocale()), objectDefinition, objectEntryId))).build();
        }
        catch (Exception exception) {
            throw new StorageException((Throwable)exception);
        }
    }

    public DDMStorageAdapterSaveResponse save(DDMStorageAdapterSaveRequest ddmStorageAdapterSaveRequest) throws StorageException {
        try {
            User user = this._userLocalService.getUser(ddmStorageAdapterSaveRequest.getUserId());
            final DDMFormValues ddmFormValues = ddmStorageAdapterSaveRequest.getDDMFormValues();
            final DDMForm ddmForm = ddmFormValues.getDDMForm();
            final long objectDefinitionId = this._getObjectDefinitionId(ddmStorageAdapterSaveRequest);
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectDefinitionId);
            ObjectEntryManager objectEntryManager = this._objectEntryManagerTracker.getObjectEntryManager(objectDefinition.getStorageType());
            com.liferay.object.rest.dto.v1_0.ObjectEntry addObjectEntry = objectEntryManager.addObjectEntry((DTOConverterContext)this._getDTOConverterContext(null, user, ddmForm.getDefaultLocale()), objectDefinition, new com.liferay.object.rest.dto.v1_0.ObjectEntry(){
                {
                    this.properties = ObjectDDMStorageAdapter.this._getObjectEntryProperties(ddmForm.getDDMFormFieldsMap(true), ddmFormValues.getDDMFormFieldValues(), ObjectDDMStorageAdapter.this._objectFieldLocalService.getObjectFields(objectDefinitionId));
                }
            }, String.valueOf(ddmStorageAdapterSaveRequest.getGroupId()));
            return DDMStorageAdapterSaveResponse.Builder.newBuilder((long)addObjectEntry.getId()).build();
        }
        catch (Exception exception) {
            throw new StorageException(exception.getMessage(), (Throwable)exception);
        }
    }

    private ObjectDefinition _fetchObjectDefinition(long objectEntryId) throws PortalException {
        ObjectEntry serviceBuilderObjectEntry = this._objectEntryService.fetchObjectEntry(objectEntryId);
        if (serviceBuilderObjectEntry != null) {
            return this._objectDefinitionLocalService.getObjectDefinition(serviceBuilderObjectEntry.getObjectDefinitionId());
        }
        return null;
    }

    private Value _getDDMFormFieldValue(DDMFormField ddmFormField, Map<String, DDMFormField> ddmFormFieldsMap, Locale locale, Map<String, Object> properties) {
        LocalizedValue value = new LocalizedValue(locale);
        Object objectFieldValue = properties.get(this._getObjectFieldName(ddmFormFieldsMap.get(ddmFormField.getName())));
        if (objectFieldValue instanceof Double) {
            NumberFormat numberFormat = NumberFormat.getInstance(locale);
            value.addString(locale, numberFormat.format(objectFieldValue));
        } else if (objectFieldValue instanceof byte[]) {
            value.addString(locale, new String((byte[])objectFieldValue));
        } else {
            value.addString(locale, String.valueOf(objectFieldValue));
        }
        return value;
    }

    private List<DDMFormFieldValue> _getDDMFormFieldValues(List<DDMFormField> ddmFormFields, Map<String, DDMFormField> ddmFormFieldsMap, Locale locale, Map<String, Object> properties) {
        ArrayList<DDMFormFieldValue> ddmFormFieldValues = new ArrayList<DDMFormFieldValue>();
        ddmFormFields.forEach(ddmFormField -> {
            if (StringUtil.equals((String)ddmFormField.getType(), (String)"fieldset")) {
                ddmFormFieldValues.addAll(this._getDDMFormFieldValues(ddmFormField.getNestedDDMFormFields(), ddmFormFieldsMap, locale, properties));
            }
            DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
            ddmFormFieldValue.setName(ddmFormField.getName());
            ddmFormFieldValue.setValue(this._getDDMFormFieldValue((DDMFormField)ddmFormField, ddmFormFieldsMap, locale, properties));
            ddmFormFieldValues.add(ddmFormFieldValue);
        });
        return ddmFormFieldValues;
    }

    private DDMFormValues _getDDMFormValues(DDMForm ddmForm, com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry) {
        DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
        ddmFormValues.addAvailableLocale(ddmForm.getDefaultLocale());
        ddmFormValues.setDDMFormFieldValues(this._getDDMFormFieldValues(ddmForm.getDDMFormFields(), ddmForm.getDDMFormFieldsMap(true), ddmForm.getDefaultLocale(), objectEntry.getProperties()));
        ddmFormValues.setDefaultLocale(ddmForm.getDefaultLocale());
        return ddmFormValues;
    }

    private DefaultDTOConverterContext _getDTOConverterContext(Long objectEntryId, User user, Locale locale) {
        return new DefaultDTOConverterContext(true, Collections.singletonMap("delete", Collections.singletonMap("delete", "")), null, null, (Object)objectEntryId, locale, null, user);
    }

    private long _getObjectDefinitionId(DDMStorageAdapterSaveRequest ddmStorageAdapterSaveRequest) throws Exception {
        DDMFormInstance ddmFormInstance = ddmStorageAdapterSaveRequest.getDDMFormInstance();
        DDMFormInstanceSettings ddmFormInstanceSettings = ddmFormInstance.getSettingsModel();
        return GetterUtil.getLong((String)ddmFormInstanceSettings.objectDefinitionId());
    }

    private Map<String, Object> _getObjectEntryProperties(Map<String, DDMFormField> ddmFormFieldsMap, List<DDMFormFieldValue> ddmFormFieldValues, List<ObjectField> objectFields) throws JSONException, ParseException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Stream stream = objectFields.stream();
        Map<String, String> objectFieldDBTypes = stream.collect(Collectors.toMap(ObjectFieldModel::getName, ObjectFieldModel::getDBType));
        Map<String, ObjectField> objectFieldsMap = this._toObjectFieldsMap(objectFields);
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            DDMFormField ddmFormField = ddmFormFieldsMap.get(ddmFormFieldValue.getName());
            if (ddmFormField.isTransient() && !StringUtil.equals((String)ddmFormField.getType(), (String)"fieldset")) continue;
            if (StringUtil.equals((String)ddmFormFieldValue.getType(), (String)"fieldset")) {
                properties.putAll(this._getObjectEntryProperties(ddmFormFieldsMap, ddmFormFieldValue.getNestedDDMFormFieldValues(), objectFields));
                continue;
            }
            String objectFieldName = this._getObjectFieldName(ddmFormFieldValue.getDDMFormField());
            Value value = ddmFormFieldValue.getValue();
            ObjectField objectField = objectFieldsMap.get(objectFieldName);
            if (objectField.getListTypeDefinitionId() > 0L) {
                properties.put(objectFieldName, HashMapBuilder.put((Object)"key", (Object)this._getOptionReferenceValue(ddmFormFieldValue, ddmFormFieldsMap, objectFieldName, objectFieldDBTypes, value)).build());
                continue;
            }
            properties.put(objectFieldName, this._getOptionReferenceValue(ddmFormFieldValue, ddmFormFieldsMap, objectFieldName, objectFieldDBTypes, value));
        }
        return properties;
    }

    private String _getObjectFieldName(DDMFormField ddmFormField) {
        try {
            JSONArray jsonArray = this._jsonFactory.createJSONArray((String)ddmFormField.getProperty("objectFieldName"));
            return jsonArray.getString(0);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return "";
        }
    }

    private String _getOptionReferenceValue(DDMFormFieldValue ddmFormFieldValue, Map<String, DDMFormField> ddmFormFieldsMap, String objectFieldName, Map<String, String> objectFieldDBTypes, Value value) throws JSONException, ParseException {
        DDMFormField ddmFormField = ddmFormFieldsMap.get(ddmFormFieldValue.getName());
        DDMFormFieldOptions ddmFormFieldOptions = (DDMFormFieldOptions)ddmFormField.getProperty("options");
        if (StringUtil.equals((String)ddmFormFieldValue.getType(), (String)"checkbox_multiple") || StringUtil.equals((String)ddmFormFieldValue.getType(), (String)"select")) {
            JSONArray optionValueJSONArray = this._jsonFactory.createJSONArray(value.getString(value.getDefaultLocale()));
            Map optionsReferences = ddmFormFieldOptions.getOptionsReferences();
            StringBundler sb = new StringBundler(optionValueJSONArray.length() * 2 - 1);
            for (Object optionValue : optionValueJSONArray) {
                sb.append((String)optionsReferences.get(optionValue.toString()));
                sb.append(", ");
            }
            if (sb.index() > 0) {
                sb.setIndex(sb.index() - 1);
            }
            return sb.toString();
        }
        if (StringUtil.equals((String)ddmFormFieldValue.getType(), (String)"grid")) {
            DDMFormFieldOptions columnsDDMFormFieldOptions = (DDMFormFieldOptions)ddmFormField.getProperty("columns");
            Map columnOptionsReferences = columnsDDMFormFieldOptions.getOptionsReferences();
            DDMFormFieldOptions rowsDDMFormFieldOptions = (DDMFormFieldOptions)ddmFormField.getProperty("rows");
            Map rowOptionsReferences = rowsDDMFormFieldOptions.getOptionsReferences();
            JSONObject optionValueJSONObject = this._jsonFactory.createJSONObject(value.getString(value.getDefaultLocale()));
            Set rowValues = optionValueJSONObject.keySet();
            StringBundler sb = new StringBundler(rowValues.size() * 2 - 1);
            for (String rowValue : rowValues) {
                sb.append((String)rowOptionsReferences.get(rowValue));
                sb.append(": ");
                sb.append((String)columnOptionsReferences.get(optionValueJSONObject.get(rowValue)));
                sb.append(", ");
            }
            if (sb.index() > 0) {
                sb.setIndex(sb.index() - 1);
            }
            return sb.toString();
        }
        if (StringUtil.equals((String)ddmFormFieldValue.getType(), (String)"radio")) {
            return ddmFormFieldOptions.getOptionReference(value.getString(value.getDefaultLocale()));
        }
        Map values = value.getValues();
        return String.valueOf(this._getValue(value.getDefaultLocale(), objectFieldDBTypes.get(objectFieldName), (String)values.get(value.getDefaultLocale())));
    }

    private Object _getValue(Locale locale, String objectFieldDBType, String value) throws ParseException {
        if (Objects.equals(objectFieldDBType, "BigDecimal")) {
            if (value.isEmpty()) {
                return 0.0;
            }
            NumberFormat numberFormat = NumberFormat.getInstance(locale);
            return GetterUtil.get((Object)numberFormat.parse(value), (Number)BigDecimal.ZERO);
        }
        if (Objects.equals(objectFieldDBType, "Double")) {
            if (value.isEmpty()) {
                return 0.0;
            }
            NumberFormat numberFormat = NumberFormat.getInstance(locale);
            return GetterUtil.getDouble((Object)numberFormat.parse(value));
        }
        return value;
    }

    private Map<String, ObjectField> _toObjectFieldsMap(List<ObjectField> objectFields) {
        LinkedHashMap<String, ObjectField> objectFieldsMap = new LinkedHashMap<String, ObjectField>();
        for (ObjectField objectField : objectFields) {
            objectFieldsMap.put(objectField.getName(), objectField);
        }
        return objectFieldsMap;
    }
}

