/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.filter.factory;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.rest.filter.factory.FilterFactory;
import com.liferay.object.rest.filter.parser.ObjectDefinitionFilterParser;
import com.liferay.object.rest.odata.entity.v1_0.provider.EntityModelProvider;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.InvalidFilterException;
import com.liferay.portal.odata.filter.expression.Expression;
import com.liferay.portal.odata.filter.expression.ExpressionVisitException;
import com.liferay.portal.odata.filter.expression.ExpressionVisitor;
import javax.ws.rs.ServerErrorException;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseFilterFactory<T>
implements FilterFactory<T> {
    @Reference
    protected EntityModelProvider entityModelProvider;
    @Reference
    protected ObjectDefinitionFilterParser objectDefinitionFilterParser;

    @Override
    public final T create(EntityModel entityModel, String filterString, ObjectDefinition objectDefinition) {
        if (Validator.isNull((String)filterString)) {
            return null;
        }
        return this._create(entityModel, this.objectDefinitionFilterParser.parse(entityModel, filterString, objectDefinition), objectDefinition);
    }

    @Override
    public final T create(Expression filterExpression, ObjectDefinition objectDefinition) {
        if (filterExpression == null) {
            return null;
        }
        return this._create(this.getEntityModel(objectDefinition), filterExpression, objectDefinition);
    }

    @Override
    public final T create(String filterString, ObjectDefinition objectDefinition) {
        try {
            return this.create(this.getEntityModel(objectDefinition), filterString, objectDefinition);
        }
        catch (InvalidFilterException invalidFilterException) {
            throw invalidFilterException;
        }
        catch (Exception exception) {
            throw new ServerErrorException(500, (Throwable)exception);
        }
    }

    public abstract ExpressionVisitor<?> getExpressionVisitor(EntityModel var1, ObjectDefinition var2);

    protected EntityModel getEntityModel(ObjectDefinition objectDefinition) {
        return this.entityModelProvider.getEntityModel(objectDefinition);
    }

    private T _create(EntityModel entityModel, Expression filterExpression, ObjectDefinition objectDefinition) {
        try {
            return (T)filterExpression.accept(this.getExpressionVisitor(entityModel, objectDefinition));
        }
        catch (ExpressionVisitException expressionVisitException) {
            throw new InvalidFilterException(expressionVisitException.getMessage(), (Throwable)expressionVisitException);
        }
        catch (InvalidFilterException invalidFilterException) {
            throw invalidFilterException;
        }
        catch (Exception exception) {
            throw new ServerErrorException(500, (Throwable)exception);
        }
    }
}

