/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.dto.v1_0.util;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.object.rest.dto.v1_0.TaxonomyCategoryBrief;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;

public class TaxonomyCategoryBriefUtil {
    public static TaxonomyCategoryBrief toTaxonomyCategoryBrief(final AssetCategory assetCategory, final DTOConverterContext dtoConverterContext) throws Exception {
        return new TaxonomyCategoryBrief(){
            {
                this.embeddedTaxonomyCategory = TaxonomyCategoryBriefUtil._toTaxonomyCategory(assetCategory.getCategoryId(), dtoConverterContext);
                this.taxonomyCategoryId = assetCategory.getCategoryId();
                this.taxonomyCategoryName = assetCategory.getTitle(dtoConverterContext.getLocale());
                this.taxonomyCategoryName_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)assetCategory.getTitleMap());
            }
        };
    }

    private static Object _toTaxonomyCategory(long categoryId, DTOConverterContext dtoConverterContext) throws Exception {
        UriInfo uriInfo = dtoConverterContext.getUriInfo();
        if (uriInfo == null) {
            return null;
        }
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        String nestedFields = (String)queryParameters.getFirst((Object)"nestedFields");
        if (Validator.isNotNull((String)nestedFields) && nestedFields.contains("embeddedTaxonomyCategory")) {
            DTOConverterRegistry dtoConverterRegistry = dtoConverterContext.getDTOConverterRegistry();
            DTOConverter dtoConverter = dtoConverterRegistry.getDTOConverter("Liferay.Headless.Admin.Taxonomy", AssetCategory.class.getName(), "v1.0");
            if (dtoConverter == null) {
                return null;
            }
            return dtoConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(dtoConverterContext.isAcceptAllLanguages(), Collections.emptyMap(), dtoConverterRegistry, dtoConverterContext.getHttpServletRequest(), (Object)categoryId, dtoConverterContext.getLocale(), uriInfo, dtoConverterContext.getUser()));
        }
        return null;
    }
}

