/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.filter.parser;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.rest.filter.parser.ObjectDefinitionFilterParser;
import com.liferay.object.rest.odata.entity.v1_0.provider.EntityModelProvider;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.filter.InvalidFilterException;
import com.liferay.portal.odata.filter.expression.Expression;
import com.liferay.portal.odata.filter.expression.ExpressionVisitException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectDefinitionFilterParser.class})
public class ObjectDefinitionFilterParserImpl
implements ObjectDefinitionFilterParser {
    @Reference
    private EntityModelProvider _entityModelProvider;
    @Reference
    private FilterParserProvider _filterParserProvider;

    public Expression parse(EntityModel entityModel, String filterString, ObjectDefinition objectDefinition) throws InvalidFilterException {
        if (Validator.isNull((String)filterString)) {
            return null;
        }
        FilterParser filterParser = this._filterParserProvider.provide(entityModel);
        try {
            return filterParser.parse(filterString);
        }
        catch (ExpressionVisitException expressionVisitException) {
            throw new InvalidFilterException(expressionVisitException.getMessage(), (Throwable)expressionVisitException);
        }
    }

    public Expression parse(String filterString, ObjectDefinition objectDefinition) throws InvalidFilterException {
        if (Validator.isNull((String)filterString)) {
            return null;
        }
        return this.parse(this._entityModelProvider.getEntityModel(objectDefinition), filterString, objectDefinition);
    }
}

