/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.jaxrs.exception.mapper;

import com.liferay.object.exception.ObjectValidationRuleEngineException;
import com.liferay.object.validation.rule.ObjectValidationRuleResult;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.jaxrs.exception.mapper.BaseExceptionMapper;
import com.liferay.portal.vulcan.jaxrs.exception.mapper.Problem;
import java.util.List;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

public class ObjectValidationRuleEngineExceptionMapper
extends BaseExceptionMapper<ObjectValidationRuleEngineException> {
    @Context
    private AcceptLanguage _acceptLanguage;
    private final JSONFactory _jsonFactory;
    private final Language _language;

    public ObjectValidationRuleEngineExceptionMapper(JSONFactory jsonFactory, Language language) {
        this._jsonFactory = jsonFactory;
        this._language = language;
    }

    protected Problem getProblem(ObjectValidationRuleEngineException objectValidationRuleEngineException) {
        List objectValidationRuleResults = objectValidationRuleEngineException.getObjectValidationRuleResults();
        if (ListUtil.isEmpty((List)objectValidationRuleResults)) {
            return new Problem(Response.Status.BAD_REQUEST, this._language.get(this._acceptLanguage.getPreferredLocale(), objectValidationRuleEngineException.getMessageKey(), objectValidationRuleEngineException.getMessage()));
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (ObjectValidationRuleResult objectValidationRuleResult : objectValidationRuleResults) {
            jsonArray.put(JSONUtil.put((String)"errorMessage", (Object)objectValidationRuleResult.getErrorMessage()).put("objectFieldName", objectValidationRuleResult.getObjectFieldName()));
        }
        return new Problem(jsonArray.toString(), Response.Status.BAD_REQUEST, null, ObjectValidationRuleEngineException.class.getName());
    }
}

