/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.resource.v1_0;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.related.models.ObjectRelatedModelsProviderRegistry;
import com.liferay.object.relationship.util.ObjectRelationshipUtil;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.internal.resource.v1_0.BaseObjectEntryRelatedObjectsResourceImpl;
import com.liferay.object.rest.manager.v1_0.DefaultObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.DefaultObjectEntryManagerProvider;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.Serializable;
import java.util.Map;
import javax.ws.rs.core.Context;

public class ObjectEntryRelatedObjectsResourceImpl
extends BaseObjectEntryRelatedObjectsResourceImpl {
    @Context
    private ObjectDefinition _objectDefinition;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectEntryManagerRegistry _objectEntryManagerRegistry;
    private final ObjectRelatedModelsProviderRegistry _objectRelatedModelsProviderRegistry;
    private final ObjectRelationshipLocalService _objectRelationshipLocalService;
    private final PersistedModelLocalServiceRegistry _persistedModelLocalServiceRegistry;

    public ObjectEntryRelatedObjectsResourceImpl(ObjectDefinitionLocalService objectDefinitionLocalService, ObjectEntryManagerRegistry objectEntryManagerRegistry, ObjectRelatedModelsProviderRegistry objectRelatedModelsProviderRegistry, ObjectRelationshipLocalService objectRelationshipLocalService, PersistedModelLocalServiceRegistry persistedModelLocalServiceRegistry) {
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectEntryManagerRegistry = objectEntryManagerRegistry;
        this._objectRelatedModelsProviderRegistry = objectRelatedModelsProviderRegistry;
        this._objectRelationshipLocalService = objectRelationshipLocalService;
        this._persistedModelLocalServiceRegistry = persistedModelLocalServiceRegistry;
    }

    @Override
    public void deleteCurrentObjectEntry(Long currentObjectEntryId, String objectRelationshipName, Long relatedObjectEntryId) throws Exception {
        DefaultObjectEntryManager defaultObjectEntryManager = DefaultObjectEntryManagerProvider.provide((ObjectEntryManager)this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType()));
        this._checkCurrentObjectEntry(defaultObjectEntryManager, currentObjectEntryId);
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(this._objectDefinition.getObjectDefinitionId(), objectRelationshipName);
        ObjectDefinition relatedObjectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId2());
        if (relatedObjectDefinition.isUnmodifiableSystemObject()) {
            this._checkSystemObjectEntry(relatedObjectEntryId, relatedObjectDefinition);
        } else {
            this._checkRelatedObjectEntry(defaultObjectEntryManager, objectRelationshipName, relatedObjectEntryId);
        }
        ObjectRelatedModelsProvider objectRelatedModelsProvider = this._objectRelatedModelsProviderRegistry.getObjectRelatedModelsProvider(relatedObjectDefinition.getClassName(), relatedObjectDefinition.getCompanyId(), objectRelationship.getType());
        objectRelatedModelsProvider.disassociateRelatedModels(this.contextUser.getUserId(), objectRelationship.getObjectRelationshipId(), currentObjectEntryId.longValue(), relatedObjectEntryId.longValue());
    }

    @Override
    public Page<Object> getCurrentObjectEntriesObjectRelationshipNamePage(Long currentObjectEntryId, String objectRelationshipName, Pagination pagination) throws Exception {
        DefaultObjectEntryManager defaultObjectEntryManager = DefaultObjectEntryManagerProvider.provide((ObjectEntryManager)this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType()));
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(this._objectDefinition.getObjectDefinitionId(), objectRelationshipName);
        ObjectDefinition relatedObjectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId2());
        if (relatedObjectDefinition.isUnmodifiableSystemObject()) {
            return defaultObjectEntryManager.getRelatedSystemObjectEntries(this._objectDefinition, currentObjectEntryId, objectRelationshipName, pagination);
        }
        Page page = defaultObjectEntryManager.getObjectEntryRelatedObjectEntries((DTOConverterContext)this._getDTOConverterContext(currentObjectEntryId), this._objectDefinition, currentObjectEntryId, objectRelationshipName, pagination);
        return Page.of((Map)page.getActions(), this.transform(page.getItems(), objectEntry -> this._getRelatedObjectEntry(relatedObjectDefinition, (ObjectEntry)objectEntry)), (Pagination)pagination, (long)page.getTotalCount());
    }

    @Override
    public Object putCurrentObjectEntry(Long currentObjectEntryId, String objectRelationshipName, Long relatedObjectEntryId) throws Exception {
        DefaultObjectEntryManager defaultObjectEntryManager = DefaultObjectEntryManagerProvider.provide((ObjectEntryManager)this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType()));
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(this._objectDefinition.getObjectDefinitionId(), objectRelationshipName);
        ObjectDefinition relatedObjectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId2());
        if (relatedObjectDefinition.isUnmodifiableSystemObject()) {
            return defaultObjectEntryManager.addSystemObjectRelationshipMappingTableValues(relatedObjectDefinition, objectRelationship, currentObjectEntryId.longValue(), relatedObjectEntryId.longValue());
        }
        return this._getRelatedObjectEntry(relatedObjectDefinition, defaultObjectEntryManager.addObjectRelationshipMappingTableValues((DTOConverterContext)this._getDTOConverterContext(currentObjectEntryId), objectRelationship, currentObjectEntryId.longValue(), relatedObjectEntryId.longValue()));
    }

    private void _checkCurrentObjectEntry(DefaultObjectEntryManager defaultObjectEntryManager, long relatedObjectEntryId) throws Exception {
        defaultObjectEntryManager.getObjectEntry((DTOConverterContext)this._getDTOConverterContext(relatedObjectEntryId), this._objectDefinition, relatedObjectEntryId);
    }

    private void _checkRelatedObjectEntry(DefaultObjectEntryManager defaultObjectEntryManager, String objectRelationshipName, long relatedObjectEntryId) throws Exception {
        defaultObjectEntryManager.getObjectEntry((DTOConverterContext)this._getDTOConverterContext(relatedObjectEntryId), ObjectRelationshipUtil.getRelatedObjectDefinition((ObjectDefinition)this._objectDefinition, (ObjectRelationship)this._objectRelationshipLocalService.getObjectRelationship(this._objectDefinition.getObjectDefinitionId(), objectRelationshipName)), relatedObjectEntryId);
    }

    private void _checkSystemObjectEntry(long objectEntryId, ObjectDefinition systemObjectDefinition) throws Exception {
        PersistedModelLocalService persistedModelLocalService = this._persistedModelLocalServiceRegistry.getPersistedModelLocalService(systemObjectDefinition.getClassName());
        persistedModelLocalService.getPersistedModel((Serializable)Long.valueOf(objectEntryId));
    }

    private DefaultDTOConverterContext _getDTOConverterContext(Long objectEntryId) {
        return new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), null, null, this.contextHttpServletRequest, (Object)objectEntryId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser);
    }

    private ObjectEntry _getRelatedObjectEntry(ObjectDefinition objectDefinition, ObjectEntry objectEntry) {
        Map actions = objectEntry.getActions();
        for (Map.Entry entry : actions.entrySet()) {
            Map map = (Map)entry.getValue();
            if (map == null) continue;
            String href = (String)map.get("href");
            map.put("href", StringUtil.replace((String)href, (String)StringUtil.lowerCaseFirstLetter((String)this._objectDefinition.getPluralLabel(this.contextAcceptLanguage.getPreferredLocale())), (String)StringUtil.lowerCaseFirstLetter((String)objectDefinition.getPluralLabel(this.contextAcceptLanguage.getPreferredLocale()))));
        }
        return objectEntry;
    }
}

