/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.resource.v1_0;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.rest.internal.resource.v1_0.BaseObjectEntryResourceImpl;
import com.liferay.object.rest.manager.v1_0.DefaultObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.DefaultObjectEntryManagerProvider;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerRegistry;
import com.liferay.object.rest.odata.entity.v1_0.provider.EntityModelProvider;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipService;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public class ObjectEntryResourceImpl
extends BaseObjectEntryResourceImpl {
    private final DTOConverterRegistry _dtoConverterRegistry;
    private final EntityModelProvider _entityModelProvider;
    @Context
    private ObjectDefinition _objectDefinition;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final ObjectEntryManagerRegistry _objectEntryManagerRegistry;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final ObjectRelationshipService _objectRelationshipService;
    private final ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    private final SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;

    public ObjectEntryResourceImpl(DTOConverterRegistry dtoConverterRegistry, EntityModelProvider entityModelProvider, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectEntryLocalService objectEntryLocalService, ObjectEntryManagerRegistry objectEntryManagerRegistry, ObjectFieldLocalService objectFieldLocalService, ObjectRelationshipService objectRelationshipService, ObjectScopeProviderRegistry objectScopeProviderRegistry, SystemObjectDefinitionManagerRegistry systemObjectDefinitionManagerRegistry) {
        this._dtoConverterRegistry = dtoConverterRegistry;
        this._entityModelProvider = entityModelProvider;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectEntryLocalService = objectEntryLocalService;
        this._objectEntryManagerRegistry = objectEntryManagerRegistry;
        this._objectFieldLocalService = objectFieldLocalService;
        this._objectRelationshipService = objectRelationshipService;
        this._objectScopeProviderRegistry = objectScopeProviderRegistry;
        this._systemObjectDefinitionManagerRegistry = systemObjectDefinitionManagerRegistry;
    }

    @Override
    public void create(Collection<com.liferay.object.rest.dto.v1_0.ObjectEntry> objectEntries, Map<String, Serializable> parameters) throws Exception {
        this._loadObjectDefinition(parameters);
        ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(this._objectDefinition.getScope());
        if (objectScopeProvider.isGroupAware()) {
            UnsafeFunction objectEntryUnsafeFunction = null;
            String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
            if (StringUtil.equalsIgnoreCase((String)createStrategy, (String)"INSERT")) {
                objectEntryUnsafeFunction = objectEntry -> this.postScopeScopeKey((String)parameters.get("scopeKey"), (com.liferay.object.rest.dto.v1_0.ObjectEntry)objectEntry);
            }
            if (StringUtil.equalsIgnoreCase((String)createStrategy, (String)"UPSERT")) {
                objectEntryUnsafeFunction = objectEntry -> this.putScopeScopeKeyByExternalReferenceCode((String)parameters.get("scopeKey"), objectEntry.getExternalReferenceCode(), (com.liferay.object.rest.dto.v1_0.ObjectEntry)objectEntry);
            }
            if (objectEntryUnsafeFunction == null) {
                throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for object entry");
            }
            this.contextBatchUnsafeBiConsumer.accept(objectEntries, (Object)objectEntryUnsafeFunction);
        } else {
            super.create(objectEntries, parameters);
        }
    }

    @Override
    public void delete(Collection<com.liferay.object.rest.dto.v1_0.ObjectEntry> objectEntries, Map<String, Serializable> parameters) throws Exception {
        this._loadObjectDefinition(parameters);
        super.delete(objectEntries, parameters);
    }

    @Override
    public void deleteByExternalReferenceCode(String externalReferenceCode) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType());
        objectEntryManager.deleteObjectEntry(this.contextCompany.getCompanyId(), (DTOConverterContext)this._getDTOConverterContext(null), externalReferenceCode, this._objectDefinition, null);
    }

    @Override
    public void deleteObjectEntry(Long objectEntryId) throws Exception {
        DefaultObjectEntryManager defaultObjectEntryManager = DefaultObjectEntryManagerProvider.provide((ObjectEntryManager)this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType()));
        defaultObjectEntryManager.deleteObjectEntry(this._objectDefinition, objectEntryId.longValue());
    }

    @Override
    public Response deleteObjectEntryBatch(String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setTaskItemDelegateName(this._objectDefinition.getOSGiJaxRsName());
        return super.deleteObjectEntryBatch(callbackURL, object);
    }

    @Override
    public void deleteScopeScopeKeyByExternalReferenceCode(String scopeKey, String externalReferenceCode) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType());
        objectEntryManager.deleteObjectEntry(this.contextCompany.getCompanyId(), (DTOConverterContext)this._getDTOConverterContext(null), externalReferenceCode, this._objectDefinition, scopeKey);
    }

    @Override
    public com.liferay.object.rest.dto.v1_0.ObjectEntry getByExternalReferenceCode(String externalReferenceCode) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType());
        return objectEntryManager.getObjectEntry(this.contextCompany.getCompanyId(), (DTOConverterContext)this._getDTOConverterContext(null), externalReferenceCode, this._objectDefinition, null);
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return this._entityModelProvider.getEntityModel(this._objectDefinition);
    }

    @Override
    public Page<com.liferay.object.rest.dto.v1_0.ObjectEntry> getObjectEntriesPage(Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType());
        String filterString = null;
        if (this.contextHttpServletRequest != null) {
            filterString = ParamUtil.getString((HttpServletRequest)this.contextHttpServletRequest, (String)"filter");
        }
        return objectEntryManager.getObjectEntries(this.contextCompany.getCompanyId(), this._objectDefinition, null, aggregation, (DTOConverterContext)this._getDTOConverterContext(null), filterString, pagination, search, sorts);
    }

    @Override
    public com.liferay.object.rest.dto.v1_0.ObjectEntry getObjectEntry(Long objectEntryId) throws Exception {
        DefaultObjectEntryManager defaultObjectEntryManager = DefaultObjectEntryManagerProvider.provide((ObjectEntryManager)this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType()));
        return defaultObjectEntryManager.getObjectEntry((DTOConverterContext)this._getDTOConverterContext(objectEntryId), this._objectDefinition, objectEntryId.longValue());
    }

    @Override
    public com.liferay.object.rest.dto.v1_0.ObjectEntry getScopeScopeKeyByExternalReferenceCode(String scopeKey, String externalReferenceCode) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType());
        return objectEntryManager.getObjectEntry(this.contextCompany.getCompanyId(), (DTOConverterContext)this._getDTOConverterContext(null), externalReferenceCode, this._objectDefinition, scopeKey);
    }

    @Override
    public Page<com.liferay.object.rest.dto.v1_0.ObjectEntry> getScopeScopeKeyPage(String scopeKey, Boolean flatten, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType());
        return objectEntryManager.getObjectEntries(this.contextCompany.getCompanyId(), this._objectDefinition, scopeKey, aggregation, (DTOConverterContext)this._getDTOConverterContext(null), ParamUtil.getString((HttpServletRequest)this.contextHttpServletRequest, (String)"filter"), pagination, search, sorts);
    }

    @Override
    public com.liferay.object.rest.dto.v1_0.ObjectEntry patchByExternalReferenceCode(String externalReferenceCode, com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType());
        return objectEntryManager.partialUpdateObjectEntry(this.contextCompany.getCompanyId(), (DTOConverterContext)this._getDTOConverterContext(null), externalReferenceCode, this._objectDefinition, objectEntry, null);
    }

    @Override
    public com.liferay.object.rest.dto.v1_0.ObjectEntry patchObjectEntry(Long objectEntryId, com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry) throws Exception {
        DefaultObjectEntryManager defaultObjectEntryManager = DefaultObjectEntryManagerProvider.provide((ObjectEntryManager)this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType()));
        return defaultObjectEntryManager.partialUpdateObjectEntry((DTOConverterContext)this._getDTOConverterContext(objectEntryId), this._objectDefinition, objectEntryId.longValue(), objectEntry);
    }

    @Override
    public com.liferay.object.rest.dto.v1_0.ObjectEntry patchScopeScopeKeyByExternalReferenceCode(String scopeKey, String externalReferenceCode, com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType());
        return objectEntryManager.partialUpdateObjectEntry(this.contextCompany.getCompanyId(), (DTOConverterContext)this._getDTOConverterContext(null), externalReferenceCode, this._objectDefinition, objectEntry, scopeKey);
    }

    @Override
    public Response postObjectEntriesPageExportBatch(String search, Filter filter, Sort[] sorts, String callbackURL, String contentType, String fieldNames) throws Exception {
        this.vulcanBatchEngineExportTaskResource.setTaskItemDelegateName(this._objectDefinition.getOSGiJaxRsName());
        return super.postObjectEntriesPageExportBatch(search, filter, sorts, callbackURL, contentType, fieldNames);
    }

    @Override
    public com.liferay.object.rest.dto.v1_0.ObjectEntry postObjectEntry(com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType());
        return objectEntryManager.addObjectEntry((DTOConverterContext)this._getDTOConverterContext(null), this._objectDefinition, objectEntry, null);
    }

    @Override
    public Response postObjectEntryBatch(String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setTaskItemDelegateName(this._objectDefinition.getOSGiJaxRsName());
        return super.postObjectEntryBatch(callbackURL, object);
    }

    @Override
    public com.liferay.object.rest.dto.v1_0.ObjectEntry postScopeScopeKey(String scopeKey, com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType());
        return objectEntryManager.addObjectEntry((DTOConverterContext)this._getDTOConverterContext(null), this._objectDefinition, objectEntry, scopeKey);
    }

    @Override
    public com.liferay.object.rest.dto.v1_0.ObjectEntry putByExternalReferenceCode(String externalReferenceCode, com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType());
        return objectEntryManager.updateObjectEntry(this.contextCompany.getCompanyId(), (DTOConverterContext)this._getDTOConverterContext(null), externalReferenceCode, this._objectDefinition, objectEntry, null);
    }

    @Override
    public com.liferay.object.rest.dto.v1_0.ObjectEntry putByExternalReferenceCodeCurrentExternalReferenceCodeObjectRelationshipNameRelatedExternalReferenceCode(String currentExternalReferenceCode, String objectRelationshipName, String relatedExternalReferenceCode) throws Exception {
        DefaultObjectEntryManager defaultObjectEntryManager = DefaultObjectEntryManagerProvider.provide((ObjectEntryManager)this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType()));
        ObjectRelationship objectRelationship = this._objectRelationshipService.getObjectRelationship(this._objectDefinition.getObjectDefinitionId(), objectRelationshipName);
        long primaryKey1 = this._getPrimaryKey(currentExternalReferenceCode, objectRelationship.getObjectDefinitionId1());
        long primaryKey2 = this._getPrimaryKey(relatedExternalReferenceCode, objectRelationship.getObjectDefinitionId2());
        return this._getRelatedObjectEntry(this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId2()), defaultObjectEntryManager.addObjectRelationshipMappingTableValues((DTOConverterContext)this._getDTOConverterContext(primaryKey1), objectRelationship, primaryKey1, primaryKey2));
    }

    @Override
    public void putByExternalReferenceCodeObjectEntryExternalReferenceCodeObjectActionObjectActionName(String externalReferenceCode, String objectActionName) throws Exception {
        DefaultObjectEntryManager defaultObjectEntryManager = DefaultObjectEntryManagerProvider.provide((ObjectEntryManager)this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType()));
        defaultObjectEntryManager.executeObjectAction(this.contextCompany.getCompanyId(), (DTOConverterContext)this._getDTOConverterContext(null), externalReferenceCode, objectActionName, this._objectDefinition, null);
    }

    @Override
    public com.liferay.object.rest.dto.v1_0.ObjectEntry putObjectEntry(Long objectEntryId, com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry) throws Exception {
        DefaultObjectEntryManager defaultObjectEntryManager = DefaultObjectEntryManagerProvider.provide((ObjectEntryManager)this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType()));
        return defaultObjectEntryManager.updateObjectEntry((DTOConverterContext)this._getDTOConverterContext(objectEntryId), this._objectDefinition, objectEntryId.longValue(), objectEntry);
    }

    @Override
    public Response putObjectEntryBatch(String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setTaskItemDelegateName(this._objectDefinition.getOSGiJaxRsName());
        return super.putObjectEntryBatch(callbackURL, object);
    }

    @Override
    public void putObjectEntryObjectActionObjectActionName(Long objectEntryId, String objectActionName) throws Exception {
        DefaultObjectEntryManager defaultObjectEntryManager = DefaultObjectEntryManagerProvider.provide((ObjectEntryManager)this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType()));
        defaultObjectEntryManager.executeObjectAction((DTOConverterContext)this._getDTOConverterContext(objectEntryId), objectActionName, this._objectDefinition, objectEntryId.longValue());
    }

    @Override
    public com.liferay.object.rest.dto.v1_0.ObjectEntry putScopeScopeKeyByExternalReferenceCode(String scopeKey, String externalReferenceCode, com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry) throws Exception {
        ObjectEntryManager objectEntryManager = this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType());
        return objectEntryManager.updateObjectEntry(this.contextCompany.getCompanyId(), (DTOConverterContext)this._getDTOConverterContext(null), externalReferenceCode, this._objectDefinition, objectEntry, scopeKey);
    }

    @Override
    public void putScopeScopeKeyByExternalReferenceCodeObjectActionObjectActionName(String scopeKey, String externalReferenceCode, String objectActionName) throws Exception {
        DefaultObjectEntryManager defaultObjectEntryManager = DefaultObjectEntryManagerProvider.provide((ObjectEntryManager)this._objectEntryManagerRegistry.getObjectEntryManager(this._objectDefinition.getStorageType()));
        defaultObjectEntryManager.executeObjectAction(this.contextCompany.getCompanyId(), (DTOConverterContext)this._getDTOConverterContext(null), externalReferenceCode, objectActionName, this._objectDefinition, scopeKey);
    }

    @Override
    public Page<com.liferay.object.rest.dto.v1_0.ObjectEntry> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        this._loadObjectDefinition(parameters);
        ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(this._objectDefinition.getScope());
        if (objectScopeProvider.isGroupAware()) {
            return this.getScopeScopeKeyPage((String)((Object)parameters.get("scopeKey")), Boolean.parseBoolean((String)((Object)parameters.get("flatten"))), search, null, filter, pagination, sorts);
        }
        return this.getObjectEntriesPage(Boolean.parseBoolean((String)((Object)parameters.get("flatten"))), search, null, filter, pagination, sorts);
    }

    public void setObjectDefinition(ObjectDefinition objectDefinition) {
        this._objectDefinition = objectDefinition;
    }

    @Override
    public void update(Collection<com.liferay.object.rest.dto.v1_0.ObjectEntry> objectEntries, Map<String, Serializable> parameters) throws Exception {
        this._loadObjectDefinition(parameters);
        super.update(objectEntries, parameters);
    }

    @Override
    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        ObjectEntry objectEntry = this._objectEntryLocalService.getObjectEntry(GetterUtil.getLong((Object)id));
        return objectEntry.getGroupId();
    }

    @Override
    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        return ObjectDefinition.class.getName() + "#" + this._objectDefinition.getObjectDefinitionId();
    }

    private DefaultDTOConverterContext _getDTOConverterContext(Long objectEntryId) {
        return new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), null, this._dtoConverterRegistry, this.contextHttpServletRequest, (Object)objectEntryId, this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser);
    }

    private long _getPrimaryKey(String externalReferenceCode, long objectDefinitionId) throws Exception {
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(objectDefinitionId);
        if (objectDefinition.isUnmodifiableSystemObject()) {
            SystemObjectDefinitionManager systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(objectDefinition.getName());
            BaseModel baseModel = systemObjectDefinitionManager.getBaseModelByExternalReferenceCode(externalReferenceCode, objectDefinition.getCompanyId());
            return (Long)baseModel.getPrimaryKeyObj();
        }
        ObjectEntry objectEntry = this._objectEntryLocalService.getObjectEntry(externalReferenceCode, objectDefinition.getObjectDefinitionId());
        return objectEntry.getObjectEntryId();
    }

    private com.liferay.object.rest.dto.v1_0.ObjectEntry _getRelatedObjectEntry(ObjectDefinition objectDefinition, com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry) {
        Map actions = objectEntry.getActions();
        for (Map.Entry entry : actions.entrySet()) {
            Map map = (Map)entry.getValue();
            if (map == null) continue;
            String href = (String)map.get("href");
            map.put("href", StringUtil.replace((String)href, (String)StringUtil.lowerCaseFirstLetter((String)this._objectDefinition.getPluralLabel(this.contextAcceptLanguage.getPreferredLocale())), (String)StringUtil.lowerCaseFirstLetter((String)objectDefinition.getPluralLabel(this.contextAcceptLanguage.getPreferredLocale()))));
        }
        return objectEntry;
    }

    private void _loadObjectDefinition(Map<String, Serializable> parameters) throws Exception {
        String[] objectDefinitionIds;
        String parameterValue;
        String taskItemDelegateName = (String)((Object)parameters.get("taskItemDelegateName"));
        if (Validator.isNotNull((String)taskItemDelegateName)) {
            this._objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(this.contextCompany.getCompanyId(), taskItemDelegateName);
            if (this._objectDefinition != null) {
                return;
            }
        }
        if ((parameterValue = (String)((Object)parameters.get("objectDefinitionId"))) != null && parameterValue.length() > 2 && (objectDefinitionIds = StringUtil.split((String)parameterValue.substring(1, parameterValue.length() - 1), (String)",")).length > 0) {
            this._objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(GetterUtil.getLong((String)objectDefinitionIds[0]));
            return;
        }
        throw new NotFoundException("Missing parameter \"objectDefinitionId\"");
    }
}

