/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.vulcan.extension.v1_0;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.vulcan.dto.converter.DTOMapper;
import com.liferay.portal.vulcan.extension.ExtensionProvider;
import java.util.Collection;
import java.util.Collections;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseObjectExtensionProvider
implements ExtensionProvider {
    @Reference
    protected DTOMapper dtoMapper;
    @Reference
    protected JSONFactory jsonFactory;
    @Reference
    protected ObjectDefinitionLocalService objectDefinitionLocalService;

    public Collection<String> getFilteredPropertyNames(long companyId, Object entity) {
        return Collections.emptyList();
    }

    public boolean isApplicableExtension(long companyId, String className) {
        ObjectDefinition objectDefinition = this.fetchObjectDefinition(companyId, className);
        return objectDefinition != null && objectDefinition.isUnmodifiableSystemObject();
    }

    protected ObjectDefinition fetchObjectDefinition(long companyId, String className) {
        if (className == null) {
            return null;
        }
        String internalDTOClassName = this.dtoMapper.toInternalDTOClassName(className);
        if (internalDTOClassName == null) {
            return null;
        }
        return this.objectDefinitionLocalService.fetchObjectDefinitionByClassName(companyId, internalDTOClassName);
    }

    protected long getPrimaryKey(Object entity) throws PortalException {
        JSONObject jsonObject = this.jsonFactory.createJSONObject(this.jsonFactory.looseSerializeDeep(entity));
        return jsonObject.getLong("id");
    }
}

