/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.vulcan.extension.v1_0;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.business.type.ObjectFieldBusinessTypeRegistry;
import com.liferay.object.field.setting.util.ObjectFieldSettingUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.rest.internal.util.ObjectEntryValuesUtil;
import com.liferay.object.rest.internal.vulcan.extension.v1_0.BaseObjectExtensionProvider;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.vulcan.extension.ExtensionProvider;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ExtensionProvider.class, ObjectEntryExtensionProvider.class})
public class ObjectEntryExtensionProvider
extends BaseObjectExtensionProvider {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryExtensionProvider.class);
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectFieldBusinessTypeRegistry _objectFieldBusinessTypeRegistry;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectFieldSettingLocalService _objectFieldSettingLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public Map<String, Serializable> getExtendedProperties(long companyId, String className, Object entity) {
        try {
            ObjectDefinition objectDefinition = this.fetchObjectDefinition(companyId, className);
            Map values = this._objectEntryLocalService.getExtensionDynamicObjectDefinitionTableValues(objectDefinition, this.getPrimaryKey(entity));
            for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId(), false)) {
                if (!Objects.equals(objectField.getRelationshipType(), "oneToMany")) continue;
                values.remove(objectField.getName());
            }
            return values;
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return Collections.emptyMap();
        }
    }

    public Map<String, PropertyDefinition> getExtendedPropertyDefinitions(long companyId, String className) {
        HashMap<String, PropertyDefinition> extendedPropertyDefinitions = new HashMap<String, PropertyDefinition>();
        ObjectDefinition objectDefinition = this.fetchObjectDefinition(companyId, className);
        for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId(), false)) {
            ObjectFieldBusinessType objectFieldBusinessType = this._objectFieldBusinessTypeRegistry.getObjectFieldBusinessType(objectField.getBusinessType());
            extendedPropertyDefinitions.put(objectField.getName(), new PropertyDefinition(null, objectField.getName(), objectFieldBusinessType.getPropertyType(), objectField.isRequired()));
            if (!Objects.equals(objectField.getRelationshipType(), "oneToMany")) continue;
            String objectRelationshipERCObjectFieldName = ObjectFieldSettingUtil.getValue((String)"objectRelationshipERCObjectFieldName", (ObjectField)objectField);
            extendedPropertyDefinitions.put(objectRelationshipERCObjectFieldName, new PropertyDefinition(null, objectRelationshipERCObjectFieldName, PropertyDefinition.PropertyType.TEXT, objectField.isRequired()));
        }
        return extendedPropertyDefinitions;
    }

    public void setExtendedProperties(final long companyId, final long userId, String className, Object entity, Map<String, Serializable> extendedProperties) {
        block3: {
            try {
                ObjectDefinition objectDefinition = this.fetchObjectDefinition(companyId, className);
                for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId(), false)) {
                    Object value = ObjectEntryValuesUtil.getValue(this.objectDefinitionLocalService, this._objectEntryLocalService, objectField, this._objectFieldBusinessTypeRegistry, userId, new HashMap<String, Object>(extendedProperties));
                    if (value == null) continue;
                    extendedProperties.put(objectField.getName(), (Serializable)value);
                }
                this._objectEntryLocalService.addOrUpdateExtensionDynamicObjectDefinitionTableValues(userId, objectDefinition, this.getPrimaryKey(entity), extendedProperties, new ServiceContext(){
                    {
                        this.setCompanyId(companyId);
                        this.setUserId(userId);
                    }
                });
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)portalException);
            }
        }
    }
}

