/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.manager.v1_0;

import com.liferay.account.model.AccountEntryModel;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.object.exception.NoSuchObjectEntryException;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.related.models.ObjectRelatedModelsProviderRegistry;
import com.liferay.object.rest.internal.dto.v1_0.converter.ObjectEntryDTOConverter;
import com.liferay.object.rest.internal.petra.sql.dsl.expression.OrderByExpressionUtil;
import com.liferay.object.rest.internal.resource.v1_0.ObjectEntryResourceImpl;
import com.liferay.object.rest.manager.v1_0.BaseObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.rest.petra.sql.dsl.expression.FilterPredicateFactory;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectEntryService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.service.ObjectRelationshipService;
import com.liferay.object.system.SystemObjectDefinitionMetadata;
import com.liferay.object.system.SystemObjectDefinitionMetadataTracker;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.aggregation.bucket.FilterAggregation;
import com.liferay.portal.search.aggregation.bucket.NestedAggregation;
import com.liferay.portal.search.legacy.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.vulcan.aggregation.Facet;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"object.entry.manager.storage.type=default"}, service={ObjectEntryManager.class})
public class DefaultObjectEntryManagerImpl
extends BaseObjectEntryManager
implements ObjectEntryManager {
    private static final long _NONEXISTING_ACCOUNT_ENTRY_ID = -1L;
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private Aggregations _aggregations;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private FilterPredicateFactory _filterPredicateFactory;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryDTOConverter _objectEntryDTOConverter;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectEntryService _objectEntryService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectRelatedModelsProviderRegistry _objectRelatedModelsProviderRegistry;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private ObjectRelationshipService _objectRelationshipService;
    @Reference
    private Queries _queries;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private SystemObjectDefinitionMetadataTracker _systemObjectDefinitionMetadataTracker;
    @Reference
    private UserLocalService _userLocalService;

    public com.liferay.object.rest.dto.v1_0.ObjectEntry addObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry, String scopeKey) throws Exception {
        return this._toObjectEntry(dtoConverterContext, objectDefinition, this._objectEntryService.addObjectEntry(this.getGroupId(objectDefinition, scopeKey), objectDefinition.getObjectDefinitionId(), this._toObjectValues(objectDefinition.getObjectDefinitionId(), objectEntry.getProperties(), dtoConverterContext.getLocale()), this._createServiceContext(objectEntry.getProperties(), dtoConverterContext.getUserId())));
    }

    public com.liferay.object.rest.dto.v1_0.ObjectEntry addObjectRelationshipMappingTableValues(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, String objectRelationshipName, long primaryKey1, long primaryKey2) throws Exception {
        ObjectRelationship objectRelationship = this._objectRelationshipService.getObjectRelationship(objectDefinition.getObjectDefinitionId(), objectRelationshipName);
        this._objectRelationshipService.addObjectRelationshipMappingTableValues(objectRelationship.getObjectRelationshipId(), primaryKey1, primaryKey2, new ServiceContext());
        return this.getObjectEntry(dtoConverterContext, this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId2()), primaryKey2);
    }

    public com.liferay.object.rest.dto.v1_0.ObjectEntry addOrUpdateObjectEntry(long companyId, DTOConverterContext dtoConverterContext, String externalReferenceCode, ObjectDefinition objectDefinition, com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry, String scopeKey) throws Exception {
        ServiceContext serviceContext = this._createServiceContext(objectEntry.getProperties(), dtoConverterContext.getUserId());
        serviceContext.setCompanyId(companyId);
        return this._toObjectEntry(dtoConverterContext, objectDefinition, this._objectEntryService.addOrUpdateObjectEntry(externalReferenceCode, this.getGroupId(objectDefinition, scopeKey), objectDefinition.getObjectDefinitionId(), this._toObjectValues(objectDefinition.getObjectDefinitionId(), objectEntry.getProperties(), dtoConverterContext.getLocale()), serviceContext));
    }

    public void deleteObjectEntry(ObjectDefinition objectDefinition, long objectEntryId) throws Exception {
        this._checkObjectEntryObjectDefinitionId(objectDefinition, this._objectEntryService.getObjectEntry(objectEntryId));
        this._objectEntryService.deleteObjectEntry(objectEntryId);
    }

    public void deleteObjectEntry(String externalReferenceCode, long companyId, ObjectDefinition objectDefinition, String scopeKey) throws Exception {
        ObjectEntry objectEntry = this._objectEntryService.getObjectEntry(externalReferenceCode, companyId, this.getGroupId(objectDefinition, scopeKey));
        this._checkObjectEntryObjectDefinitionId(objectDefinition, objectEntry);
        this._objectEntryService.deleteObjectEntry(objectEntry.getObjectEntryId());
    }

    public com.liferay.object.rest.dto.v1_0.ObjectEntry fetchObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, long objectEntryId) throws Exception {
        ObjectEntry objectEntry = this._objectEntryService.fetchObjectEntry(objectEntryId);
        if (objectEntry != null) {
            if (objectDefinition == null) {
                objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectEntry.getObjectDefinitionId());
            }
            return this._toObjectEntry(dtoConverterContext, objectDefinition, objectEntry);
        }
        return null;
    }

    public Page<com.liferay.object.rest.dto.v1_0.ObjectEntry> getObjectEntries(long companyId, ObjectDefinition objectDefinition, String scopeKey, com.liferay.portal.vulcan.aggregation.Aggregation aggregation, DTOConverterContext dtoConverterContext, Filter filter, Pagination pagination, String search, Sort[] sorts) throws Exception {
        long groupId = this.getGroupId(objectDefinition, scopeKey);
        return SearchUtil.search((Map)HashMapBuilder.put((Object)"create", (Object)ActionUtil.addAction((String)"ADD_OBJECT_ENTRY", ObjectEntryResourceImpl.class, (Long)0L, (String)"postObjectEntry", null, (Long)objectDefinition.getUserId(), (String)this._getObjectEntriesPermissionName(objectDefinition.getObjectDefinitionId()), (Long)groupId, (UriInfo)dtoConverterContext.getUriInfo())).put((Object)"get", (Object)ActionUtil.addAction((String)"VIEW", ObjectEntryResourceImpl.class, (Long)0L, (String)"getObjectEntriesPage", null, (Long)objectDefinition.getUserId(), (String)this._getObjectEntriesPermissionName(objectDefinition.getObjectDefinitionId()), (Long)groupId, (UriInfo)dtoConverterContext.getUriInfo())).build(), booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("objectDefinitionId", String.valueOf(objectDefinition.getObjectDefinitionId())), BooleanClauseOccur.MUST);
        }, (Filter)filter, (String)objectDefinition.getClassName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setAttribute("status", (Serializable)Integer.valueOf(-1));
            searchContext.setAttribute("objectDefinitionId", (Serializable)Long.valueOf(objectDefinition.getObjectDefinitionId()));
            UriInfo uriInfo = dtoConverterContext.getUriInfo();
            if (uriInfo != null) {
                MultivaluedMap queryParameters = uriInfo.getQueryParameters();
                searchContext.setAttribute("searchByObjectView", (Serializable)Boolean.valueOf(queryParameters.containsKey((Object)"searchByObjectView")));
            }
            searchContext.setCompanyId(companyId);
            searchContext.setGroupIds(new long[]{groupId});
            SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder((SearchContext)searchContext);
            this._processVulcanAggregation(this._aggregations, this._queries, searchRequestBuilder, aggregation);
        }, (Sort[])sorts, document -> this.getObjectEntry(dtoConverterContext, objectDefinition, GetterUtil.getLong((String)document.get("entryClassPK"))));
    }

    public Page<com.liferay.object.rest.dto.v1_0.ObjectEntry> getObjectEntries(long companyId, ObjectDefinition objectDefinition, String scopeKey, com.liferay.portal.vulcan.aggregation.Aggregation aggregation, DTOConverterContext dtoConverterContext, Pagination pagination, Predicate predicate, String search, Sort[] sorts) throws Exception {
        long groupId = this.getGroupId(objectDefinition, scopeKey);
        long[] accountEntryIds = new long[]{-1L};
        if (objectDefinition.isAccountEntryRestricted()) {
            List accountEntries = this._accountEntryLocalService.getUserAccountEntries(dtoConverterContext.getUserId(), Long.valueOf(0L), null, new String[]{"business", "person"}, Integer.valueOf(0), -1, -1);
            accountEntryIds = ListUtil.toLongArray((List)accountEntries, AccountEntryModel::getAccountEntryId);
        }
        int start = -1;
        int end = -1;
        if (pagination != null) {
            start = pagination.getStartPosition();
            end = pagination.getEndPosition();
        }
        ArrayList<Facet> facets = new ArrayList<Facet>();
        if (aggregation != null && aggregation.getAggregationTerms() != null) {
            Map aggregationTerms = aggregation.getAggregationTerms();
            for (Map.Entry entry1 : aggregationTerms.entrySet()) {
                ArrayList<Facet.FacetValue> facetValues = new ArrayList<Facet.FacetValue>();
                Map aggregationCounts = this._objectEntryLocalService.getAggregationCounts(objectDefinition.getObjectDefinitionId(), (String)entry1.getKey(), predicate, start, end);
                for (Map.Entry entry2 : aggregationCounts.entrySet()) {
                    Long value = (Long)entry2.getValue();
                    facetValues.add(new Facet.FacetValue(Integer.valueOf(value.intValue()), String.valueOf(entry2.getKey())));
                }
                facets.add(new Facet((String)entry1.getKey(), facetValues));
            }
        }
        return Page.of((Map)HashMapBuilder.put((Object)"create", (Object)ActionUtil.addAction((String)"ADD_OBJECT_ENTRY", ObjectEntryResourceImpl.class, (Long)0L, (String)"postObjectEntry", null, (Long)objectDefinition.getUserId(), (String)this._getObjectEntriesPermissionName(objectDefinition.getObjectDefinitionId()), (Long)groupId, (UriInfo)dtoConverterContext.getUriInfo())).put((Object)"get", (Object)ActionUtil.addAction((String)"VIEW", ObjectEntryResourceImpl.class, (Long)0L, (String)"getObjectEntriesPage", null, (Long)objectDefinition.getUserId(), (String)this._getObjectEntriesPermissionName(objectDefinition.getObjectDefinitionId()), (Long)groupId, (UriInfo)dtoConverterContext.getUriInfo())).build(), facets, (Collection)TransformUtil.transform((Collection)this._objectEntryLocalService.getValuesList(objectDefinition.getObjectDefinitionId(), groupId, accountEntryIds, predicate, search, start, end, OrderByExpressionUtil.getOrderByExpressions(objectDefinition.getObjectDefinitionId(), this._objectFieldLocalService, sorts)), values -> this._getObjectEntry(dtoConverterContext, objectDefinition, (Map<String, Serializable>)values)), (Pagination)pagination, (long)this._objectEntryLocalService.getValuesListCount(objectDefinition.getObjectDefinitionId(), groupId, accountEntryIds, predicate, search));
    }

    public Page<com.liferay.object.rest.dto.v1_0.ObjectEntry> getObjectEntries(long companyId, ObjectDefinition objectDefinition, String scopeKey, com.liferay.portal.vulcan.aggregation.Aggregation aggregation, DTOConverterContext dtoConverterContext, String filterString, Pagination pagination, String search, Sort[] sorts) throws Exception {
        return this.getObjectEntries(companyId, objectDefinition, scopeKey, aggregation, dtoConverterContext, pagination, this._filterPredicateFactory.create(filterString, objectDefinition.getObjectDefinitionId()), search, sorts);
    }

    public com.liferay.object.rest.dto.v1_0.ObjectEntry getObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, long objectEntryId) throws Exception {
        ObjectEntry objectEntry = this._objectEntryService.getObjectEntry(objectEntryId);
        this._checkObjectEntryObjectDefinitionId(objectDefinition, objectEntry);
        return this._toObjectEntry(dtoConverterContext, objectDefinition, objectEntry);
    }

    public com.liferay.object.rest.dto.v1_0.ObjectEntry getObjectEntry(DTOConverterContext dtoConverterContext, String externalReferenceCode, long companyId, ObjectDefinition objectDefinition, String scopeKey) throws Exception {
        ObjectEntry objectEntry = this._objectEntryService.getObjectEntry(externalReferenceCode, companyId, this.getGroupId(objectDefinition, scopeKey));
        this._checkObjectEntryObjectDefinitionId(objectDefinition, objectEntry);
        return this._toObjectEntry(dtoConverterContext, objectDefinition, objectEntry);
    }

    public Page<com.liferay.object.rest.dto.v1_0.ObjectEntry> getObjectEntryRelatedObjectEntries(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, Long objectEntryId, String objectRelationshipName, Pagination pagination) throws Exception {
        ObjectRelationship objectRelationship = this._objectRelationshipService.getObjectRelationship(objectDefinition.getObjectDefinitionId(), objectRelationshipName);
        ObjectDefinition relatedObjectDefinition = this._getRelatedObjectDefinition(objectDefinition, objectRelationship);
        ObjectRelatedModelsProvider objectRelatedModelsProvider = this._objectRelatedModelsProviderRegistry.getObjectRelatedModelsProvider(relatedObjectDefinition.getClassName(), objectRelationship.getType());
        if (objectDefinition.isSystem()) {
            return this._getSystemObjectRelatedObjectEntries(dtoConverterContext, objectDefinition, objectEntryId, objectRelationship, objectRelatedModelsProvider, pagination);
        }
        ObjectEntry objectEntry = this._objectEntryService.getObjectEntry(objectEntryId.longValue());
        return Page.of((Map)HashMapBuilder.put((Object)"get", (Object)ActionUtil.addAction((String)"VIEW", ObjectEntryResourceImpl.class, (Long)objectEntryId, (String)"getCurrentObjectEntriesObjectRelationshipNamePage", null, (Long)objectEntry.getUserId(), (String)this._getObjectEntryPermissionName(objectDefinition.getObjectDefinitionId()), (Long)objectEntry.getGroupId(), (UriInfo)dtoConverterContext.getUriInfo())).build(), this._toObjectEntries(dtoConverterContext, objectRelatedModelsProvider.getRelatedModels(objectEntry.getGroupId(), objectRelationship.getObjectRelationshipId(), objectEntry.getPrimaryKey(), pagination.getStartPosition(), pagination.getEndPosition())));
    }

    public Page<Object> getRelatedSystemObjectEntries(ObjectDefinition objectDefinition, Long objectEntryId, String objectRelationshipName, Pagination pagination) throws Exception {
        ObjectRelationship objectRelationship = this._objectRelationshipService.getObjectRelationship(objectDefinition.getObjectDefinitionId(), objectRelationshipName);
        ObjectDefinition relatedObjectDefinition = this._getRelatedObjectDefinition(objectDefinition, objectRelationship);
        ObjectRelatedModelsProvider objectRelatedModelsProvider = this._objectRelatedModelsProviderRegistry.getObjectRelatedModelsProvider(relatedObjectDefinition.getClassName(), objectRelationship.getType());
        ObjectEntry objectEntry = this._objectEntryService.getObjectEntry(objectEntryId.longValue());
        return Page.of((Collection)TransformUtil.transform((Collection)objectRelatedModelsProvider.getRelatedModels(objectEntry.getGroupId(), objectRelationship.getObjectRelationshipId(), objectEntry.getPrimaryKey(), pagination.getStartPosition(), pagination.getEndPosition()), baseModel -> this._toDTO((BaseModel<?>)baseModel, objectEntry)));
    }

    public com.liferay.object.rest.dto.v1_0.ObjectEntry updateObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, long objectEntryId, com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry) throws Exception {
        ObjectEntry serviceBuilderObjectEntry = this._objectEntryService.getObjectEntry(objectEntryId);
        this._checkObjectEntryObjectDefinitionId(objectDefinition, serviceBuilderObjectEntry);
        return this._toObjectEntry(dtoConverterContext, objectDefinition, this._objectEntryService.updateObjectEntry(objectEntryId, this._toObjectValues(serviceBuilderObjectEntry.getObjectDefinitionId(), objectEntry.getProperties(), dtoConverterContext.getLocale()), this._createServiceContext(objectEntry.getProperties(), dtoConverterContext.getUserId())));
    }

    private void _checkObjectEntryObjectDefinitionId(ObjectDefinition objectDefinition, ObjectEntry objectEntry) throws Exception {
        if (objectDefinition.getObjectDefinitionId() != objectEntry.getObjectDefinitionId()) {
            throw new NoSuchObjectEntryException();
        }
    }

    private ServiceContext _createServiceContext(Map<String, Object> properties, long userId) {
        ServiceContext serviceContext = new ServiceContext();
        if (properties.get("categoryIds") != null) {
            serviceContext.setAssetCategoryIds(ListUtil.toLongArray((List)((List)properties.get("categoryIds")), Long::parseLong));
        }
        if (properties.get("tagNames") != null) {
            serviceContext.setAssetTagNames(ArrayUtil.toStringArray((Collection)((List)properties.get("tagNames"))));
        }
        serviceContext.setUserId(userId);
        return serviceContext;
    }

    private String _getObjectEntriesPermissionName(long objectDefinitionId) {
        return "com.liferay.object#" + objectDefinitionId;
    }

    private com.liferay.object.rest.dto.v1_0.ObjectEntry _getObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, Map<String, Serializable> values) throws Exception {
        ObjectEntry objectEntry = this._objectEntryService.getObjectEntry(GetterUtil.getLong((Object)values.get(objectDefinition.getPKObjectFieldName())));
        objectEntry.setValues(values);
        this._checkObjectEntryObjectDefinitionId(objectDefinition, objectEntry);
        return this._toObjectEntry(dtoConverterContext, objectDefinition, objectEntry);
    }

    private String _getObjectEntryPermissionName(long objectDefinitionId) {
        return ObjectDefinition.class.getName() + "#" + objectDefinitionId;
    }

    private ObjectDefinition _getRelatedObjectDefinition(ObjectDefinition objectDefinition, ObjectRelationship objectRelationship) throws Exception {
        long objectDefinitionId1 = objectRelationship.getObjectDefinitionId1();
        if (objectDefinitionId1 != objectDefinition.getObjectDefinitionId()) {
            return this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
        }
        return this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId2());
    }

    private Page<com.liferay.object.rest.dto.v1_0.ObjectEntry> _getSystemObjectRelatedObjectEntries(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, long objectEntryId, ObjectRelationship objectRelationship, ObjectRelatedModelsProvider objectRelatedModelsProvider, Pagination pagination) throws Exception {
        long groupId = GroupThreadLocal.getGroupId();
        SystemObjectDefinitionMetadata systemObjectDefinitionMetadata = this._systemObjectDefinitionMetadataTracker.getSystemObjectDefinitionMetadata(objectDefinition.getName());
        AssetEntry assetEntry = this._assetEntryLocalService.getEntry(systemObjectDefinitionMetadata.getModelClassName(), objectEntryId);
        if (Objects.equals(systemObjectDefinitionMetadata.getScope(), "site")) {
            groupId = assetEntry.getGroupId();
        }
        return Page.of(Collections.emptyMap(), this._toObjectEntries(dtoConverterContext, objectRelatedModelsProvider.getRelatedModels(groupId, objectRelationship.getObjectRelationshipId(), assetEntry.getClassPK(), pagination.getStartPosition(), pagination.getEndPosition())));
    }

    private boolean _hasRelatedObjectEntries(String deletionType, ObjectDefinition objectDefinition, ObjectEntry objectEntry) throws PortalException {
        for (ObjectRelationship objectRelationship : this._objectRelationshipLocalService.getObjectRelationships(objectDefinition.getObjectDefinitionId(), deletionType, false)) {
            ObjectRelatedModelsProvider objectRelatedModelsProvider = this._objectRelatedModelsProviderRegistry.getObjectRelatedModelsProvider(objectDefinition.getClassName(), objectRelationship.getType());
            int count = objectRelatedModelsProvider.getRelatedModelsCount(objectEntry.getGroupId(), objectRelationship.getObjectRelationshipId(), objectEntry.getPrimaryKey());
            if (count <= 0) continue;
            return true;
        }
        return false;
    }

    private void _processVulcanAggregation(Aggregations aggregations, Queries queries, SearchRequestBuilder searchRequestBuilder, com.liferay.portal.vulcan.aggregation.Aggregation vulcanAggregation) {
        if (vulcanAggregation == null) {
            return;
        }
        Map aggregationTerms = vulcanAggregation.getAggregationTerms();
        for (Map.Entry entry : aggregationTerms.entrySet()) {
            String value = (String)entry.getValue();
            if (!value.startsWith("nestedFieldArray")) continue;
            NestedAggregation nestedAggregation = aggregations.nested((String)entry.getKey(), "nestedFieldArray");
            String[] valueParts = value.split("#");
            FilterAggregation filterAggregation = aggregations.filter("filterAggregation", (Query)queries.term("nestedFieldArray.fieldName", (Object)valueParts[1]));
            filterAggregation.addChildAggregation((Aggregation)aggregations.terms((String)entry.getKey(), valueParts[0]));
            nestedAggregation.addChildAggregation((Aggregation)filterAggregation);
            searchRequestBuilder.addAggregation((Aggregation)nestedAggregation);
        }
    }

    private Date _toDate(Locale locale, String valueString) {
        if (Validator.isNull((String)valueString)) {
            return null;
        }
        try {
            return DateUtil.parseDate((String)"yyyy-MM-dd'T'HH:mm:ss'Z'", (String)valueString, (Locale)locale);
        }
        catch (ParseException parseException1) {
            try {
                return DateUtil.parseDate((String)"yyyy-MM-dd", (String)valueString, (Locale)locale);
            }
            catch (ParseException parseException2) {
                throw new BadRequestException("Unable to parse date that does not conform to ISO-8601", (Throwable)parseException2);
            }
        }
    }

    private Object _toDTO(BaseModel<?> baseModel, ObjectEntry objectEntry) throws Exception {
        DTOConverter dtoConverter = this._dtoConverterRegistry.getDTOConverter(baseModel.getModelClassName());
        if (dtoConverter == null) {
            throw new InternalServerErrorException("No DTO converter found for " + baseModel.getModelClassName());
        }
        User user = this._userLocalService.getUser(objectEntry.getUserId());
        DefaultDTOConverterContext defaultDTOConverterContext = new DefaultDTOConverterContext(false, Collections.emptyMap(), this._dtoConverterRegistry, (Object)baseModel.getPrimaryKeyObj(), user.getLocale(), null, user);
        return dtoConverter.toDTO((DTOConverterContext)defaultDTOConverterContext, baseModel);
    }

    private List<com.liferay.object.rest.dto.v1_0.ObjectEntry> _toObjectEntries(DTOConverterContext dtoConverterContext, List<ObjectEntry> objectEntries) {
        return TransformUtil.transform(objectEntries, objectEntry -> this._toObjectEntry(dtoConverterContext, this._objectDefinitionLocalService.getObjectDefinition(objectEntry.getObjectDefinitionId()), (ObjectEntry)objectEntry));
    }

    private com.liferay.object.rest.dto.v1_0.ObjectEntry _toObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, ObjectEntry objectEntry) throws Exception {
        DefaultDTOConverterContext defaultDTOConverterContext = new DefaultDTOConverterContext(dtoConverterContext.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"delete", () -> {
            if (this._hasRelatedObjectEntries("prevent", objectDefinition, objectEntry)) {
                return null;
            }
            return ActionUtil.addAction((String)"DELETE", ObjectEntryResourceImpl.class, (Long)objectEntry.getObjectEntryId(), (String)"deleteObjectEntry", null, (Long)objectEntry.getUserId(), (String)this._getObjectEntryPermissionName(objectEntry.getObjectDefinitionId()), (Long)objectEntry.getGroupId(), (UriInfo)dtoConverterContext.getUriInfo());
        }).put((Object)"get", (Object)ActionUtil.addAction((String)"VIEW", ObjectEntryResourceImpl.class, (Long)objectEntry.getObjectEntryId(), (String)"getObjectEntry", null, (Long)objectEntry.getUserId(), (String)this._getObjectEntryPermissionName(objectEntry.getObjectDefinitionId()), (Long)objectEntry.getGroupId(), (UriInfo)dtoConverterContext.getUriInfo())).put((Object)"permissions", (Object)ActionUtil.addAction((String)"PERMISSIONS", ObjectEntryResourceImpl.class, (Long)objectEntry.getObjectEntryId(), (String)"patchObjectEntry", null, (Long)objectEntry.getUserId(), (String)this._getObjectEntryPermissionName(objectEntry.getObjectDefinitionId()), (Long)objectEntry.getGroupId(), (UriInfo)dtoConverterContext.getUriInfo())).put((Object)"update", (Object)ActionUtil.addAction((String)"UPDATE", ObjectEntryResourceImpl.class, (Long)objectEntry.getObjectEntryId(), (String)"putObjectEntry", null, (Long)objectEntry.getUserId(), (String)this._getObjectEntryPermissionName(objectEntry.getObjectDefinitionId()), (Long)objectEntry.getGroupId(), (UriInfo)dtoConverterContext.getUriInfo())).build(), dtoConverterContext.getDTOConverterRegistry(), dtoConverterContext.getHttpServletRequest(), (Object)objectEntry.getObjectEntryId(), dtoConverterContext.getLocale(), dtoConverterContext.getUriInfo(), dtoConverterContext.getUser());
        defaultDTOConverterContext.setAttribute("objectDefinition", (Object)objectDefinition);
        return this._objectEntryDTOConverter.toDTO((DTOConverterContext)defaultDTOConverterContext, objectEntry);
    }

    private Map<String, Serializable> _toObjectValues(long objectDefinitionId, Map<String, Object> properties, Locale locale) {
        List objectFields = this._objectFieldLocalService.getObjectFields(objectDefinitionId);
        HashMap<String, Serializable> values = new HashMap<String, Serializable>();
        for (ObjectField objectField : objectFields) {
            String name = objectField.getName();
            Object object = properties.get(name);
            if (object == null && !objectField.isRequired()) continue;
            if (Objects.equals(objectField.getDBType(), "Date")) {
                values.put(name, this._toDate(locale, String.valueOf(object)));
                continue;
            }
            if (objectField.getListTypeDefinitionId() != 0L && object instanceof Map) {
                HashMap map = (HashMap)object;
                values.put(name, (Serializable)map.get("key"));
                continue;
            }
            values.put(name, (Serializable)object);
        }
        return values;
    }
}

