/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.resource.v1_0;

import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.resource.v1_0.ObjectEntryResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

public abstract class BaseObjectEntryResourceImpl
implements EntityModelResource,
ObjectEntryResource,
VulcanBatchEngineTaskItemDelegate<ObjectEntry> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<ObjectEntry>, UnsafeConsumer<ObjectEntry, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseObjectEntryResourceImpl.class);

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="aggregationTerms"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="ObjectEntry")})
    @GET
    @Path(value="")
    @Produces(value={"application/json", "application/xml"})
    public Page<ObjectEntry> getObjectEntriesPage(@Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Tags(value={@Tag(name="ObjectEntry")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public ObjectEntry postObjectEntry(ObjectEntry objectEntry) throws Exception {
        return new ObjectEntry();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="ObjectEntry")})
    @Consumes(value={"application/json"})
    @Path(value="/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postObjectEntryBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(ObjectEntry.class.getName(), callbackURL, null, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="ObjectEntry")})
    @DELETE
    @Path(value="/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="ObjectEntry")})
    @GET
    @Path(value="/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public ObjectEntry getByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new ObjectEntry();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="ObjectEntry")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public ObjectEntry putByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, ObjectEntry objectEntry) throws Exception {
        return new ObjectEntry();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="scopeKey"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="ObjectEntry")})
    @DELETE
    @Path(value="/scopes/{scopeKey}/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteScopeScopeKeyByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="scopeKey") String scopeKey, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="scopeKey"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="ObjectEntry")})
    @GET
    @Path(value="/scopes/{scopeKey}/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public ObjectEntry getScopeScopeKeyByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="scopeKey") String scopeKey, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new ObjectEntry();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="scopeKey"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="ObjectEntry")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/scopes/{scopeKey}/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public ObjectEntry putScopeScopeKeyByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="scopeKey") String scopeKey, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, ObjectEntry objectEntry) throws Exception {
        return new ObjectEntry();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="currentObjectEntryId"), @Parameter(in=ParameterIn.PATH, name="objectRelationshipName"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Tags(value={@Tag(name="ObjectEntry")})
    @GET
    @Path(value="/{currentObjectEntryId}/{objectRelationshipName}")
    @Produces(value={"application/json", "application/xml"})
    public Page<ObjectEntry> getCurrentObjectEntriesObjectRelationshipNamePage(@Parameter(hidden=true) @NotNull @PathParam(value="currentObjectEntryId") Long currentObjectEntryId, @Parameter(hidden=true) @NotNull @PathParam(value="objectRelationshipName") String objectRelationshipName, @Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="currentObjectEntryId"), @Parameter(in=ParameterIn.PATH, name="objectRelationshipName"), @Parameter(in=ParameterIn.PATH, name="relatedObjectEntryId")})
    @Tags(value={@Tag(name="ObjectEntry")})
    @Path(value="/{currentObjectEntryId}/{objectRelationshipName}/{relatedObjectEntryId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public ObjectEntry putCurrentObjectEntry(@Parameter(hidden=true) @NotNull @PathParam(value="currentObjectEntryId") Long currentObjectEntryId, @Parameter(hidden=true) @NotNull @PathParam(value="objectRelationshipName") String objectRelationshipName, @Parameter(hidden=true) @NotNull @PathParam(value="relatedObjectEntryId") Long relatedObjectEntryId) throws Exception {
        return new ObjectEntry();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="objectEntryId")})
    @Tags(value={@Tag(name="ObjectEntry")})
    @DELETE
    @Path(value="/{objectEntryId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteObjectEntry(@Parameter(hidden=true) @NotNull @PathParam(value="objectEntryId") Long objectEntryId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="ObjectEntry")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/batch")
    @Produces(value={"application/json"})
    public Response deleteObjectEntryBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(ObjectEntry.class.getName(), callbackURL, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="objectEntryId")})
    @Tags(value={@Tag(name="ObjectEntry")})
    @GET
    @Path(value="/{objectEntryId}")
    @Produces(value={"application/json", "application/xml"})
    public ObjectEntry getObjectEntry(@Parameter(hidden=true) @NotNull @PathParam(value="objectEntryId") Long objectEntryId) throws Exception {
        return new ObjectEntry();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="objectEntryId")})
    @Tags(value={@Tag(name="ObjectEntry")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/{objectEntryId}")
    @Produces(value={"application/json", "application/xml"})
    public ObjectEntry patchObjectEntry(@Parameter(hidden=true) @NotNull @PathParam(value="objectEntryId") Long objectEntryId, ObjectEntry objectEntry) throws Exception {
        ObjectEntry existingObjectEntry = this.getObjectEntry(objectEntryId);
        if (objectEntry.getActions() != null) {
            existingObjectEntry.setActions(objectEntry.getActions());
        }
        if (objectEntry.getDateCreated() != null) {
            existingObjectEntry.setDateCreated(objectEntry.getDateCreated());
        }
        if (objectEntry.getDateModified() != null) {
            existingObjectEntry.setDateModified(objectEntry.getDateModified());
        }
        if (objectEntry.getExternalReferenceCode() != null) {
            existingObjectEntry.setExternalReferenceCode(objectEntry.getExternalReferenceCode());
        }
        if (objectEntry.getProperties() != null) {
            existingObjectEntry.setProperties(objectEntry.getProperties());
        }
        if (objectEntry.getScopeKey() != null) {
            existingObjectEntry.setScopeKey(objectEntry.getScopeKey());
        }
        this.preparePatch(objectEntry, existingObjectEntry);
        return this.putObjectEntry(objectEntryId, existingObjectEntry);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="objectEntryId")})
    @Tags(value={@Tag(name="ObjectEntry")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/{objectEntryId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public ObjectEntry putObjectEntry(@Parameter(hidden=true) @NotNull @PathParam(value="objectEntryId") Long objectEntryId, ObjectEntry objectEntry) throws Exception {
        return new ObjectEntry();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="ObjectEntry")})
    @Consumes(value={"application/json"})
    @Path(value="/batch")
    @Produces(value={"application/json"})
    @PUT
    public Response putObjectEntryBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(ObjectEntry.class.getName(), callbackURL, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="scopeKey"), @Parameter(in=ParameterIn.QUERY, name="aggregationTerms"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="ObjectEntry")})
    @GET
    @Path(value="/scopes/{scopeKey}")
    @Produces(value={"application/json", "application/xml"})
    public Page<ObjectEntry> getScopeScopeKeyPage(@Parameter(hidden=true) @PathParam(value="scopeKey") String scopeKey, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="scopeKey")})
    @Tags(value={@Tag(name="ObjectEntry")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/scopes/{scopeKey}")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public ObjectEntry postScopeScopeKey(@Parameter(hidden=true) @PathParam(value="scopeKey") String scopeKey, ObjectEntry objectEntry) throws Exception {
        return new ObjectEntry();
    }

    public void create(Collection<ObjectEntry> objectEntries, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer objectEntryUnsafeConsumer = null;
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if ("INSERT".equalsIgnoreCase(createStrategy)) {
            objectEntryUnsafeConsumer = objectEntry -> this.postObjectEntry((ObjectEntry)objectEntry);
        }
        if ("UPSERT".equalsIgnoreCase(createStrategy)) {
            objectEntryUnsafeConsumer = objectEntry -> this.putByExternalReferenceCode(objectEntry.getExternalReferenceCode(), (ObjectEntry)objectEntry);
        }
        if (objectEntryUnsafeConsumer == null) {
            throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for ObjectEntry");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(objectEntries, (Object)objectEntryUnsafeConsumer);
        } else {
            for (ObjectEntry objectEntry2 : objectEntries) {
                objectEntryUnsafeConsumer.accept((Object)objectEntry2);
            }
        }
    }

    public void delete(Collection<ObjectEntry> objectEntries, Map<String, Serializable> parameters) throws Exception {
        for (ObjectEntry objectEntry : objectEntries) {
            this.deleteObjectEntry(objectEntry.getId());
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"UPSERT", "INSERT"});
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"PARTIAL_UPDATE", "UPDATE"});
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<ObjectEntry> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<ObjectEntry> objectEntries, Map<String, Serializable> parameters) throws Exception {
        UnsafeConsumer objectEntryUnsafeConsumer = null;
        String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
        if ("PARTIAL_UPDATE".equalsIgnoreCase(updateStrategy)) {
            objectEntryUnsafeConsumer = objectEntry -> this.patchObjectEntry(objectEntry.getId() != null ? objectEntry.getId() : Long.parseLong((String)parameters.get("objectEntryId")), (ObjectEntry)objectEntry);
        }
        if ("UPDATE".equalsIgnoreCase(updateStrategy)) {
            objectEntryUnsafeConsumer = objectEntry -> this.putObjectEntry(objectEntry.getId() != null ? objectEntry.getId() : Long.parseLong((String)parameters.get("objectEntryId")), (ObjectEntry)objectEntry);
        }
        if (objectEntryUnsafeConsumer == null) {
            throw new NotSupportedException("Update strategy \"" + updateStrategy + "\" is not supported for ObjectEntry");
        }
        if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(objectEntries, (Object)objectEntryUnsafeConsumer);
        } else {
            for (ObjectEntry objectEntry2 : objectEntries) {
                objectEntryUnsafeConsumer.accept((Object)objectEntry2);
            }
        }
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<ObjectEntry>, UnsafeConsumer<ObjectEntry, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(ObjectEntry objectEntry, ObjectEntry existingObjectEntry) {
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }
}

