/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.vulcan.extension.v1_0;

import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.business.type.ObjectFieldBusinessTypeTracker;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.vulcan.dto.converter.DTOMapper;
import com.liferay.portal.vulcan.extension.ExtensionProvider;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ExtensionProvider.class})
public class ObjectEntryExtensionProvider
implements ExtensionProvider {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryExtensionProvider.class);
    @Reference
    private DTOMapper _dtoMapper;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectFieldBusinessTypeTracker _objectFieldBusinessTypeTracker;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;

    public Map<String, Serializable> getExtendedProperties(long companyId, String className, Object entity) {
        try {
            return this._objectEntryLocalService.getExtensionDynamicObjectDefinitionTableValues(this._getObjectDefinition(companyId, className), this._getPrimaryKey(entity));
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return Collections.emptyMap();
        }
    }

    public Map<String, PropertyDefinition> getExtendedPropertyDefinitions(long companyId, String className) {
        HashMap<String, PropertyDefinition> extendedPropertyDefinitions = new HashMap<String, PropertyDefinition>();
        ObjectDefinition objectDefinition = this._getObjectDefinition(companyId, className);
        for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId())) {
            if (objectField.isSystem()) continue;
            ObjectFieldBusinessType objectFieldBusinessType = this._objectFieldBusinessTypeTracker.getObjectFieldBusinessType(objectField.getBusinessType());
            extendedPropertyDefinitions.put(objectField.getName(), new PropertyDefinition(null, objectField.getName(), objectFieldBusinessType.getPropertyType(), objectField.isRequired()));
        }
        return extendedPropertyDefinitions;
    }

    public Collection<String> getFilteredPropertyNames(long companyId, Object entity) {
        return Collections.emptyList();
    }

    public boolean isApplicableExtension(long companyId, String className) {
        if (!GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-135404"))) {
            return false;
        }
        ObjectDefinition objectDefinition = this._getObjectDefinition(companyId, className);
        return objectDefinition != null && objectDefinition.isSystem();
    }

    public void setExtendedProperties(final long companyId, final long userId, String className, Object entity, Map<String, Serializable> extendedProperties) {
        block2: {
            try {
                this._objectEntryLocalService.addOrUpdateExtensionDynamicObjectDefinitionTableValues(userId, this._getObjectDefinition(companyId, className), this._getPrimaryKey(entity), extendedProperties, new ServiceContext(){
                    {
                        this.setCompanyId(companyId);
                        this.setUserId(userId);
                    }
                });
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)portalException);
            }
        }
    }

    private ObjectDefinition _getObjectDefinition(long companyId, String className) {
        String internalDTOClassName = this._dtoMapper.toInternalDTOClassName(className);
        if (internalDTOClassName == null) {
            return null;
        }
        try {
            return this._objectDefinitionLocalService.fetchObjectDefinitionByClassName(companyId, internalDTOClassName);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }

    private long _getPrimaryKey(Object entity) throws PortalException {
        JSONObject jsonObject = this._jsonFactory.createJSONObject(this._jsonFactory.looseSerializeDeep(entity));
        return jsonObject.getLong("id");
    }
}

