/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.action.engine;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFieldAccessor;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionParameterAccessor;
import com.liferay.object.action.engine.ObjectActionEngine;
import com.liferay.object.action.executor.ObjectActionExecutor;
import com.liferay.object.action.executor.ObjectActionExecutorRegistry;
import com.liferay.object.dynamic.data.mapping.expression.ObjectEntryDDMExpressionFieldAccessor;
import com.liferay.object.entry.util.ObjectEntryThreadLocal;
import com.liferay.object.exception.ObjectActionExecutorKeyException;
import com.liferay.object.internal.action.util.ObjectActionThreadLocal;
import com.liferay.object.internal.action.util.ObjectEntryVariablesUtil;
import com.liferay.object.internal.dynamic.data.mapping.expression.ObjectEntryDDMExpressionParameterAccessor;
import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.scope.CompanyScoped;
import com.liferay.object.scope.ObjectDefinitionScoped;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectActionEngine.class})
public class ObjectActionEngineImpl
implements ObjectActionEngine {
    private static final Log _log = LogFactoryUtil.getLog(ObjectActionEngineImpl.class);
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ObjectActionExecutorRegistry _objectActionExecutorRegistry;
    @Reference
    private ObjectActionLocalService _objectActionLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private PermissionCheckerFactory _permissionCheckerFactory;
    @Reference
    private SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;
    @Reference
    private UserLocalService _userLocalService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeObjectAction(String objectActionName, String objectActionTriggerKey, long objectDefinitionId, JSONObject payloadJSONObject, long userId) throws Exception {
        ObjectAction objectAction = this._objectActionLocalService.getObjectAction(objectDefinitionId, objectActionName, objectActionTriggerKey);
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectDefinitionId);
        this._updatePayloadJSONObject(objectDefinition, payloadJSONObject, this._userLocalService.getUser(userId));
        try {
            ObjectEntryThreadLocal.setSkipObjectEntryResourcePermission((boolean)true);
            this._executeObjectAction(objectAction, objectDefinition, payloadJSONObject, userId, ObjectEntryVariablesUtil.getVariables(this._dtoConverterRegistry, objectDefinition, payloadJSONObject, this._systemObjectDefinitionManagerRegistry));
        }
        finally {
            ObjectEntryThreadLocal.setSkipObjectEntryResourcePermission((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeObjectActions(String className, long companyId, String objectActionTriggerKey, JSONObject payloadJSONObject, long userId) {
        if (companyId == 0L || userId == 0L) {
            return;
        }
        User user = this._userLocalService.fetchUser(userId);
        if (user == null || companyId != user.getCompanyId()) {
            return;
        }
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinitionByClassName(user.getCompanyId(), className);
        if (objectDefinition == null) {
            return;
        }
        String name = PrincipalThreadLocal.getName();
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        boolean skipReadOnlyObjectFieldsValidation = ObjectEntryThreadLocal.isSkipReadOnlyObjectFieldsValidation();
        try {
            ObjectEntryThreadLocal.setSkipObjectEntryResourcePermission((boolean)true);
            ObjectEntryThreadLocal.setSkipReadOnlyObjectFieldsValidation((boolean)true);
            PrincipalThreadLocal.setName((long)userId);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._permissionCheckerFactory.create(user));
            this._updatePayloadJSONObject(objectDefinition, payloadJSONObject, user);
            Map<String, Object> variables = ObjectEntryVariablesUtil.getVariables(this._dtoConverterRegistry, objectDefinition, payloadJSONObject, this._systemObjectDefinitionManagerRegistry);
            for (ObjectAction objectAction : this._objectActionLocalService.getObjectActions(objectDefinition.getObjectDefinitionId(), objectActionTriggerKey)) {
                try {
                    this._executeObjectAction(objectAction, objectDefinition, payloadJSONObject, userId, variables);
                }
                catch (Exception exception) {
                    _log.error((Throwable)exception);
                }
            }
        }
        finally {
            ObjectEntryThreadLocal.setSkipObjectEntryResourcePermission((boolean)false);
            ObjectEntryThreadLocal.setSkipReadOnlyObjectFieldsValidation((boolean)skipReadOnlyObjectFieldsValidation);
            PrincipalThreadLocal.setName((String)name);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
    }

    private boolean _evaluateConditionExpression(String conditionExpression, Map<String, Object> variables) throws Exception {
        if (Validator.isNull((String)conditionExpression)) {
            return true;
        }
        DDMExpression ddmExpression = this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)conditionExpression).withDDMExpressionFieldAccessor((DDMExpressionFieldAccessor)new ObjectEntryDDMExpressionFieldAccessor((Map)variables.get("baseModel"))).withDDMExpressionParameterAccessor((DDMExpressionParameterAccessor)new ObjectEntryDDMExpressionParameterAccessor((Map)variables.get("originalBaseModel"))).build());
        ddmExpression.setVariables((Map)variables.get("baseModel"));
        return (Boolean)ddmExpression.evaluate();
    }

    private void _executeObjectAction(ObjectAction objectAction, ObjectDefinition objectDefinition, JSONObject payloadJSONObject, long userId, Map<String, Object> variables) throws Exception {
        Set<Long> objectEntryIds;
        Map<Long, Set<Long>> objectEntryIdsMap = ObjectActionThreadLocal.getObjectEntryIdsMap();
        if (!StringUtil.equals((String)objectAction.getObjectActionTriggerKey(), (String)"onAfterUpdate") && objectEntryIdsMap.containsKey(objectAction.getObjectActionId())) {
            return;
        }
        long objectEntryId = this._getObjectEntryId(objectDefinition, payloadJSONObject);
        if (StringUtil.equals((String)objectAction.getObjectActionTriggerKey(), (String)"onAfterUpdate") && SetUtil.isNotEmpty(objectEntryIds = objectEntryIdsMap.get(objectAction.getObjectActionId())) && objectEntryIds.contains(objectEntryId)) {
            return;
        }
        try {
            ObjectDefinitionScoped objectActionExecutorObjectDefinitionScoped;
            CompanyScoped objectActionExecutorCompanyScoped;
            if (!this._evaluateConditionExpression(objectAction.getConditionExpression(), variables)) {
                return;
            }
            ObjectActionThreadLocal.addObjectEntryId(objectAction.getObjectActionId(), objectEntryId);
            ObjectActionExecutor objectActionExecutor = this._objectActionExecutorRegistry.getObjectActionExecutor(objectAction.getCompanyId(), objectAction.getObjectActionExecutorKey());
            if (objectActionExecutor instanceof CompanyScoped && !(objectActionExecutorCompanyScoped = (CompanyScoped)objectActionExecutor).isAllowedCompany(objectDefinition.getCompanyId())) {
                throw new ObjectActionExecutorKeyException(StringBundler.concat((Object[])new Object[]{"The object action executor key ", objectActionExecutor.getKey(), " is not allowed for company ", objectDefinition.getCompanyId()}));
            }
            if (objectActionExecutor instanceof ObjectDefinitionScoped && !(objectActionExecutorObjectDefinitionScoped = (ObjectDefinitionScoped)objectActionExecutor).isAllowedObjectDefinition(objectDefinition.getName())) {
                throw new ObjectActionExecutorKeyException(StringBundler.concat((String[])new String[]{"The object action executor key ", objectActionExecutor.getKey(), " is not allowed for object definition ", objectDefinition.getName()}));
            }
            objectActionExecutor.execute(objectDefinition.getCompanyId(), objectAction.getObjectActionId(), objectAction.getParametersUnicodeProperties(), payloadJSONObject, userId);
            this._objectActionLocalService.updateStatus(objectAction.getObjectActionId(), 1);
        }
        catch (Exception exception) {
            this._objectActionLocalService.updateStatus(objectAction.getObjectActionId(), 2);
            throw exception;
        }
    }

    private long _getObjectEntryId(ObjectDefinition objectDefinition, JSONObject payloadJSONObject) {
        if (objectDefinition.isUnmodifiableSystemObject()) {
            Map map = (Map)payloadJSONObject.get("model" + objectDefinition.getName());
            return (Long)map.get(objectDefinition.getPKObjectFieldName());
        }
        Map map = (Map)payloadJSONObject.get("objectEntry");
        return GetterUtil.getLong(map.get("id"), (long)((Long)map.get("objectEntryId")));
    }

    private void _updatePayloadJSONObject(ObjectDefinition objectDefinition, JSONObject payloadJSONObject, User user) {
        payloadJSONObject.put("companyId", objectDefinition.getCompanyId()).put("objectDefinitionId", objectDefinition.getObjectDefinitionId()).put("status", objectDefinition.getStatus()).put("userId", user.getUserId()).put("userName", user.getFullName());
    }
}

