/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.definition.tree;

import com.liferay.object.definition.tree.Edge;
import com.liferay.object.definition.tree.Node;
import com.liferay.object.definition.tree.Tree;
import com.liferay.object.definition.tree.TreeFactory;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={TreeFactory.class})
public class TreeFactoryImpl
implements TreeFactory {
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;

    public Tree create(long rootObjectDefinitionId) throws PortalException {
        Node rootNode = new Node(null, rootObjectDefinitionId, null);
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.add(rootNode);
        while (!queue.isEmpty()) {
            Node node = (Node)queue.poll();
            List<Node> nodes = this._getChildrenNodes(node);
            if (!ListUtil.isNotEmpty(nodes)) continue;
            node.setChildNodes(nodes);
            queue.addAll(nodes);
        }
        return new Tree(rootNode);
    }

    private List<Node> _getChildrenNodes(Node node) {
        return TransformUtil.transform((Collection)this._objectRelationshipLocalService.getObjectRelationships(node.getObjectDefinitionId(), true), objectRelationship -> new Node(new Edge(objectRelationship.getObjectRelationshipId()), objectRelationship.getObjectDefinitionId2(), node));
    }
}

