/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.definition.util;

import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Map;
import java.util.Objects;

public class ObjectDefinitionUtil {
    private static final Map<String, String> _allowedModifiableSystemObjectDefinitionNames = HashMapBuilder.put((Object)"APIApplication", (Object)"/headless-builder/applications").put((Object)"APIEndpoint", (Object)"/headless-builder/endpoints").put((Object)"APIFilter", (Object)"/headless-builder/filters").put((Object)"APIProperty", (Object)"/headless-builder/properties").put((Object)"APISchema", (Object)"/headless-builder/schemas").put((Object)"APISort", (Object)"/headless-builder/sorts").put((Object)"Bookmark", (Object)"/bookmarks").put((Object)"FDSDateFilter", (Object)"/data-set-manager/date-filters").put((Object)"FDSDynamicFilter", (Object)"/data-set-manager/dynamic-filters").put((Object)"FDSEntry", (Object)"/data-set-manager/entries").put((Object)"FDSField", (Object)"/data-set-manager/fields").put((Object)"FDSSort", (Object)"/data-set-manager/sorts").put((Object)"FDSView", (Object)"/data-set-manager/views").build();
    private static final Map<String, String> _allowedUnmodifiableSystemObjectDefinitionNames = HashMapBuilder.put((Object)"AccountEntry", (Object)"L_ACCOUNT").put((Object)"Address", (Object)"L_POSTAL_ADDRESS").put((Object)"CommerceOrder", (Object)"L_COMMERCE_ORDER").put((Object)"CommercePricingClass", (Object)"L_COMMERCE_PRODUCT_GROUP").put((Object)"CPDefinition", (Object)"L_COMMERCE_PRODUCT_DEFINITION").put((Object)"Organization", (Object)"L_ORGANIZATION").put((Object)"User", (Object)"L_USER").build();

    public static String getModifiableSystemObjectDefinitionRESTContextPath(String name) {
        if (PortalRunMode.isTestMode() && Objects.equals(name, "Test")) {
            return "/test";
        }
        return _allowedModifiableSystemObjectDefinitionNames.get(name);
    }

    public static boolean isAllowedModifiableSystemObjectDefinitionName(String name) {
        if (PortalRunMode.isTestMode() && Objects.equals(name, "Test")) {
            return true;
        }
        return _allowedModifiableSystemObjectDefinitionNames.containsKey(name);
    }

    public static boolean isAllowedUnmodifiableSystemObjectDefinitionExternalReferenceCode(String externalReferenceCode, String name) {
        if (PortalRunMode.isTestMode()) {
            return true;
        }
        return StringUtil.equals((String)_allowedUnmodifiableSystemObjectDefinitionNames.get(name), (String)externalReferenceCode);
    }
}

