/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectFolder;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectFolderLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class ObjectFolderModelListener
extends BaseModelListener<ObjectFolder> {
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectFolderLocalService _objectFolderLocalService;

    public void onAfterRemove(ObjectFolder objectFolder) throws ModelListenerException {
        try {
            ObjectFolder uncategorizedObjectFolder = this._objectFolderLocalService.addOrGetUncategorizedObjectFolder(objectFolder.getCompanyId());
            for (ObjectDefinition objectDefinition : this._objectDefinitionLocalService.getObjectFolderObjectDefinitions(objectFolder.getObjectFolderId())) {
                this._objectDefinitionLocalService.updateObjectFolderId(objectDefinition.getObjectDefinitionId(), uncategorizedObjectFolder.getObjectFolderId());
            }
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    public void onAfterUpdate(ObjectFolder originalObjectFolder, ObjectFolder objectFolder) throws ModelListenerException {
        try {
            for (ObjectDefinition objectDefinition : this._objectDefinitionLocalService.getObjectFolderObjectDefinitions(objectFolder.getObjectFolderId())) {
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(ObjectDefinition.class);
                indexer.reindex((Object)objectDefinition);
            }
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }
}

