/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.related.models;

import com.liferay.object.exception.RequiredObjectRelationshipException;
import com.liferay.object.internal.entry.util.ObjectEntrySearchUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionTable;
import com.liferay.object.related.models.ManyToOneObjectRelatedModelsProvider;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SystemObject1toMObjectRelatedModelsProviderImpl<T extends BaseModel<T>>
implements ManyToOneObjectRelatedModelsProvider<T>,
ObjectRelatedModelsProvider<T> {
    private final ObjectDefinition _objectDefinition;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final ObjectRelationshipLocalService _objectRelationshipLocalService;
    private final PersistedModelLocalServiceRegistry _persistedModelLocalServiceRegistry;
    private final SystemObjectDefinitionManager _systemObjectDefinitionManager;
    private final SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;
    private final Table _table;

    public SystemObject1toMObjectRelatedModelsProviderImpl(ObjectDefinition objectDefinition, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectEntryLocalService objectEntryLocalService, ObjectFieldLocalService objectFieldLocalService, ObjectRelationshipLocalService objectRelationshipLocalService, PersistedModelLocalServiceRegistry persistedModelLocalServiceRegistry, SystemObjectDefinitionManager systemObjectDefinitionManager, SystemObjectDefinitionManagerRegistry systemObjectDefinitionManagerRegistry) {
        this._objectDefinition = objectDefinition;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectEntryLocalService = objectEntryLocalService;
        this._objectFieldLocalService = objectFieldLocalService;
        this._objectRelationshipLocalService = objectRelationshipLocalService;
        this._persistedModelLocalServiceRegistry = persistedModelLocalServiceRegistry;
        this._systemObjectDefinitionManager = systemObjectDefinitionManager;
        this._systemObjectDefinitionManagerRegistry = systemObjectDefinitionManagerRegistry;
        this._table = systemObjectDefinitionManager.getTable();
    }

    public void deleteRelatedModel(long userId, long groupId, long objectRelationshipId, long primaryKey, String deletionType) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        List<T> relatedModels = this.getRelatedModels(groupId, objectRelationshipId, primaryKey, null, -1, -1);
        if (relatedModels.isEmpty()) {
            return;
        }
        if (Objects.equals(deletionType, "cascade")) {
            SystemObjectDefinitionManager systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(this._objectDefinition.getName());
            for (BaseModel baseModel : relatedModels) {
                systemObjectDefinitionManager.deleteBaseModel(baseModel);
            }
        } else if (Objects.equals(deletionType, "disassociate")) {
            ObjectField objectField = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
            for (BaseModel baseModel : relatedModels) {
                this._objectEntryLocalService.insertIntoOrUpdateExtensionTable(userId, objectRelationship.getObjectDefinitionId2(), GetterUtil.getLong((Object)baseModel.getPrimaryKeyObj()), (Map)HashMapBuilder.put((Object)objectField.getName(), (Object)0).build());
            }
        } else if (Objects.equals(deletionType, "prevent")) {
            throw new RequiredObjectRelationshipException(StringBundler.concat((Object[])new Object[]{"Object relationship ", objectRelationship.getObjectRelationshipId(), " does not allow deletes"}));
        }
    }

    public void disassociateRelatedModels(long userId, long objectRelationshipId, long primaryKey1, long primaryKey2) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        this._objectEntryLocalService.insertIntoOrUpdateExtensionTable(userId, objectRelationship.getObjectDefinitionId2(), GetterUtil.getLong((Object)primaryKey2), (Map)HashMapBuilder.put(() -> {
            ObjectField objectField = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
            return objectField.getName();
        }, (Object)0).build());
    }

    public T fetchRelatedModel(long groupId, long objectRelationshipId, long primaryKey) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        ObjectDefinition relatedObjectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId2());
        if (relatedObjectDefinition.isUnmodifiableSystemObject()) {
            throw new UnsupportedOperationException();
        }
        PersistedModelLocalService persistedModelLocalService = this._persistedModelLocalServiceRegistry.getPersistedModelLocalService(this._systemObjectDefinitionManager.getModelClassName());
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable(relatedObjectDefinition.getObjectDefinitionId());
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
        Column column = dynamicObjectDefinitionTable.getColumn(StringBundler.concat((String[])new String[]{"r_", objectRelationship.getName(), "_", objectDefinition.getPKObjectFieldName()}));
        if (column == null) {
            dynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(relatedObjectDefinition.getObjectDefinitionId());
        }
        FromStep fromStep = DSLQueryFactoryUtil.selectDistinct((Table)this._table);
        ObjectField objectField = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
        Column primaryKeyColumn = dynamicObjectDefinitionTable.getPrimaryKeyColumn();
        List relatedModels = (List)persistedModelLocalService.dslQuery((DSLQuery)fromStep.from(this._table).innerJoinON((Table)dynamicObjectDefinitionTable, this._systemObjectDefinitionManager.getPrimaryKeyColumn().eq((Expression)dynamicObjectDefinitionTable.getColumn(objectField.getDBColumnName()))).where(primaryKeyColumn.eq((Object)primaryKey).and((Expression)this._table.getColumn("companyId").eq((Object)groupId))));
        if (relatedModels.isEmpty()) {
            return null;
        }
        return (T)((BaseModel)relatedModels.get(0));
    }

    public String getClassName() {
        return this._systemObjectDefinitionManager.getModelClassName();
    }

    public long getCompanyId() {
        return this._objectDefinition.getCompanyId();
    }

    public String getObjectRelationshipType() {
        return "oneToMany";
    }

    public List<T> getRelatedModels(long groupId, long objectRelationshipId, long primaryKey, String search, int start, int end) throws PortalException {
        PersistedModelLocalService persistedModelLocalService = this._persistedModelLocalServiceRegistry.getPersistedModelLocalService(this._systemObjectDefinitionManager.getModelClassName());
        DSLQuery dslQuery = this._getGroupByStep(this._getDynamicObjectDefinitionTable(), DSLQueryFactoryUtil.selectDistinct((Table)this._table), groupId, objectRelationshipId, primaryKey, search).limit(start, end);
        return (List)persistedModelLocalService.dslQuery(dslQuery);
    }

    public int getRelatedModelsCount(long groupId, long objectRelationshipId, long primaryKey, String search) throws PortalException {
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable();
        PersistedModelLocalService persistedModelLocalService = this._persistedModelLocalServiceRegistry.getPersistedModelLocalService(this._systemObjectDefinitionManager.getModelClassName());
        return persistedModelLocalService.dslQueryCount((DSLQuery)this._getGroupByStep(dynamicObjectDefinitionTable, DSLQueryFactoryUtil.countDistinct((Expression)dynamicObjectDefinitionTable.getPrimaryKeyColumn()), groupId, objectRelationshipId, primaryKey, search));
    }

    public List<T> getUnrelatedModels(long companyId, long groupId, ObjectDefinition objectDefinition, long objectEntryId, long objectRelationshipId) throws PortalException {
        Column companyIdColumn = this._table.getColumn("companyId");
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        ObjectDefinition objectDefinition1 = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
        PersistedModelLocalService persistedModelLocalService = this._persistedModelLocalServiceRegistry.getPersistedModelLocalService(objectDefinition.getClassName());
        return (List)persistedModelLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)this._table).from(this._table).where(companyIdColumn.eq((Object)companyId).and(() -> {
            Column groupIdColumn = this._table.getColumn("groupId");
            if (groupIdColumn == null || Objects.equals("company", objectDefinition1.getScope())) {
                return null;
            }
            return groupIdColumn.eq((Object)groupId);
        }).and(() -> {
            Column primaryKeyColumn = this._table.getColumn(objectDefinition.getPKObjectFieldDBColumnName());
            DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable();
            ObjectField objectField = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
            Column foreignKeyColumn = dynamicObjectDefinitionTable.getColumn(objectField.getDBColumnName());
            return primaryKeyColumn.notIn((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{dynamicObjectDefinitionTable.getPrimaryKeyColumn()}).from((Table)dynamicObjectDefinitionTable).where(foreignKeyColumn.neq((Object)0L)));
        })));
    }

    private DynamicObjectDefinitionTable _getDynamicObjectDefinitionTable() throws PortalException {
        return new DynamicObjectDefinitionTable(this._objectDefinition, this._objectFieldLocalService.getObjectFields(this._objectDefinition.getObjectDefinitionId(), this._objectDefinition.getExtensionDBTableName()), this._objectDefinition.getExtensionDBTableName());
    }

    private DynamicObjectDefinitionTable _getDynamicObjectDefinitionTable(long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectDefinitionId);
        return new DynamicObjectDefinitionTable(objectDefinition, this._objectFieldLocalService.getObjectFields(objectDefinitionId, objectDefinition.getDBTableName()), objectDefinition.getDBTableName());
    }

    private DynamicObjectDefinitionTable _getExtensionDynamicObjectDefinitionTable(long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectDefinitionId);
        return new DynamicObjectDefinitionTable(objectDefinition, this._objectFieldLocalService.getObjectFields(objectDefinitionId, objectDefinition.getExtensionDBTableName()), objectDefinition.getExtensionDBTableName());
    }

    private GroupByStep _getGroupByStep(DynamicObjectDefinitionTable dynamicObjectDefinitionTable, FromStep fromStep, long groupId, long objectRelationshipId, long primaryKey, String search) throws PortalException {
        Column primaryKeyColumn = null;
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        ObjectDefinition objectDefinition1 = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
        ObjectField objectField = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
        primaryKeyColumn = Objects.equals(objectField.getDBTableName(), this._table) ? this._table.getColumn(objectField.getDBColumnName()) : dynamicObjectDefinitionTable.getColumn(objectField.getDBColumnName());
        return fromStep.from(this._table).innerJoinON((Table)dynamicObjectDefinitionTable, dynamicObjectDefinitionTable.getPrimaryKeyColumn().eq((Expression)this._systemObjectDefinitionManager.getPrimaryKeyColumn())).where(primaryKeyColumn.eq((Object)primaryKey).and(() -> {
            Column groupIdColumn = this._table.getColumn("groupId");
            if (groupIdColumn == null || Objects.equals("company", objectDefinition1.getScope())) {
                return null;
            }
            return groupIdColumn.eq((Object)groupId);
        }).and(() -> {
            Column companyIdColumn = this._table.getColumn("companyId");
            if (companyIdColumn == null) {
                return null;
            }
            return companyIdColumn.eq((Object)objectField.getCompanyId());
        }).and((Expression)ObjectEntrySearchUtil.getRelatedModelsPredicate(dynamicObjectDefinitionTable, this._objectDefinitionLocalService.fetchObjectDefinition(objectRelationship.getObjectDefinitionId2()), this._objectFieldLocalService, search)));
    }
}

