/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.related.models;

import com.liferay.object.exception.RequiredObjectRelationshipException;
import com.liferay.object.internal.entry.util.ObjectEntrySearchUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionTable;
import com.liferay.object.petra.sql.dsl.DynamicObjectRelationshipMappingTable;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import java.util.List;
import java.util.Objects;

public class SystemObjectMtoMObjectRelatedModelsProviderImpl<T extends BaseModel<T>>
implements ObjectRelatedModelsProvider<T> {
    private final ObjectDefinition _objectDefinition;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final ObjectRelationshipLocalService _objectRelationshipLocalService;
    private final PersistedModelLocalServiceRegistry _persistedModelLocalServiceRegistry;
    private final SystemObjectDefinitionManager _systemObjectDefinitionManager;
    private final SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;
    private final Table _table;

    public SystemObjectMtoMObjectRelatedModelsProviderImpl(ObjectDefinition objectDefinition, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectFieldLocalService objectFieldLocalService, ObjectRelationshipLocalService objectRelationshipLocalService, PersistedModelLocalServiceRegistry persistedModelLocalServiceRegistry, SystemObjectDefinitionManager systemObjectDefinitionManager, SystemObjectDefinitionManagerRegistry systemObjectDefinitionManagerRegistry) {
        this._objectDefinition = objectDefinition;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectFieldLocalService = objectFieldLocalService;
        this._objectRelationshipLocalService = objectRelationshipLocalService;
        this._persistedModelLocalServiceRegistry = persistedModelLocalServiceRegistry;
        this._systemObjectDefinitionManager = systemObjectDefinitionManager;
        this._systemObjectDefinitionManagerRegistry = systemObjectDefinitionManagerRegistry;
        this._table = systemObjectDefinitionManager.getTable();
    }

    public void deleteRelatedModel(long userId, long groupId, long objectRelationshipId, long primaryKey, String deletionType) throws PortalException {
        List<T> relatedModels = this.getRelatedModels(groupId, objectRelationshipId, primaryKey, null, -1, -1);
        if (relatedModels.isEmpty()) {
            return;
        }
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        if (Objects.equals(deletionType, "prevent") && !objectRelationship.isReverse()) {
            throw new RequiredObjectRelationshipException(StringBundler.concat((Object[])new Object[]{"Object relationship ", objectRelationship.getObjectRelationshipId(), " does not allow deletes"}));
        }
        this._objectRelationshipLocalService.deleteObjectRelationshipMappingTableValues(objectRelationshipId, primaryKey);
        if (Objects.equals(deletionType, "cascade") && !objectRelationship.isReverse()) {
            SystemObjectDefinitionManager systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(this._objectDefinition.getName());
            for (BaseModel baseModel : relatedModels) {
                systemObjectDefinitionManager.deleteBaseModel(baseModel);
            }
        }
    }

    public void disassociateRelatedModels(long userId, long objectRelationshipId, long primaryKey1, long primaryKey2) throws PortalException {
        this._objectRelationshipLocalService.deleteObjectRelationshipMappingTableValues(objectRelationshipId, primaryKey1, primaryKey2);
    }

    public String getClassName() {
        return this._systemObjectDefinitionManager.getModelClassName();
    }

    public long getCompanyId() {
        return this._objectDefinition.getCompanyId();
    }

    public String getObjectRelationshipType() {
        return "manyToMany";
    }

    public List<T> getRelatedModels(long groupId, long objectRelationshipId, long primaryKey, String search, int start, int end) throws PortalException {
        PersistedModelLocalService persistedModelLocalService = this._persistedModelLocalServiceRegistry.getPersistedModelLocalService(this._systemObjectDefinitionManager.getModelClassName());
        return (List)persistedModelLocalService.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)this._table), groupId, objectRelationshipId, primaryKey, search).limit(start, end));
    }

    public int getRelatedModelsCount(long groupId, long objectRelationshipId, long primaryKey, String search) throws PortalException {
        PersistedModelLocalService persistedModelLocalService = this._persistedModelLocalServiceRegistry.getPersistedModelLocalService(this._systemObjectDefinitionManager.getModelClassName());
        return persistedModelLocalService.dslQueryCount((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.countDistinct((Expression)this._table.getColumn(this._objectDefinition.getPKObjectFieldDBColumnName())), groupId, objectRelationshipId, primaryKey, search));
    }

    public List<T> getUnrelatedModels(long companyId, long groupId, ObjectDefinition objectDefinition, long objectEntryId, long objectRelationshipId) throws PortalException {
        Column companyIdColumn = this._table.getColumn("companyId");
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        ObjectDefinition objectDefinition1 = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
        DynamicObjectRelationshipMappingTable dynamicObjectRelationshipMappingTable = new DynamicObjectRelationshipMappingTable(objectDefinition1.getPKObjectFieldDBColumnName(), objectDefinition.getPKObjectFieldDBColumnName(), objectRelationship.getDBTableName());
        PersistedModelLocalService persistedModelLocalService = this._persistedModelLocalServiceRegistry.getPersistedModelLocalService(objectDefinition.getClassName());
        return (List)persistedModelLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)this._table).from(this._table).where(companyIdColumn.eq((Object)companyId).and(() -> {
            Column groupIdColumn = this._table.getColumn("groupId");
            if (groupIdColumn == null || Objects.equals("company", objectDefinition1.getScope())) {
                return null;
            }
            return groupIdColumn.eq((Object)groupId);
        }).and(() -> {
            String primaryKeyColumnName1 = objectDefinition1.getPKObjectFieldDBColumnName();
            Column primaryKeyColumn1 = dynamicObjectRelationshipMappingTable.getColumn(primaryKeyColumnName1);
            String primaryKeyColumnName2 = objectDefinition.getPKObjectFieldDBColumnName();
            Column primaryKeyColumn2 = this._table.getColumn(primaryKeyColumnName2);
            return primaryKeyColumn2.notIn((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{dynamicObjectRelationshipMappingTable.getColumn(objectDefinition.getPKObjectFieldDBColumnName())}).from((Table)dynamicObjectRelationshipMappingTable).where(primaryKeyColumn1.eq((Object)objectEntryId)));
        })));
    }

    private GroupByStep _getGroupByStep(FromStep fromStep, long groupId, long objectRelationshipId, long primaryKey, String search) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        ObjectDefinition objectDefinition1 = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
        ObjectDefinition objectDefinition2 = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId2());
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = new DynamicObjectDefinitionTable(objectDefinition2, this._objectFieldLocalService.getObjectFields(objectRelationship.getObjectDefinitionId2(), objectDefinition2.getDBTableName()), objectDefinition2.getDBTableName());
        DynamicObjectRelationshipMappingTable dynamicObjectRelationshipMappingTable = new DynamicObjectRelationshipMappingTable(objectDefinition1.getPKObjectFieldDBColumnName(), objectDefinition2.getPKObjectFieldDBColumnName(), objectRelationship.getDBTableName());
        Column primaryKeyColumn1 = dynamicObjectRelationshipMappingTable.getPrimaryKeyColumn1();
        Column primaryKeyColumn2 = dynamicObjectRelationshipMappingTable.getPrimaryKeyColumn2();
        return fromStep.from((Table)dynamicObjectDefinitionTable).innerJoinON((Table)dynamicObjectRelationshipMappingTable, primaryKeyColumn2.eq((Expression)dynamicObjectDefinitionTable.getPrimaryKeyColumn())).where(primaryKeyColumn1.eq((Object)primaryKey).and(() -> {
            Column groupIdColumn = this._table.getColumn("groupId");
            if (groupIdColumn == null || Objects.equals("company", objectDefinition1.getScope())) {
                return null;
            }
            return groupIdColumn.eq((Object)groupId);
        }).and(() -> {
            Column companyIdColumn = this._table.getColumn("companyId");
            if (companyIdColumn == null) {
                return null;
            }
            return companyIdColumn.eq((Object)objectRelationship.getCompanyId());
        }).and((Expression)ObjectEntrySearchUtil.getRelatedModelsPredicate(dynamicObjectDefinitionTable, objectDefinition2, this._objectFieldLocalService, search)));
    }
}

