/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.security.permission.resource;

import com.liferay.object.model.ObjectFolder;
import com.liferay.object.service.ObjectFolderLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectFolder"}, service={ModelResourcePermission.class})
public class ObjectFolderModelResourcePermission
implements ModelResourcePermission<ObjectFolder> {
    @Reference
    private ObjectFolderLocalService _objectFolderLocalService;
    @Reference(target="(resource.name=com.liferay.object)")
    private PortletResourcePermission _portletResourcePermission;

    public void check(PermissionChecker permissionChecker, long objectFolderId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, objectFolderId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, ObjectFolder.class.getName(), objectFolderId, new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, ObjectFolder objectFolder, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, objectFolder, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, ObjectFolder.class.getName(), objectFolder.getPrimaryKey(), new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long objectFolderId, String actionId) throws PortalException {
        ObjectFolder objectFolder = objectFolderId == 0L ? this._objectFolderLocalService.addOrGetUncategorizedObjectFolder(permissionChecker.getCompanyId()) : this._objectFolderLocalService.getObjectFolder(objectFolderId);
        return this.contains(permissionChecker, objectFolder, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, ObjectFolder objectFolder, String actionId) throws PortalException {
        return objectFolder.isUncategorized() || permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), ObjectFolder.class.getName(), objectFolder.getPrimaryKey(), objectFolder.getUserId(), actionId) || permissionChecker.hasPermission(null, ObjectFolder.class.getName(), objectFolder.getPrimaryKey(), actionId);
    }

    public String getModelName() {
        return ObjectFolder.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }
}

