/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.security.permission.resource.util;

import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.SAXReaderUtil;

public class ObjectDefinitionResourcePermissionUtil {
    public static void populateResourceActions(ObjectActionLocalService objectActionLocalService, ObjectDefinition objectDefinition, PortletLocalService portletLocalService, ResourceActions resourceActions) throws Exception {
        ClassLoader classLoader = ObjectDefinitionResourcePermissionUtil.class.getClassLoader();
        String objectActionPermissionKeys = "";
        for (ObjectAction objectAction : objectActionLocalService.getObjectActions(objectDefinition.getObjectDefinitionId(), "standalone")) {
            objectActionPermissionKeys = StringBundler.concat((String[])new String[]{objectActionPermissionKeys, "<action-key>", objectAction.getName(), "</action-key>"});
        }
        String resourceActionsFileName = "resource-actions/resource-actions.xml.tpl";
        if (!StringUtil.equals((String)objectDefinition.getStorageType(), (String)"default")) {
            resourceActionsFileName = "resource-actions/resource-actions-nondefault-storage-type.xml.tpl";
        }
        Document document = SAXReaderUtil.read((String)StringUtil.replace((String)StringUtil.read((ClassLoader)classLoader, (String)resourceActionsFileName), (String[])new String[]{"[$MODEL_NAME$]", "[$PERMISSIONS_GUEST_UNSUPPORTED$]", "[$PERMISSIONS_SUPPORTS$]", "[$PORTLET_NAME$]", "[$RESOURCE_NAME$]"}, (String[])new String[]{objectDefinition.getClassName(), ObjectDefinitionResourcePermissionUtil._getPermissionsGuestUnsupported(objectDefinition) + objectActionPermissionKeys, ObjectDefinitionResourcePermissionUtil._getPermissionsSupports(objectDefinition) + objectActionPermissionKeys, objectDefinition.getPortletId(), objectDefinition.getResourceName()}));
        resourceActions.populateModelResources(document);
        Portlet portlet = portletLocalService.getPortletById(objectDefinition.getCompanyId(), objectDefinition.getPortletId());
        if (portlet != null) {
            resourceActions.populatePortletResource(portlet, classLoader, document);
        }
    }

    private static String _getPermissionsGuestUnsupported(ObjectDefinition objectDefinition) {
        if (!objectDefinition.isEnableComments()) {
            return "";
        }
        return "<action-key>DELETE_DISCUSSION</action-key><action-key>UPDATE_DISCUSSION</action-key>";
    }

    private static String _getPermissionsSupports(ObjectDefinition objectDefinition) {
        String permissionsSupports = "";
        if (objectDefinition.isEnableComments()) {
            permissionsSupports = StringBundler.concat((String[])new String[]{"<action-key>ADD_DISCUSSION</action-key>", "<action-key>DELETE_DISCUSSION</action-key>", "<action-key>UPDATE_DISCUSSION</action-key>"});
        }
        if (objectDefinition.isEnableObjectEntryHistory()) {
            permissionsSupports = StringBundler.concat((String[])new String[]{permissionsSupports, "<action-key>", "OBJECT_ENTRY_HISTORY", "</action-key>"});
        }
        return permissionsSupports;
    }
}

