/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryOrganizationRelTable;
import com.liferay.account.model.AccountEntryTable;
import com.liferay.account.model.AccountEntryUserRelTable;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.link.service.AssetLinkLocalService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.util.NumberUtil;
import com.liferay.list.type.model.ListTypeEntry;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.configuration.ObjectConfiguration;
import com.liferay.object.entry.util.ObjectEntryThreadLocal;
import com.liferay.object.exception.NoSuchObjectFieldException;
import com.liferay.object.exception.ObjectDefinitionScopeException;
import com.liferay.object.exception.ObjectEntryValuesException;
import com.liferay.object.exception.ObjectRelationshipDeletionTypeException;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.business.type.ObjectFieldBusinessTypeRegistry;
import com.liferay.object.field.setting.util.ObjectFieldSettingUtil;
import com.liferay.object.internal.action.util.ObjectActionThreadLocal;
import com.liferay.object.internal.entry.util.ObjectEntrySearchUtil;
import com.liferay.object.internal.filter.parser.ObjectFilterParser;
import com.liferay.object.internal.petra.sql.dsl.DynamicObjectDefinitionLocalizationTableFactory;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryTable;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.model.ObjectFilter;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.model.ObjectState;
import com.liferay.object.model.ObjectStateFlow;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionLocalizationTable;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionTable;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionTableUtil;
import com.liferay.object.petra.sql.dsl.DynamicObjectRelationshipMappingTable;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.related.models.ObjectRelatedModelsProviderRegistry;
import com.liferay.object.relationship.util.ObjectRelationshipUtil;
import com.liferay.object.rest.filter.factory.FilterFactory;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.object.service.ObjectStateFlowLocalService;
import com.liferay.object.service.ObjectStateLocalService;
import com.liferay.object.service.base.ObjectEntryLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.object.service.persistence.ObjectFieldPersistence;
import com.liferay.object.service.persistence.ObjectFieldSettingPersistence;
import com.liferay.object.service.persistence.ObjectRelationshipPersistence;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Alias;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.expression.ScalarDSLQueryAlias;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.petra.sql.dsl.spi.expression.Scalar;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.dao.jdbc.postgresql.PostgreSQLJDBCUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnection;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.encryptor.Encryptor;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.OrganizationTable;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.Users_OrgsTable;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.security.auth.GuestOrUserUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.InlineSQLHelper;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.object.configuration.ObjectConfiguration"}, property={"model.class.name=com.liferay.object.model.ObjectEntry"}, service={AopService.class})
public class ObjectEntryLocalServiceImpl
extends ObjectEntryLocalServiceBaseImpl {
    private static final Expression<?>[] _EXPRESSIONS = new Expression[]{ObjectEntryTable.INSTANCE.objectEntryId, ObjectEntryTable.INSTANCE.userName, ObjectEntryTable.INSTANCE.createDate, ObjectEntryTable.INSTANCE.modifiedDate, ObjectEntryTable.INSTANCE.externalReferenceCode, ObjectEntryTable.INSTANCE.status};
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryLocalServiceImpl.class);
    private static final ThreadLocal<Boolean> _skipModelListeners = new CentralizedThreadLocal(ObjectEntryLocalServiceImpl.class + "._skipModelListeners", () -> false);
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private CurrentConnection _currentConnection;
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLFolderLocalService _dlFolderLocalService;
    @Reference
    private Encryptor _encryptor;
    @Reference(target="(filter.factory.key=default)")
    private FilterFactory<Predicate> _filterFactory;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private InlineSQLHelper _inlineSQLHelper;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private ListTypeEntryLocalService _listTypeEntryLocalService;
    @Reference
    private Localization _localization;
    private volatile ObjectConfiguration _objectConfiguration;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectFieldBusinessTypeRegistry _objectFieldBusinessTypeRegistry;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectFieldPersistence _objectFieldPersistence;
    @Reference
    private ObjectFieldSettingLocalService _objectFieldSettingLocalService;
    @Reference
    private ObjectFieldSettingPersistence _objectFieldSettingPersistence;
    @Reference
    private ObjectRelatedModelsProviderRegistry _objectRelatedModelsProviderRegistry;
    @Reference
    private ObjectRelationshipPersistence _objectRelationshipPersistence;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    @Reference
    private ObjectStateFlowLocalService _objectStateFlowLocalService;
    @Reference
    private ObjectStateLocalService _objectStateLocalService;
    @Reference
    private PersistedModelLocalServiceRegistry _persistedModelLocalServiceRegistry;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private Searcher _searcher;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    private ServiceTrackerMap<String, ObjectFilterParser> _serviceTrackerMap;
    @Reference
    private Sorts _sorts;
    @Reference
    private SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    public ObjectEntry addObjectEntry(long userId, long groupId, long objectDefinitionId, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        this._validateGroupId(groupId, objectDefinition.getScope());
        User user = this._userLocalService.getUser(userId);
        this._fillDefaultValue(this._objectFieldLocalService.getObjectFields(objectDefinitionId), values);
        this._validateValues(user.isGuestUser(), objectDefinitionId, null, objectDefinition.getPortletId(), serviceContext, userId, values);
        long objectEntryId = this.counterLocalService.increment();
        this._insertIntoLocalizationTable(objectDefinition, objectEntryId, values);
        this._insertIntoTable(this._getDynamicObjectDefinitionTable(objectDefinitionId), objectEntryId, user, values);
        this._insertIntoTable(this._getExtensionDynamicObjectDefinitionTable(objectDefinitionId), objectEntryId, user, values);
        ObjectEntry objectEntry = this.objectEntryPersistence.create(objectEntryId);
        this._setExternalReferenceCode(objectEntry, values);
        objectEntry.setGroupId(groupId);
        objectEntry.setCompanyId(user.getCompanyId());
        objectEntry.setUserId(user.getUserId());
        objectEntry.setUserName(user.getFullName());
        objectEntry.setCreateDate(new Date());
        objectEntry.setObjectDefinitionId(objectDefinitionId);
        objectEntry.setStatus(2);
        objectEntry.setStatusByUserId(user.getUserId());
        objectEntry.setStatusDate(serviceContext.getModifiedDate(null));
        this._resourceLocalService.addResources(objectEntry.getCompanyId(), objectEntry.getGroupId(), objectEntry.getUserId(), objectDefinition.getClassName(), objectEntry.getPrimaryKey(), false, false, false);
        objectEntry = (ObjectEntry)this.objectEntryPersistence.update((BaseModel)objectEntry);
        this.updateAsset(serviceContext.getUserId(), objectEntry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        this._startWorkflowInstance(userId, objectEntry, serviceContext);
        this._reindex(objectEntry);
        ObjectActionThreadLocal.clearObjectEntryIdsMap();
        return objectEntry;
    }

    public ObjectEntry addObjectEntry(String externalReferenceCode, long userId, ObjectDefinition objectDefinition) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryPersistence.create(this.counterLocalService.increment());
        objectEntry.setExternalReferenceCode(externalReferenceCode);
        User user = this._userLocalService.getUser(userId);
        objectEntry.setCompanyId(user.getCompanyId());
        objectEntry.setUserId(user.getUserId());
        objectEntry.setUserName(user.getFullName());
        objectEntry.setObjectDefinitionId(objectDefinition.getObjectDefinitionId());
        objectEntry.setStatus(2);
        objectEntry.setStatusDate(new Date());
        return this.objectEntryPersistence.updateImpl(objectEntry);
    }

    public void addOrUpdateExtensionDynamicObjectDefinitionTableValues(long userId, ObjectDefinition objectDefinition, long primaryKey, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        this._validateValues(user.isGuestUser(), objectDefinition.getObjectDefinitionId(), null, objectDefinition.getClassName(), serviceContext, userId, values);
        this.insertIntoOrUpdateExtensionTable(userId, objectDefinition.getObjectDefinitionId(), primaryKey, values);
    }

    public ObjectEntry addOrUpdateObjectEntry(String externalReferenceCode, long userId, long groupId, long objectDefinitionId, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        if (groupId != 0L) {
            Group group = this._groupLocalService.getGroup(groupId);
            if (user.getCompanyId() != group.getCompanyId()) {
                throw new PrincipalException();
            }
        }
        ObjectEntry objectEntry = null;
        if (Validator.isNotNull((String)externalReferenceCode) && (objectEntry = this.objectEntryPersistence.fetchByERC_C_ODI(externalReferenceCode, user.getCompanyId(), objectDefinitionId)) != null) {
            return this.updateObjectEntry(userId, objectEntry.getObjectEntryId(), values, serviceContext);
        }
        objectEntry = this.addObjectEntry(userId, groupId, objectDefinitionId, values, serviceContext);
        if (Validator.isNotNull((String)externalReferenceCode)) {
            objectEntry.setExternalReferenceCode(externalReferenceCode);
            objectEntry = (ObjectEntry)this.objectEntryPersistence.update((BaseModel)objectEntry);
        }
        this._reindex(objectEntry);
        return objectEntry;
    }

    public void deleteExtensionDynamicObjectDefinitionTableValues(ObjectDefinition objectDefinition, long primaryKey) throws PortalException {
        Map<String, Serializable> extensionDynamicObjectDefinitionTableValues = this.getExtensionDynamicObjectDefinitionTableValues(objectDefinition, primaryKey);
        this._deleteFromTable(objectDefinition.getExtensionDBTableName(), objectDefinition.getPKObjectFieldDBColumnName(), primaryKey);
        this.deleteRelatedObjectEntries(0L, objectDefinition.getObjectDefinitionId(), primaryKey);
        this._deleteFileEntries(Collections.emptyMap(), objectDefinition.getObjectDefinitionId(), extensionDynamicObjectDefinitionTableValues);
    }

    @Override
    public ObjectEntry deleteObjectEntry(long objectEntryId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryPersistence.findByPrimaryKey(objectEntryId);
        return this.objectEntryLocalService.deleteObjectEntry(objectEntry);
    }

    @Override
    @SystemEvent(type=1)
    public ObjectEntry deleteObjectEntry(ObjectEntry objectEntry) throws PortalException {
        Map values = objectEntry.getValues();
        objectEntry = (ObjectEntry)this.objectEntryPersistence.remove((BaseModel)objectEntry);
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectEntry.getObjectDefinitionId());
        this._resourceLocalService.deleteResource(objectEntry.getCompanyId(), objectDefinition.getClassName(), 4, objectEntry.getObjectEntryId());
        this._assetEntryLocalService.deleteEntry(objectDefinition.getClassName(), objectEntry.getObjectEntryId());
        this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(objectEntry.getCompanyId(), objectEntry.getNonzeroGroupId(), objectDefinition.getClassName(), objectEntry.getObjectEntryId());
        this._deleteFromTable(objectDefinition.getDBTableName(), objectDefinition.getPKObjectFieldDBColumnName(), objectEntry.getObjectEntryId());
        this._deleteFromTable(objectDefinition.getExtensionDBTableName(), objectDefinition.getPKObjectFieldDBColumnName(), objectEntry.getObjectEntryId());
        if (objectDefinition.isEnableLocalization()) {
            this._deleteFromTable(objectDefinition.getLocalizationDBTableName(), objectDefinition.getPKObjectFieldDBColumnName(), objectEntry.getObjectEntryId());
        }
        this.deleteRelatedObjectEntries(objectEntry.getGroupId(), objectDefinition.getObjectDefinitionId(), objectEntry.getPrimaryKey());
        this._deleteFileEntries(Collections.emptyMap(), objectDefinition.getObjectDefinitionId(), values);
        if (objectDefinition.isActive()) {
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)objectDefinition.getClassName());
            indexer.delete((Object)objectEntry);
        }
        ObjectActionThreadLocal.clearObjectEntryIdsMap();
        return objectEntry;
    }

    public ObjectEntry deleteObjectEntry(String externalReferenceCode, long companyId, long groupId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryPersistence.findByERC_G_C(externalReferenceCode, groupId, companyId);
        return this.objectEntryLocalService.deleteObjectEntry(objectEntry);
    }

    public void deleteRelatedObjectEntries(long groupId, long objectDefinitionId, long primaryKey) throws PortalException {
        List objectRelationships = this._objectRelationshipPersistence.findByObjectDefinitionId1(objectDefinitionId);
        for (ObjectRelationship objectRelationship : objectRelationships) {
            ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2());
            if (2 == objectDefinition2.getStatus()) continue;
            ObjectRelatedModelsProvider objectRelatedModelsProvider = this._objectRelatedModelsProviderRegistry.getObjectRelatedModelsProvider(objectDefinition2.getClassName(), objectDefinition2.getCompanyId(), objectRelationship.getType());
            try {
                ObjectEntryThreadLocal.setSkipObjectEntryResourcePermission((boolean)true);
                String deletionType = objectRelationship.getDeletionType();
                if (ObjectEntryThreadLocal.isDisassociateRelatedModels()) {
                    deletionType = "disassociate";
                }
                objectRelatedModelsProvider.deleteRelatedModel(PrincipalThreadLocal.getUserId(), groupId, objectRelationship.getObjectRelationshipId(), primaryKey, deletionType);
            }
            catch (PrincipalException principalException) {
                throw new ObjectRelationshipDeletionTypeException(principalException.getMessage());
            }
            finally {
                ObjectEntryThreadLocal.setSkipObjectEntryResourcePermission((boolean)false);
            }
        }
    }

    public ObjectEntry fetchManyToOneObjectEntry(long groupId, long objectRelationshipId, long primaryKey) throws PortalException {
        List objectEntries;
        ObjectRelationship objectRelationship = this._objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId);
        if (!Objects.equals(objectRelationship.getType(), "oneToMany")) {
            throw new UnsupportedOperationException();
        }
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = null;
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1());
        ObjectDefinition relatedObjectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2());
        if (relatedObjectDefinition.isUnmodifiableSystemObject()) {
            dynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectRelationship.getObjectDefinitionId2());
        } else {
            dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable(relatedObjectDefinition.getObjectDefinitionId());
            Column column = dynamicObjectDefinitionTable.getColumn(StringBundler.concat((String[])new String[]{"r_", objectRelationship.getName(), "_", objectDefinition.getPKObjectFieldName()}));
            if (column == null) {
                dynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectRelationship.getObjectDefinitionId2());
            }
        }
        DSLQuery dslQuery = this._getFetchManyToOneObjectEntryDSLQuery(dynamicObjectDefinitionTable, groupId, objectRelationship, primaryKey, (Column<DynamicObjectDefinitionTable, Long>)dynamicObjectDefinitionTable.getPrimaryKeyColumn());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Get one to many related object entries: " + dslQuery));
        }
        if ((objectEntries = (List)this.objectEntryPersistence.dslQuery(dslQuery)).isEmpty()) {
            return null;
        }
        return (ObjectEntry)objectEntries.get(0);
    }

    public ObjectEntry fetchObjectEntry(String externalReferenceCode, long objectDefinitionId) {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
        if (objectDefinition == null) {
            return null;
        }
        return this.objectEntryPersistence.fetchByERC_C_ODI(externalReferenceCode, objectDefinition.getCompanyId(), objectDefinitionId);
    }

    public Map<Object, Long> getAggregationCounts(long groupId, long objectDefinitionId, String aggregationTerm, Predicate predicate, int start, int end) throws PortalException {
        HashMap<Object, Long> aggregationCounts = new HashMap<Object, Long>();
        Table table = this._objectFieldLocalService.getTable(objectDefinitionId, aggregationTerm);
        ObjectField objectField = this._objectFieldLocalService.getObjectField(objectDefinitionId, aggregationTerm);
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable(objectDefinitionId);
        DynamicObjectDefinitionTable extensionDynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectDefinitionId);
        DSLQuery dslQuery = DSLQueryFactoryUtil.select((Expression[])new Expression[]{table.getColumn(objectField.getDBColumnName()), DSLFunctionFactoryUtil.countDistinct((Expression)dynamicObjectDefinitionTable.getPrimaryKeyColumn()).as("aggregationCount")}).from((Table)dynamicObjectDefinitionTable).innerJoinON((Table)ObjectEntryTable.INSTANCE, ObjectEntryTable.INSTANCE.objectEntryId.eq((Expression)dynamicObjectDefinitionTable.getPrimaryKeyColumn())).innerJoinON((Table)extensionDynamicObjectDefinitionTable, extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn().eq((Expression)dynamicObjectDefinitionTable.getPrimaryKeyColumn())).where(ObjectEntryTable.INSTANCE.objectDefinitionId.eq((Object)objectDefinitionId).and((Expression)predicate).and((Expression)this._getPermissionWherePredicate(dynamicObjectDefinitionTable, groupId))).groupBy(new Expression[]{table.getColumn(objectField.getDBColumnName())}).limit(start, end);
        for (Object[] values : (List)this.dslQuery(dslQuery)) {
            aggregationCounts.put(GetterUtil.getObject((Object)values[0]), GetterUtil.getLong((Object)values[1]));
        }
        return aggregationCounts;
    }

    public Map<String, Serializable> getExtensionDynamicObjectDefinitionTableValues(ObjectDefinition objectDefinition, long primaryKey) throws PortalException {
        Expression<?>[] selectExpressions;
        DynamicObjectDefinitionTable extensionDynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectDefinition.getObjectDefinitionId());
        List<Object[]> rows = this._list(this._getExtensionDynamicObjectDefinitionTableSelectDSLQuery(extensionDynamicObjectDefinitionTable, primaryKey, selectExpressions = this._getSelectExpressions(extensionDynamicObjectDefinitionTable)), objectDefinition.getObjectDefinitionId(), selectExpressions);
        if (rows.isEmpty()) {
            return new HashMap<String, Serializable>();
        }
        Map<String, Serializable> values = this._getValues(objectDefinition.getObjectDefinitionId(), rows.get(0), selectExpressions);
        values.remove(objectDefinition.getPKObjectFieldName());
        this._addObjectRelationshipERCFieldValue(objectDefinition.getObjectDefinitionId(), values);
        return values;
    }

    public List<ObjectEntry> getManyToManyObjectEntries(long groupId, long objectRelationshipId, long primaryKey, boolean related, boolean reverse, String search, int start, int end) throws PortalException {
        DSLQuery dslQuery = this._getManyToManyObjectEntriesGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)ObjectEntryTable.INSTANCE), groupId, objectRelationshipId, primaryKey, related, reverse, search).limit(start, end);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Get many to many related object entries: " + dslQuery));
        }
        return (List)this.objectEntryPersistence.dslQuery(dslQuery);
    }

    public int getManyToManyObjectEntriesCount(long groupId, long objectRelationshipId, long primaryKey, boolean related, boolean reverse, String search) throws PortalException {
        GroupByStep dslQuery = this._getManyToManyObjectEntriesGroupByStep(DSLQueryFactoryUtil.countDistinct((Expression)ObjectEntryTable.INSTANCE.objectEntryId), groupId, objectRelationshipId, primaryKey, related, reverse, search);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Get many to many related object entries count: " + dslQuery));
        }
        return this.objectEntryPersistence.dslQueryCount((DSLQuery)dslQuery);
    }

    public List<ObjectEntry> getObjectEntries(long groupId, long objectDefinitionId, int start, int end) {
        return this.objectEntryPersistence.findByG_ODI(groupId, objectDefinitionId, start, end);
    }

    public List<ObjectEntry> getObjectEntries(long groupId, long objectDefinitionId, int status, int start, int end) {
        return this.objectEntryPersistence.findByG_ODI_S(groupId, objectDefinitionId, status, start, end);
    }

    public int getObjectEntriesCount(long groupId, long objectDefinitionId) {
        return this.objectEntryPersistence.countByG_ODI(groupId, objectDefinitionId);
    }

    public ObjectEntry getObjectEntry(String externalReferenceCode, long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        return this.objectEntryPersistence.findByERC_C_ODI(externalReferenceCode, objectDefinition.getCompanyId(), objectDefinitionId);
    }

    public ObjectEntry getObjectEntry(String externalReferenceCode, long companyId, long groupId) throws PortalException {
        return this.objectEntryPersistence.findByERC_G_C(externalReferenceCode, groupId, companyId);
    }

    public List<ObjectEntry> getOneToManyObjectEntries(long groupId, long objectRelationshipId, long primaryKey, boolean related, String search, int start, int end) throws PortalException {
        DSLQuery dslQuery = this._getOneToManyObjectEntriesGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)ObjectEntryTable.INSTANCE), groupId, objectRelationshipId, primaryKey, related, search).limit(start, end);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Get one to many related object entries: " + dslQuery));
        }
        return (List)this.objectEntryPersistence.dslQuery(dslQuery);
    }

    public int getOneToManyObjectEntriesCount(long groupId, long objectRelationshipId, long primaryKey, boolean related, String search) throws PortalException {
        GroupByStep dslQuery = this._getOneToManyObjectEntriesGroupByStep(DSLQueryFactoryUtil.countDistinct((Expression)ObjectEntryTable.INSTANCE.objectEntryId), groupId, objectRelationshipId, primaryKey, related, search);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Get one to many related object entries count: " + dslQuery));
        }
        return this.objectEntryPersistence.dslQueryCount((DSLQuery)dslQuery);
    }

    public Map<String, Object> getSystemModelAttributes(ObjectDefinition objectDefinition, long primaryKey) throws PortalException {
        if (!objectDefinition.isUnmodifiableSystemObject()) {
            return new HashMap<String, Object>();
        }
        Map baseModelAttributes = new HashMap();
        PersistedModelLocalService persistedModelLocalService = this._persistedModelLocalServiceRegistry.getPersistedModelLocalService(objectDefinition.getClassName());
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable(objectDefinition.getObjectDefinitionId());
        Column primaryKeyColumn = dynamicObjectDefinitionTable.getPrimaryKeyColumn();
        List baseModels = (List)persistedModelLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select().from((Table)dynamicObjectDefinitionTable).where(primaryKeyColumn.eq((Object)primaryKey)));
        if (!baseModels.isEmpty()) {
            BaseModel baseModel = (BaseModel)baseModels.get(0);
            baseModelAttributes = baseModel.getModelAttributes();
        }
        HashMap modelAttributes = HashMapBuilder.put((Object)"createDate", (Object)GetterUtil.get(baseModelAttributes.get("createDate"), (long)primaryKey)).put((Object)"externalReferenceCode", (Object)GetterUtil.get(baseModelAttributes.get("externalReferenceCode"), (long)primaryKey)).put((Object)"modifiedDate", (Object)GetterUtil.get(baseModelAttributes.get("modifiedDate"), (long)primaryKey)).put((Object)"objectDefinitionId", (Object)objectDefinition.getObjectDefinitionId()).put((Object)"uuid", (Object)GetterUtil.get(baseModelAttributes.get("uuid"), (long)primaryKey)).build();
        for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId())) {
            if (!objectField.isSystem()) continue;
            Object value = GetterUtil.getObject(baseModelAttributes.get(objectField.getDBColumnName()), (Object)primaryKey);
            if (value instanceof String) {
                value = this._localization.getLocalization((String)value, null, true);
            }
            modelAttributes.put(objectField.getName(), value);
        }
        modelAttributes.putAll(this.objectEntryLocalService.getExtensionDynamicObjectDefinitionTableValues(objectDefinition, primaryKey));
        return modelAttributes;
    }

    public Map<String, Serializable> getSystemValues(ObjectEntry objectEntry) throws PortalException {
        List<Object[]> rows = this._list((DSLQuery)DSLQueryFactoryUtil.select(_EXPRESSIONS).from((Table)ObjectEntryTable.INSTANCE).where(ObjectEntryTable.INSTANCE.objectEntryId.eq((Object)objectEntry.getObjectEntryId())), objectEntry.getObjectDefinitionId(), _EXPRESSIONS);
        return this._getValues(objectEntry.getObjectDefinitionId(), rows.get(0), _EXPRESSIONS);
    }

    public String getTitleValue(long objectDefinitionId, long primaryKey) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        if (!objectDefinition.isUnmodifiableSystemObject()) {
            ObjectEntry objectEntry = this.getObjectEntry(primaryKey);
            return objectEntry.getTitleValue();
        }
        ObjectField titleObjectField = this._objectFieldLocalService.fetchObjectField(objectDefinition.getTitleObjectFieldId());
        if (Objects.isNull(titleObjectField)) {
            titleObjectField = this._objectFieldLocalService.getObjectField(objectDefinitionId, "id");
        }
        PersistedModelLocalService persistedModelLocalService = this._persistedModelLocalServiceRegistry.getPersistedModelLocalService(objectDefinition.getClassName());
        JSONObject jsonObject = this._jsonFactory.createJSONObject(String.valueOf(persistedModelLocalService.getPersistedModel((Serializable)Long.valueOf(primaryKey))));
        return jsonObject.getString(titleObjectField.getDBColumnName());
    }

    public Map<String, Serializable> getValues(long objectEntryId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryPersistence.findByPrimaryKey(objectEntryId);
        return this.getValues(objectEntry);
    }

    public Map<String, Serializable> getValues(ObjectEntry objectEntry) throws PortalException {
        DynamicObjectDefinitionLocalizationTable dynamicObjectDefinitionLocalizationTable = DynamicObjectDefinitionLocalizationTableFactory.create(this._objectDefinitionPersistence.findByPrimaryKey(objectEntry.getObjectDefinitionId()), this._objectFieldLocalService);
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable(objectEntry.getObjectDefinitionId());
        DynamicObjectDefinitionTable extensionDynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectEntry.getObjectDefinitionId());
        Expression[] selectExpressions = (Expression[])ArrayUtil.append((Object[][])new Expression[][]{this._getSelectExpressions(dynamicObjectDefinitionLocalizationTable), this._getSelectExpressions(dynamicObjectDefinitionTable), (Expression[])ArrayUtil.remove((Object[])this._getSelectExpressions(extensionDynamicObjectDefinitionTable), (Object)extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn())});
        List<Object[]> rows = this._list((DSLQuery)DSLQueryFactoryUtil.select((Expression[])selectExpressions).from((Table)dynamicObjectDefinitionTable).innerJoinON((Table)extensionDynamicObjectDefinitionTable, dynamicObjectDefinitionTable.getPrimaryKeyColumn().eq((Expression)extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn())).leftJoinOn((Table)dynamicObjectDefinitionLocalizationTable, this._getLeftJoinLocalizationTablePredicate(dynamicObjectDefinitionLocalizationTable, dynamicObjectDefinitionTable)).where(dynamicObjectDefinitionTable.getPrimaryKeyColumn().eq((Object)objectEntry.getObjectEntryId())), objectEntry.getObjectDefinitionId(), selectExpressions);
        Map<String, Serializable> values = this._getValues(objectEntry.getObjectDefinitionId(), rows.get(0), selectExpressions);
        this._addLocalizedObjectFieldValues(dynamicObjectDefinitionLocalizationTable, objectEntry.getObjectEntryId(), values);
        this._addObjectRelationshipERCFieldValue(objectEntry.getObjectDefinitionId(), values);
        return values;
    }

    public List<Map<String, Serializable>> getValuesList(long groupId, long companyId, long userId, long objectDefinitionId, Predicate predicate, String search, int start, int end, OrderByExpression[] orderByExpressions) throws PortalException {
        DynamicObjectDefinitionLocalizationTable dynamicObjectDefinitionLocalizationTable = DynamicObjectDefinitionLocalizationTableFactory.create(this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId), this._objectFieldLocalService);
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable(objectDefinitionId);
        DynamicObjectDefinitionTable extensionDynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectDefinitionId);
        Expression[] selectExpressions = (Expression[])ArrayUtil.append((Object[][])new Expression[][]{this._getSelectExpressions(dynamicObjectDefinitionLocalizationTable), this._getSelectExpressions(dynamicObjectDefinitionTable), (Expression[])ArrayUtil.remove((Object[])this._getSelectExpressions(extensionDynamicObjectDefinitionTable), (Object)extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn()), _EXPRESSIONS});
        List<Object[]> rows = this._list(DSLQueryFactoryUtil.select((Expression[])selectExpressions).from((Table)dynamicObjectDefinitionTable).innerJoinON((Table)ObjectEntryTable.INSTANCE, ObjectEntryTable.INSTANCE.objectEntryId.eq((Expression)dynamicObjectDefinitionTable.getPrimaryKeyColumn())).innerJoinON((Table)extensionDynamicObjectDefinitionTable, extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn().eq((Expression)dynamicObjectDefinitionTable.getPrimaryKeyColumn())).leftJoinOn((Table)dynamicObjectDefinitionLocalizationTable, this._getLeftJoinLocalizationTablePredicate(dynamicObjectDefinitionLocalizationTable, dynamicObjectDefinitionTable)).where(ObjectEntryTable.INSTANCE.objectDefinitionId.eq((Object)objectDefinitionId).and(() -> {
            if (groupId == 0L) {
                return null;
            }
            return ObjectEntryTable.INSTANCE.groupId.eq((Object)groupId);
        }).and((Expression)this._fillPredicate(objectDefinitionId, predicate, search)).and((Expression)this._getPermissionWherePredicate(dynamicObjectDefinitionTable, groupId))).orderBy(orderByExpressions).limit(start, end), objectDefinitionId, selectExpressions);
        ArrayList<Map<String, Serializable>> valuesList = new ArrayList<Map<String, Serializable>>(rows.size());
        for (Object[] objects : rows) {
            valuesList.add(this._getValues(objectDefinitionId, objects, selectExpressions));
        }
        return valuesList;
    }

    public int getValuesListCount(long groupId, long companyId, long userId, long objectDefinitionId, Predicate predicate, String search) throws PortalException {
        DynamicObjectDefinitionLocalizationTable dynamicObjectDefinitionLocalizationTable = DynamicObjectDefinitionLocalizationTableFactory.create(this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId), this._objectFieldLocalService);
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable(objectDefinitionId);
        DynamicObjectDefinitionTable extensionDynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectDefinitionId);
        GroupByStep dslQuery = DSLQueryFactoryUtil.countDistinct((Expression)ObjectEntryTable.INSTANCE.objectEntryId).from((Table)dynamicObjectDefinitionTable).innerJoinON((Table)ObjectEntryTable.INSTANCE, ObjectEntryTable.INSTANCE.objectEntryId.eq((Expression)dynamicObjectDefinitionTable.getPrimaryKeyColumn())).innerJoinON((Table)extensionDynamicObjectDefinitionTable, extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn().eq((Expression)dynamicObjectDefinitionTable.getPrimaryKeyColumn())).leftJoinOn((Table)dynamicObjectDefinitionLocalizationTable, this._getLeftJoinLocalizationTablePredicate(dynamicObjectDefinitionLocalizationTable, dynamicObjectDefinitionTable)).where(ObjectEntryTable.INSTANCE.objectDefinitionId.eq((Object)objectDefinitionId).and(() -> {
            if (groupId == 0L) {
                return null;
            }
            return ObjectEntryTable.INSTANCE.groupId.eq((Object)groupId);
        }).and((Expression)this._fillPredicate(objectDefinitionId, predicate, search)).and((Expression)this._getPermissionWherePredicate(dynamicObjectDefinitionTable, groupId)));
        return this.objectEntryPersistence.dslQueryCount((DSLQuery)dslQuery);
    }

    public void insertIntoOrUpdateExtensionTable(long userId, long objectDefinitionId, long primaryKey, Map<String, Serializable> values) throws PortalException {
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectDefinitionId);
        int count = 0;
        Connection connection = this._currentConnection.getConnection(this.objectEntryPersistence.getDataSource());
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select count(*) from ", dynamicObjectDefinitionTable.getTableName(), " where ", dynamicObjectDefinitionTable.getPrimaryKeyColumnName(), " = ", primaryKey}));
             ResultSet resultSet = preparedStatement.executeQuery();){
            resultSet.next();
            count = resultSet.getInt(1);
        }
        catch (SQLException sqlException) {
            throw new SystemException((Throwable)sqlException);
        }
        User user = this._userLocalService.getUser(userId);
        if (count > 0) {
            this._updateTable(dynamicObjectDefinitionTable, primaryKey, user, values);
        } else {
            this._insertIntoTable(dynamicObjectDefinitionTable, primaryKey, user, values);
        }
    }

    public BaseModelSearchResult<ObjectEntry> searchObjectEntries(long groupId, long objectDefinitionId, String keywords, int cur, int delta) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(objectDefinition.getScope());
        SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder();
        searchRequestBuilder.entryClassNames(new String[]{objectDefinition.getClassName()}).emptySearchEnabled(true).from(Integer.valueOf(cur)).size(Integer.valueOf(delta)).sorts(new Sort[]{this._sorts.field("entryClassPK", SortOrder.ASC)}).withSearchContext(searchContext -> {
            searchContext.setAttribute("status", (Serializable)Integer.valueOf(-1));
            searchContext.setAttribute("objectDefinitionId", (Serializable)Long.valueOf(objectDefinition.getObjectDefinitionId()));
            searchContext.setCompanyId(objectDefinition.getCompanyId());
            if (objectScopeProvider.isGroupAware()) {
                searchContext.setGroupIds(new long[]{groupId});
            } else {
                searchContext.setGroupIds(new long[]{0L});
            }
            searchContext.setKeywords(keywords);
        });
        SearchResponse searchResponse = this._searcher.search(searchRequestBuilder.build());
        SearchHits searchHits = searchResponse.getSearchHits();
        return new BaseModelSearchResult(TransformUtil.transform((Collection)searchHits.getSearchHits(), searchHit -> {
            Document document = searchHit.getDocument();
            return (ObjectEntry)this.objectEntryPersistence.fetchByPrimaryKey((Serializable)document.getLong("entryClassPK"));
        }), searchResponse.getTotalHits());
    }

    public void updateAsset(long userId, ObjectEntry objectEntry, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds, Double priority) throws PortalException {
        String title;
        ObjectDefinition objectDefinition;
        block3: {
            objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectEntry.getObjectDefinitionId());
            if (!objectDefinition.isEnableCategorization()) {
                assetCategoryIds = null;
                assetTagNames = null;
            }
            title = "";
            try {
                title = objectEntry.getTitleValue();
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)portalException);
            }
        }
        AssetEntry assetEntry = this._assetEntryLocalService.updateEntry(userId, objectEntry.getNonzeroGroupId(), objectEntry.getCreateDate(), objectEntry.getModifiedDate(), objectDefinition.getClassName(), objectEntry.getObjectEntryId(), objectEntry.getUuid(), 0L, assetCategoryIds, assetTagNames, true, objectEntry.isApproved(), null, null, null, null, "text/plain", title, String.valueOf(objectEntry.getObjectEntryId()), null, null, null, 0, 0, priority);
        this._assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    public ObjectEntry updateObjectEntry(long userId, long objectEntryId, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        ObjectEntry objectEntry = this.objectEntryPersistence.findByPrimaryKey(objectEntryId);
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectEntry.getObjectDefinitionId());
        this._validateValues(user.isGuestUser(), objectEntry.getObjectDefinitionId(), objectEntry, objectDefinition.getPortletId(), serviceContext, userId, values);
        Map transientValues = objectEntry.getValues();
        this._deleteFromLocalizationTable(objectDefinition, objectEntryId);
        this._insertIntoLocalizationTable(objectDefinition, objectEntryId, values);
        this._updateTable(this._getDynamicObjectDefinitionTable(objectEntry.getObjectDefinitionId()), objectEntryId, user, values);
        this._updateTable(this._getExtensionDynamicObjectDefinitionTable(objectEntry.getObjectDefinitionId()), objectEntryId, user, values);
        this.objectEntryPersistence.clearCache(SetUtil.fromArray((Object[])new Serializable[]{Long.valueOf(objectEntryId)}));
        objectEntry = this.objectEntryPersistence.findByPrimaryKey(objectEntryId);
        this._setExternalReferenceCode(objectEntry, values);
        objectEntry.setModifiedDate(serviceContext.getModifiedDate(null));
        objectEntry.setTransientValues(transientValues);
        objectEntry = (ObjectEntry)this.objectEntryPersistence.update((BaseModel)objectEntry);
        this.updateAsset(serviceContext.getUserId(), objectEntry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        this._startWorkflowInstance(userId, objectEntry, serviceContext);
        this._deleteFileEntries(objectEntry.getValues(), objectEntry.getObjectDefinitionId(), transientValues);
        this._reindex(objectEntry);
        return objectEntry;
    }

    public ObjectEntry updateStatus(long userId, long objectEntryId, int status, ServiceContext serviceContext) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryPersistence.findByPrimaryKey(objectEntryId);
        if (objectEntry.getStatus() == status) {
            return objectEntry;
        }
        objectEntry.setStatus(status);
        User user = this._userLocalService.getUser(userId);
        objectEntry.setStatusByUserId(user.getUserId());
        objectEntry.setStatusByUserName(user.getFullName());
        objectEntry.setStatusDate(serviceContext.getModifiedDate(null));
        if (_skipModelListeners.get().booleanValue()) {
            while (objectEntry instanceof ModelWrapper) {
                ModelWrapper modelWrapper = (ModelWrapper)objectEntry;
                objectEntry = (ObjectEntry)modelWrapper.getWrappedModel();
            }
            objectEntry = this.objectEntryPersistence.updateImpl(objectEntry);
        } else {
            objectEntry = (ObjectEntry)this.objectEntryPersistence.update((BaseModel)objectEntry);
        }
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(objectEntry.getObjectDefinitionId());
        this._assetEntryLocalService.updateEntry(objectDefinition.getClassName(), objectEntry.getObjectEntryId(), null, null, true, objectEntry.isApproved());
        this._reindex(objectEntry);
        return objectEntry;
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this.modified(properties);
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ObjectFilterParser.class, (String)"filter.type");
    }

    @Override
    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        this._objectConfiguration = (ObjectConfiguration)ConfigurableUtil.createConfigurable(ObjectConfiguration.class, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addFileEntry(DLFileEntry dlFileEntry, Map.Entry<String, Serializable> entry, List<ObjectFieldSetting> objectFieldSettings, String portletId, ServiceContext serviceContext, long userId) throws PortalException {
        try {
            String fileSource = null;
            boolean showFilesInDocumentsAndMedia = false;
            String storageDLFolderPath = null;
            for (ObjectFieldSetting objectFieldSetting : objectFieldSettings) {
                if (Objects.equals(objectFieldSetting.getName(), "fileSource")) {
                    fileSource = objectFieldSetting.getValue();
                    continue;
                }
                if (Objects.equals(objectFieldSetting.getName(), "showFilesInDocumentsAndMedia")) {
                    showFilesInDocumentsAndMedia = GetterUtil.getBoolean((String)objectFieldSetting.getValue());
                    continue;
                }
                if (!Objects.equals(objectFieldSetting.getName(), "storageDLFolderPath")) continue;
                storageDLFolderPath = objectFieldSetting.getValue();
            }
            if (Objects.equals(fileSource, "documentsAndMedia")) {
                return;
            }
            DLFolder dlFileEntryFolder = dlFileEntry.getFolder();
            DLFolder dlFolder = this._getDLFolder(dlFileEntry.getCompanyId(), dlFileEntry.getGroupId(), portletId, serviceContext, showFilesInDocumentsAndMedia, storageDLFolderPath, userId);
            if (Objects.equals(dlFileEntryFolder.getFolderId(), dlFolder.getFolderId())) {
                return;
            }
            String originalFileName = TempFileEntryUtil.getOriginalTempFileName((String)dlFileEntry.getFileName());
            FileEntry fileEntry = this._dlAppLocalService.addFileEntry(null, userId, dlFolder.getRepositoryId(), dlFolder.getFolderId(), DLUtil.getUniqueFileName((long)dlFileEntry.getGroupId(), (long)dlFolder.getFolderId(), (String)originalFileName, (boolean)true), dlFileEntry.getMimeType(), DLUtil.getUniqueTitle((long)dlFileEntry.getGroupId(), (long)dlFolder.getFolderId(), (String)FileUtil.stripExtension((String)originalFileName)), "", null, null, dlFileEntry.getContentStream(), dlFileEntry.getSize(), null, null, serviceContext);
            entry.setValue(Long.valueOf(fileEntry.getFileEntryId()));
        }
        finally {
            if (dlFileEntry != null) {
                TempFileEntryUtil.deleteTempFileEntry((long)dlFileEntry.getFileEntryId());
            }
        }
    }

    private void _addLocalizedObjectFieldValues(DynamicObjectDefinitionLocalizationTable dynamicObjectDefinitionLocalizationTable, long objectEntryId, Map<String, Serializable> values) {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-172017") || dynamicObjectDefinitionLocalizationTable == null) {
            return;
        }
        List rows = (List)this.objectEntryPersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Expression[])((Expression[])ArrayUtil.append((Object[])this._getSelectExpressions(dynamicObjectDefinitionLocalizationTable), (Object)dynamicObjectDefinitionLocalizationTable.getLanguageIdColumn()))).from((Table)dynamicObjectDefinitionLocalizationTable).where(dynamicObjectDefinitionLocalizationTable.getForeignKeyColumn().eq((Object)objectEntryId)));
        if (ListUtil.isEmpty((List)rows)) {
            return;
        }
        List objectFieldColumns = dynamicObjectDefinitionLocalizationTable.getObjectFieldColumns();
        for (int i = 0; i < objectFieldColumns.size(); ++i) {
            HashMap<String, String> localizedValues = new HashMap<String, String>();
            for (Object[] row : rows) {
                Object localizedValue = row[i];
                if (Validator.isNull((Object)localizedValue)) continue;
                localizedValues.put(String.valueOf(row[objectFieldColumns.size()]), String.valueOf(localizedValue));
            }
            Column objectFieldColumn = (Column)objectFieldColumns.get(i);
            values.put(objectFieldColumn.getName() + "i18n", localizedValues);
            values.putIfAbsent(com.liferay.portal.kernel.util.StringUtil.removeLast((String)objectFieldColumn.getName(), (String)"_"), (Serializable)((Object)""));
        }
    }

    private void _addObjectRelationshipERCFieldValue(long objectDefinitionId, Map<String, Serializable> values) {
        for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(objectDefinitionId, false)) {
            ObjectRelationship objectRelationship;
            ObjectDefinition objectDefinition;
            long primaryKey;
            if (!Objects.equals(objectField.getRelationshipType(), "oneToMany") || (primaryKey = GetterUtil.getLong((Object)values.get(objectField.getName()))) == 0L || (objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey((objectRelationship = this._objectRelationshipPersistence.fetchByObjectFieldId2(objectField.getObjectFieldId())).getObjectDefinitionId1())) == null) continue;
            String objectRelationshipERCObjectFieldName = ObjectFieldSettingUtil.getValue((String)"objectRelationshipERCObjectFieldName", (ObjectField)objectField);
            if (objectDefinition.isUnmodifiableSystemObject()) {
                SystemObjectDefinitionManager systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(objectDefinition.getName());
                try {
                    values.put(objectRelationshipERCObjectFieldName, (Serializable)((Object)systemObjectDefinitionManager.getBaseModelExternalReferenceCode(primaryKey)));
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Throwable)portalException);
                }
                continue;
            }
            ObjectEntry objectEntry = this.objectEntryPersistence.fetchByPrimaryKey(primaryKey);
            if (objectEntry == null) continue;
            values.put(objectRelationshipERCObjectFieldName, (Serializable)((Object)objectEntry.getExternalReferenceCode()));
        }
    }

    private void _deleteFileEntries(Map<String, Serializable> newValues, long objectDefinitionId, Map<String, Serializable> oldValues) {
        List objectFields = this._objectFieldPersistence.findByObjectDefinitionId(objectDefinitionId);
        for (ObjectField objectField : objectFields) {
            ObjectFieldSetting objectFieldSetting;
            if (objectField.isSystem()) continue;
            String objectFieldName = objectField.getName();
            if (!Objects.equals(objectField.getBusinessType(), "Attachment") || Objects.equals(GetterUtil.getLong((Object)newValues.get(objectFieldName)), GetterUtil.getLong((Object)oldValues.get(objectFieldName))) || !Objects.equals((objectFieldSetting = this._objectFieldSettingPersistence.fetchByOFI_N(objectField.getObjectFieldId(), "fileSource")).getValue(), "userComputer") || (objectFieldSetting = this._objectFieldSettingPersistence.fetchByOFI_N(objectField.getObjectFieldId(), "showFilesInDocumentsAndMedia")) != null && GetterUtil.getBoolean((String)objectFieldSetting.getValue())) continue;
            try {
                this._dlFileEntryLocalService.deleteFileEntry(GetterUtil.getLong((Object)oldValues.get(objectFieldName)));
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)portalException);
            }
        }
    }

    private void _deleteFromLocalizationTable(ObjectDefinition objectDefinition, long objectEntryId) throws PortalException {
        DynamicObjectDefinitionLocalizationTable dynamicObjectDefinitionLocalizationTable = DynamicObjectDefinitionLocalizationTableFactory.create(objectDefinition, this._objectFieldLocalService);
        if (dynamicObjectDefinitionLocalizationTable == null) {
            return;
        }
        this._deleteFromTable(dynamicObjectDefinitionLocalizationTable.getTableName(), dynamicObjectDefinitionLocalizationTable.getForeignKeyColumnName(), objectEntryId);
    }

    private void _deleteFromTable(String dbTableName, String pkObjectFieldDBColumnName, long primaryKey) throws PortalException {
        this.runSQL(StringBundler.concat((Object[])new Object[]{"delete from ", dbTableName, " where ", pkObjectFieldDBColumnName, " = ", primaryKey}));
        FinderCacheUtil.clearDSLQueryCache((String)dbTableName);
    }

    private void _fillDefaultValue(List<ObjectField> objectFields, Map<String, Serializable> values) {
        for (ObjectField objectField : objectFields) {
            String value;
            if (values.get(objectField.getName()) != null || (value = ObjectFieldSettingUtil.getDefaultValueAsString((DDMExpressionFactory)this._ddmExpressionFactory, (long)objectField.getObjectFieldId(), (ObjectFieldSettingLocalService)this._objectFieldSettingLocalService, values)) == null) continue;
            values.put(objectField.getName(), (Serializable)((Object)value));
        }
    }

    private Predicate _fillPredicate(long objectDefinitionId, Predicate predicate, String search) throws PortalException {
        if (Validator.isNull((String)search)) {
            return predicate;
        }
        List objectFields = this._objectFieldPersistence.findByODI_I(objectDefinitionId, true);
        if (objectFields.isEmpty()) {
            return predicate;
        }
        Predicate searchPredicate = null;
        for (ObjectField objectField : objectFields) {
            Table table = this._objectFieldLocalService.getTable(objectDefinitionId, objectField.getName());
            Column column = table.getColumn(objectField.getDBColumnName());
            if (column == null) continue;
            Predicate objectFieldPredicate = ObjectEntrySearchUtil.getObjectFieldPredicate(column, objectField.getDBType(), search);
            if (searchPredicate == null) {
                searchPredicate = objectFieldPredicate;
                continue;
            }
            searchPredicate = searchPredicate.or((Expression)objectFieldPredicate);
        }
        long searchLong = GetterUtil.getLong((String)search);
        if (searchLong != 0L) {
            searchPredicate = searchPredicate.or((Expression)ObjectEntryTable.INSTANCE.objectEntryId.eq((Object)searchLong));
        }
        if (predicate == null) {
            return searchPredicate;
        }
        return predicate.and((Expression)searchPredicate.withParentheses());
    }

    private DSLQuery _getAccountEntriesDSLQuery(long companyId, long userId) throws PortalException {
        JoinStep joinStep = DSLQueryFactoryUtil.select((Expression[])new Expression[]{AccountEntryTable.INSTANCE.accountEntryId}).from((Table)AccountEntryTable.INSTANCE);
        if (this._roleLocalService.hasUserRole(userId, companyId, "Administrator", true)) {
            return joinStep.where(AccountEntryTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)AccountEntryTable.INSTANCE.status.eq((Object)0)));
        }
        Table tempOrganizationTable = DSLQueryFactoryUtil.select((Expression[])new Expression[]{OrganizationTable.INSTANCE.companyId, OrganizationTable.INSTANCE.treePath}).from((Table)OrganizationTable.INSTANCE).innerJoinON((Table)Users_OrgsTable.INSTANCE, Users_OrgsTable.INSTANCE.organizationId.eq((Expression)OrganizationTable.INSTANCE.organizationId)).where(Users_OrgsTable.INSTANCE.userId.eq((Object)userId)).as("tempOrganizationTable", (Table)OrganizationTable.INSTANCE);
        return joinStep.innerJoinON((Table)AccountEntryOrganizationRelTable.INSTANCE, AccountEntryOrganizationRelTable.INSTANCE.accountEntryId.eq((Expression)AccountEntryTable.INSTANCE.accountEntryId)).where(AccountEntryOrganizationRelTable.INSTANCE.organizationId.in((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{OrganizationTable.INSTANCE.organizationId}).from((Table)OrganizationTable.INSTANCE).innerJoinON(tempOrganizationTable, OrganizationTable.INSTANCE.companyId.eq((Expression)tempOrganizationTable.getColumn("companyId", Long.class)).and((Expression)OrganizationTable.INSTANCE.treePath.like(DSLFunctionFactoryUtil.concat((Expression[])new Expression[]{DSLFunctionFactoryUtil.castText((Expression)tempOrganizationTable.getColumn("treePath", String.class)), new Scalar((Object)"%")}))))).and((Expression)this._getAccountEntryWherePredicate())).union((DSLQuery)joinStep.where(AccountEntryTable.INSTANCE.userId.eq((Object)userId).and((Expression)this._getAccountEntryWherePredicate()))).union((DSLQuery)joinStep.innerJoinON((Table)AccountEntryUserRelTable.INSTANCE, AccountEntryUserRelTable.INSTANCE.accountEntryId.eq((Expression)AccountEntryTable.INSTANCE.accountEntryId)).where(AccountEntryUserRelTable.INSTANCE.accountUserId.eq((Object)userId).and((Expression)this._getAccountEntryWherePredicate())));
    }

    private Predicate _getAccountEntryWherePredicate() {
        return AccountEntryTable.INSTANCE.parentAccountEntryId.eq((Object)0L).and((Expression)AccountEntryTable.INSTANCE.status.eq((Object)0)).and((Expression)AccountEntryTable.INSTANCE.type.in((Object[])new String[]{"business", "person"}));
    }

    private Map<String, Object> _getColumns(ObjectDefinition objectDefinition) {
        HashMap<String, Object> columns = new HashMap<String, Object>();
        List objectFields = this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId());
        for (ObjectField objectField : objectFields) {
            if (Objects.equals(objectField.getBusinessType(), "Aggregation") || Objects.equals(objectField.getBusinessType(), "Attachment") || Objects.equals(objectField.getBusinessType(), "Formula") || Objects.equals(objectField.getBusinessType(), "RichText")) continue;
            Column column = this._objectFieldLocalService.getColumn(objectDefinition.getObjectDefinitionId(), objectField.getName());
            columns.put(objectField.getName(), column);
        }
        return columns;
    }

    private String _getDBType(Alias<?> alias, long objectDefinitionId) throws PortalException {
        ObjectField objectField = this._objectFieldLocalService.getObjectField(objectDefinitionId, alias.getName());
        ObjectFieldSetting objectFieldSetting = this._objectFieldSettingPersistence.fetchByOFI_N(objectField.getObjectFieldId(), "output");
        ObjectFieldBusinessType objectFieldBusinessType = this._objectFieldBusinessTypeRegistry.getObjectFieldBusinessType(objectFieldSetting.getValue());
        return objectFieldBusinessType.getDBType();
    }

    private DLFolder _getDLFolder(long companyId, long groupId, String portletId, ServiceContext serviceContext, boolean showFilesInDocumentsAndMedia, String storageDLFolderPath, long userId) {
        Long dlFolderId = null;
        dlFolderId = showFilesInDocumentsAndMedia ? this._getStorageDLFolderId(companyId, groupId, serviceContext, storageDLFolderPath) : this._getObjectRepositoryFolderId(companyId, groupId, portletId, serviceContext, userId);
        if (dlFolderId == null) {
            return null;
        }
        return this._dlFolderLocalService.fetchDLFolder(dlFolderId.longValue());
    }

    private DynamicObjectDefinitionTable _getDynamicObjectDefinitionTable(long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        return new DynamicObjectDefinitionTable(objectDefinition, this._objectFieldLocalService.getObjectFields(objectDefinitionId, objectDefinition.getDBTableName()), objectDefinition.getDBTableName());
    }

    private DynamicObjectDefinitionTable _getExtensionDynamicObjectDefinitionTable(long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        return new DynamicObjectDefinitionTable(objectDefinition, this._objectFieldLocalService.getObjectFields(objectDefinitionId, objectDefinition.getExtensionDBTableName()), objectDefinition.getExtensionDBTableName());
    }

    private DSLQuery _getExtensionDynamicObjectDefinitionTableSelectDSLQuery(DynamicObjectDefinitionTable extensionDynamicObjectDefinitionTable, long primaryKey, Expression<?>[] selectExpressions) {
        return DSLQueryFactoryUtil.select(selectExpressions).from((Table)extensionDynamicObjectDefinitionTable).where(extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn().eq((Object)primaryKey));
    }

    private DSLQuery _getFetchManyToOneObjectEntryDSLQuery(DynamicObjectDefinitionTable dynamicObjectDefinitionTable, long groupId, ObjectRelationship objectRelationship, long primaryKey, Column<DynamicObjectDefinitionTable, Long> primaryKeyColumn) {
        FromStep fromStep = DSLQueryFactoryUtil.selectDistinct((Table)ObjectEntryTable.INSTANCE);
        ObjectField objectField = this._objectFieldPersistence.fetchByPrimaryKey(objectRelationship.getObjectFieldId2());
        return fromStep.from((Table)dynamicObjectDefinitionTable).innerJoinON((Table)ObjectEntryTable.INSTANCE, ObjectEntryTable.INSTANCE.objectEntryId.eq((Expression)dynamicObjectDefinitionTable.getColumn(objectField.getDBColumnName()))).where(primaryKeyColumn.eq((Object)primaryKey).and((Expression)ObjectEntryTable.INSTANCE.groupId.eq((Object)groupId)));
    }

    private Expression<?> _getFunctionExpression(Map<String, Object> objectFieldSettingsValues, ObjectDefinition relatedObjectDefinition, DynamicObjectDefinitionTable relatedDynamicObjectDefinitionTable, DynamicObjectDefinitionTable relatedExtensionDynamicObjectDefinitionTable, boolean selfObjectRelationship) {
        Column column = null;
        String function = GetterUtil.getString((Object)objectFieldSettingsValues.get("function"));
        if (!Objects.equals(function, "COUNT")) {
            column = this._objectFieldLocalService.getColumn(relatedObjectDefinition.getObjectDefinitionId(), GetterUtil.getString((Object)objectFieldSettingsValues.get("objectFieldName")));
            if (selfObjectRelationship) {
                column = column.getTable().getTableName().equals(relatedDynamicObjectDefinitionTable.getTableName()) ? relatedDynamicObjectDefinitionTable.getColumn(column.getName()) : relatedExtensionDynamicObjectDefinitionTable.getColumn(column.getName());
            }
        } else {
            column = relatedDynamicObjectDefinitionTable.getPrimaryKeyColumn();
        }
        if (function.equals("AVERAGE")) {
            return DSLFunctionFactoryUtil.avg((Expression)column);
        }
        if (function.equals("COUNT")) {
            return DSLFunctionFactoryUtil.count((Expression)column);
        }
        if (function.equals("MAX")) {
            return DSLFunctionFactoryUtil.max((Expression)column);
        }
        if (function.equals("MIN")) {
            return DSLFunctionFactoryUtil.min((Expression)column);
        }
        if (function.equals("SUM")) {
            return DSLFunctionFactoryUtil.sum((Expression)column);
        }
        throw new IllegalArgumentException("Invalid function " + function);
    }

    private Key _getKey() throws PortalException {
        return new SecretKeySpec(Base64.decode((String)PropsValues.OBJECT_ENCRYPTION_KEY), PropsValues.OBJECT_ENCRYPTION_ALGORITHM);
    }

    private Predicate _getLeftJoinLocalizationTablePredicate(DynamicObjectDefinitionLocalizationTable dynamicObjectDefinitionLocalizationTable, DynamicObjectDefinitionTable dynamicObjectDefinitionTable) throws PortalException {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-172017") || dynamicObjectDefinitionLocalizationTable == null) {
            return null;
        }
        Locale locale = LocaleThreadLocal.getThemeDisplayLocale();
        if (locale == null) {
            locale = LocaleThreadLocal.getSiteDefaultLocale();
        }
        if (locale == null) {
            User user = GuestOrUserUtil.getGuestOrUser();
            locale = user.getLocale();
        }
        return dynamicObjectDefinitionLocalizationTable.getForeignKeyColumn().eq((Expression)dynamicObjectDefinitionTable.getPrimaryKeyColumn()).and((Expression)dynamicObjectDefinitionLocalizationTable.getLanguageIdColumn().eq((Object)LocaleUtil.toLanguageId((Locale)locale)));
    }

    private Set<Locale> _getLocales(long companyId, List<ObjectField> objectFields, Map<String, Serializable> values) {
        HashSet<Locale> locales = new HashSet<Locale>();
        for (ObjectField objectField : objectFields) {
            Map localizedValues = (Map)((Object)values.get(objectField.getI18nObjectFieldName()));
            if (MapUtil.isEmpty((Map)localizedValues)) continue;
            for (String languageId : localizedValues.keySet()) {
                locales.add(LocaleUtil.fromLanguageId((String)languageId, (boolean)true, (boolean)false));
            }
        }
        return SetUtil.intersect(locales, (Collection)this._language.getCompanyAvailableLocales(companyId));
    }

    private GroupByStep _getManyToManyObjectEntriesGroupByStep(FromStep fromStep, long groupId, long objectRelationshipId, long primaryKey, boolean related, boolean reverse, String search) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId);
        long objectDefinitionId1 = objectRelationship.getObjectDefinitionId1();
        long objectDefinitionId2 = objectRelationship.getObjectDefinitionId2();
        DynamicObjectDefinitionLocalizationTable dynamicObjectDefinitionLocalizationTable = DynamicObjectDefinitionLocalizationTableFactory.create(this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId2), this._objectFieldLocalService);
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable(objectDefinitionId2);
        DynamicObjectDefinitionTable extensionDynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectDefinitionId2);
        Column dynamicObjectDefinitionTablePrimaryKeyColumn = dynamicObjectDefinitionTable.getPrimaryKeyColumn();
        ObjectDefinition objectDefinition1 = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId1);
        ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId2);
        Map pkObjectFieldDBColumnNames = ObjectRelationshipUtil.getPKObjectFieldDBColumnNames((ObjectDefinition)objectDefinition1, (ObjectDefinition)objectDefinition2, (boolean)reverse);
        DynamicObjectRelationshipMappingTable dynamicObjectRelationshipMappingTable = new DynamicObjectRelationshipMappingTable((String)pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName1"), (String)pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName2"), objectRelationship.getDBTableName());
        Column primaryKeyColumn1 = dynamicObjectRelationshipMappingTable.getPrimaryKeyColumn1();
        Column primaryKeyColumn2 = dynamicObjectRelationshipMappingTable.getPrimaryKeyColumn2();
        return fromStep.from((Table)dynamicObjectDefinitionTable).innerJoinON((Table)ObjectEntryTable.INSTANCE, ObjectEntryTable.INSTANCE.objectEntryId.eq((Expression)dynamicObjectDefinitionTablePrimaryKeyColumn)).innerJoinON((Table)extensionDynamicObjectDefinitionTable, extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn().eq((Expression)dynamicObjectDefinitionTablePrimaryKeyColumn)).leftJoinOn((Table)dynamicObjectDefinitionLocalizationTable, this._getLeftJoinLocalizationTablePredicate(dynamicObjectDefinitionLocalizationTable, dynamicObjectDefinitionTable)).leftJoinOn((Table)dynamicObjectRelationshipMappingTable, primaryKeyColumn2.eq((Expression)dynamicObjectDefinitionTablePrimaryKeyColumn)).where(ObjectEntryTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)ObjectEntryTable.INSTANCE.companyId.eq((Object)objectRelationship.getCompanyId())).and((Expression)ObjectEntryTable.INSTANCE.objectDefinitionId.eq((Object)objectDefinitionId2)).and(() -> {
            if (ObjectEntryThreadLocal.isSkipObjectEntryResourcePermission() || PermissionThreadLocal.getPermissionChecker() == null) {
                return null;
            }
            return this._getPermissionWherePredicate(objectDefinition2, (Column<DynamicObjectDefinitionTable, Long>)dynamicObjectDefinitionTablePrimaryKeyColumn);
        }).and(() -> {
            if (related) {
                return primaryKeyColumn1.eq((Object)primaryKey);
            }
            return dynamicObjectDefinitionTablePrimaryKeyColumn.notIn((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{primaryKeyColumn2}).from((Table)dynamicObjectRelationshipMappingTable).where(primaryKeyColumn1.eq((Object)primaryKey)));
        }).and(() -> {
            if (objectDefinition1.getObjectDefinitionId() == objectDefinition2.getObjectDefinitionId()) {
                return dynamicObjectDefinitionTablePrimaryKeyColumn.neq((Object)primaryKey);
            }
            return null;
        }).and((Expression)ObjectEntrySearchUtil.getRelatedModelsPredicate(dynamicObjectDefinitionTable, objectDefinition2, this._objectFieldLocalService, search)));
    }

    private Repository _getObjectRepository(long groupId, String portletId, ServiceContext serviceContext) {
        Repository repository = this._portletFileRepository.fetchPortletRepository(groupId, portletId);
        if (repository != null) {
            return repository;
        }
        serviceContext = (ServiceContext)serviceContext.clone();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        try {
            return this._portletFileRepository.addPortletRepository(groupId, portletId, serviceContext);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }

    private Long _getObjectRepositoryFolderId(long companyId, long groupId, String portletId, ServiceContext serviceContext, long userId) {
        Repository repository = this._getObjectRepository(groupId, portletId, serviceContext);
        if (repository == null) {
            return null;
        }
        DLFolder dlFolder = this._dlFolderLocalService.fetchFolder(repository.getGroupId(), repository.getDlFolderId(), String.valueOf(userId));
        if (dlFolder != null) {
            return dlFolder.getFolderId();
        }
        try {
            dlFolder = this._dlFolderLocalService.addFolder(null, this._userLocalService.getGuestUserId(companyId), repository.getGroupId(), repository.getRepositoryId(), false, repository.getDlFolderId(), String.valueOf(userId), null, false, serviceContext);
            return dlFolder.getFolderId();
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }

    private GroupByStep _getOneToManyObjectEntriesGroupByStep(FromStep fromStep, long groupId, long objectRelationshipId, long primaryKey, boolean related, String search) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId);
        DynamicObjectDefinitionLocalizationTable dynamicObjectDefinitionLocalizationTable = DynamicObjectDefinitionLocalizationTableFactory.create(this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2()), this._objectFieldLocalService);
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable(objectRelationship.getObjectDefinitionId2());
        DynamicObjectDefinitionTable extensionDynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectRelationship.getObjectDefinitionId2());
        ObjectField objectField = this._objectFieldPersistence.fetchByPrimaryKey(objectRelationship.getObjectFieldId2());
        Column primaryKeyColumn = dynamicObjectDefinitionTable.getPrimaryKeyColumn();
        return fromStep.from((Table)dynamicObjectDefinitionTable).innerJoinON((Table)ObjectEntryTable.INSTANCE, ObjectEntryTable.INSTANCE.objectEntryId.eq((Expression)primaryKeyColumn)).innerJoinON((Table)extensionDynamicObjectDefinitionTable, extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn().eq((Expression)primaryKeyColumn)).leftJoinOn((Table)dynamicObjectDefinitionLocalizationTable, this._getLeftJoinLocalizationTablePredicate(dynamicObjectDefinitionLocalizationTable, dynamicObjectDefinitionTable)).where(ObjectEntryTable.INSTANCE.companyId.eq((Object)objectRelationship.getCompanyId()).and(() -> {
            if (!related) {
                return ObjectEntryTable.INSTANCE.groupId.eq((Object)groupId);
            }
            return null;
        }).and((Expression)ObjectEntryTable.INSTANCE.objectDefinitionId.eq((Object)objectRelationship.getObjectDefinitionId2())).and(() -> {
            Column column = null;
            column = Objects.equals(objectField.getDBTableName(), dynamicObjectDefinitionTable.getName()) ? dynamicObjectDefinitionTable.getColumn(objectField.getDBColumnName()) : extensionDynamicObjectDefinitionTable.getColumn(objectField.getDBColumnName());
            return column.eq((Object)(related ? primaryKey : 0L));
        }).and(() -> objectRelationship.isSelf() ? primaryKeyColumn.neq((Object)primaryKey) : null).and(() -> {
            if (ObjectEntryThreadLocal.isSkipObjectEntryResourcePermission() || PermissionThreadLocal.getPermissionChecker() == null) {
                return null;
            }
            return this._getPermissionWherePredicate(this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2()), (Column<DynamicObjectDefinitionTable, Long>)primaryKeyColumn);
        }).and((Expression)ObjectEntrySearchUtil.getRelatedModelsPredicate(dynamicObjectDefinitionTable, this._objectDefinitionPersistence.fetchByPrimaryKey(objectRelationship.getObjectDefinitionId2()), this._objectFieldLocalService, search)));
    }

    private Predicate _getPermissionWherePredicate(DynamicObjectDefinitionTable dynamicObjectDefinitionTable, long groupId) throws PortalException {
        ObjectDefinition objectDefinition = dynamicObjectDefinitionTable.getObjectDefinition();
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null || !this._inlineSQLHelper.isEnabled(objectDefinition.getCompanyId(), groupId)) {
            return null;
        }
        Predicate individualScopePredicate = this._inlineSQLHelper.getPermissionWherePredicate(objectDefinition.getClassName(), dynamicObjectDefinitionTable.getPrimaryKeyColumn(), new long[]{groupId});
        if (individualScopePredicate == null) {
            return null;
        }
        if (!objectDefinition.isAccountEntryRestricted()) {
            return individualScopePredicate;
        }
        ObjectField objectField = this._objectFieldLocalService.getObjectField(objectDefinition.getAccountEntryRestrictedObjectFieldId());
        Table table = this._objectFieldLocalService.getTable(objectDefinition.getObjectDefinitionId(), objectField.getName());
        Column column = table.getColumn(objectField.getDBColumnName());
        return individualScopePredicate.or((Expression)column.in(this._getAccountEntriesDSLQuery(objectDefinition.getCompanyId(), permissionChecker.getUserId())).withParentheses()).withParentheses();
    }

    private Predicate _getPermissionWherePredicate(ObjectDefinition objectDefinition, Column<DynamicObjectDefinitionTable, Long> primaryKeyColumn) throws PortalException {
        long[] groupIds = new long[]{};
        if (objectDefinition.isAccountEntryRestricted()) {
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            groupIds = ListUtil.toLongArray((List)this._accountEntryLocalService.getUserAccountEntries(permissionChecker.getUserId(), Long.valueOf(0L), null, new String[]{"business", "person"}, Integer.valueOf(0), -1, -1), AccountEntry::getAccountEntryGroupId);
        }
        return this._inlineSQLHelper.getPermissionWherePredicate(objectDefinition.getClassName(), primaryKeyColumn, groupIds);
    }

    private Object _getResult(Object entryValues, long objectDefinitionId, Expression<?> selectExpression) throws PortalException {
        Object result = null;
        try {
            ScalarDSLQueryAlias scalarDSLQueryAlias;
            if (selectExpression instanceof Alias) {
                Alias alias = (Alias)selectExpression;
                result = this._getValue(entryValues, DynamicObjectDefinitionTableUtil.getSQLType((String)this._getDBType(alias, objectDefinitionId)));
            } else if (selectExpression instanceof Column) {
                Column column = (Column)selectExpression;
                result = this._getValue(entryValues, column.getSQLType());
            } else if (selectExpression instanceof ScalarDSLQueryAlias && (result = this._getValue(entryValues, (scalarDSLQueryAlias = (ScalarDSLQueryAlias)selectExpression).getSQLType())) == null) {
                result = "0";
            }
        }
        catch (SQLException sqlException) {
            throw new SystemException((Throwable)sqlException);
        }
        return result;
    }

    private Expression<?>[] _getSelectExpressions(DynamicObjectDefinitionLocalizationTable dynamicObjectDefinitionLocalizationTable) {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-172017") || dynamicObjectDefinitionLocalizationTable == null) {
            return new Expression[0];
        }
        ArrayList selectExpressions = new ArrayList(dynamicObjectDefinitionLocalizationTable.getObjectFieldColumns());
        return selectExpressions.toArray(new Expression[0]);
    }

    private Expression<?>[] _getSelectExpressions(DynamicObjectDefinitionTable dynamicObjectDefinitionTable) throws PortalException {
        ArrayList<Object> selectExpressions = new ArrayList<Object>();
        for (Column column : dynamicObjectDefinitionTable.getColumns()) {
            selectExpressions.add(column);
        }
        Map<String, Object> columns = null;
        for (ObjectField objectField : dynamicObjectDefinitionTable.getObjectFields()) {
            Object script;
            if (!objectField.compareBusinessType("Aggregation") && !objectField.compareBusinessType("Formula")) continue;
            HashMap<String, Object> objectFieldSettingsValues = new HashMap<String, Object>();
            List objectFieldSettings = this._objectFieldSettingLocalService.getObjectFieldObjectFieldSettings(objectField.getObjectFieldId());
            for (ObjectFieldSetting objectFieldSetting : objectFieldSettings) {
                if (com.liferay.portal.kernel.util.StringUtil.equals((String)objectFieldSetting.getName(), (String)"filters")) {
                    objectFieldSettingsValues.put(objectFieldSetting.getName(), objectFieldSetting.getObjectFilters());
                    continue;
                }
                objectFieldSettingsValues.put(objectFieldSetting.getName(), objectFieldSetting.getValue());
            }
            ObjectDefinition objectDefinition = dynamicObjectDefinitionTable.getObjectDefinition();
            if (objectField.compareBusinessType("Aggregation")) {
                ObjectRelationship objectRelationship = ObjectRelationshipUtil.getObjectRelationship((List)this._objectRelationshipPersistence.findByODI1_N(objectDefinition.getObjectDefinitionId(), GetterUtil.getString(objectFieldSettingsValues.get("objectRelationshipName"))));
                ObjectDefinition relatedObjectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2());
                DynamicObjectDefinitionTable relatedDynamicObjectDefinitionTable = new DynamicObjectDefinitionTable(relatedObjectDefinition, this._objectFieldLocalService.getObjectFields(relatedObjectDefinition.getObjectDefinitionId()), relatedObjectDefinition.getDBTableName());
                DynamicObjectDefinitionTable relatedExtensionDynamicObjectDefinitionTable = new DynamicObjectDefinitionTable(relatedObjectDefinition, this._objectFieldLocalService.getObjectFields(relatedObjectDefinition.getObjectDefinitionId()), relatedObjectDefinition.getExtensionDBTableName());
                if (objectRelationship.isSelf()) {
                    relatedDynamicObjectDefinitionTable = relatedDynamicObjectDefinitionTable.as("aliasDynamicObjectDefinitionTable");
                    relatedExtensionDynamicObjectDefinitionTable = relatedExtensionDynamicObjectDefinitionTable.as("aliasExtensionDynamicObjectDefinitionTable");
                }
                JoinStep joinStep = DSLQueryFactoryUtil.select((Expression[])new Expression[]{this._getFunctionExpression(objectFieldSettingsValues, relatedObjectDefinition, relatedDynamicObjectDefinitionTable, relatedExtensionDynamicObjectDefinitionTable, objectRelationship.isSelf())}).from((Table)relatedDynamicObjectDefinitionTable).innerJoinON((Table)relatedExtensionDynamicObjectDefinitionTable, relatedExtensionDynamicObjectDefinitionTable.getPrimaryKeyColumn().eq((Expression)relatedDynamicObjectDefinitionTable.getPrimaryKeyColumn()));
                if (!relatedObjectDefinition.isUnmodifiableSystemObject()) {
                    joinStep = joinStep.innerJoinON((Table)ObjectEntryTable.INSTANCE, ObjectEntryTable.INSTANCE.objectEntryId.eq((Expression)relatedDynamicObjectDefinitionTable.getPrimaryKeyColumn()));
                }
                Predicate predicate = null;
                if (Objects.equals(objectRelationship.getType(), "oneToMany")) {
                    ObjectField relatedField = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
                    Column relatedObjectDefinitionColumn = this._objectFieldLocalService.getColumn(relatedObjectDefinition.getObjectDefinitionId(), relatedField.getName());
                    predicate = relatedObjectDefinitionColumn.eq((Expression)dynamicObjectDefinitionTable.getPrimaryKeyColumn());
                } else if (Objects.equals(objectRelationship.getType(), "manyToMany")) {
                    String pkObjectFieldDBColumnName = objectDefinition.getPKObjectFieldDBColumnName();
                    String relatedPKObjectFieldDBColumnName = relatedObjectDefinition.getPKObjectFieldDBColumnName();
                    if (objectRelationship.isSelf()) {
                        pkObjectFieldDBColumnName = pkObjectFieldDBColumnName + "1";
                        relatedPKObjectFieldDBColumnName = relatedPKObjectFieldDBColumnName + "2";
                    }
                    DynamicObjectRelationshipMappingTable dynamicObjectRelationshipMappingTable = new DynamicObjectRelationshipMappingTable(pkObjectFieldDBColumnName, relatedPKObjectFieldDBColumnName, objectRelationship.getDBTableName());
                    Column primaryKeyColumn2 = dynamicObjectRelationshipMappingTable.getPrimaryKeyColumn2();
                    joinStep = joinStep.innerJoinON((Table)dynamicObjectRelationshipMappingTable, primaryKeyColumn2.eq((Expression)relatedDynamicObjectDefinitionTable.getPrimaryKeyColumn()));
                    Column primaryKeyColumn1 = dynamicObjectRelationshipMappingTable.getPrimaryKeyColumn1();
                    predicate = primaryKeyColumn1.eq((Expression)dynamicObjectDefinitionTable.getPrimaryKeyColumn());
                }
                List oDataFilterStrings = TransformUtil.transform((Collection)((List)objectFieldSettingsValues.get("filters")), objectFilter -> {
                    if (com.liferay.portal.kernel.util.StringUtil.equals((String)objectFilter.getFilterType(), (String)"currentUser")) {
                        objectFilter.setJSON(JSONUtil.put((String)"currentUserId", (Object)PrincipalThreadLocal.getUserId()).toString());
                    }
                    ObjectFilterParser objectFilterParser = (ObjectFilterParser)this._serviceTrackerMap.getService((Object)objectFilter.getFilterType());
                    return objectFilterParser.parse((ObjectFilter)objectFilter);
                });
                for (String oDataFilterString : oDataFilterStrings) {
                    predicate = predicate.and((Expression)this._filterFactory.create(oDataFilterString, relatedObjectDefinition));
                }
                selectExpressions.add(DSLQueryFactoryUtil.scalarSubDSLQuery((DSLQuery)joinStep.where(predicate), (Class)DynamicObjectDefinitionTableUtil.getJavaClass((String)objectField.getDBType()), (String)objectField.getName(), (int)DynamicObjectDefinitionTableUtil.getSQLType((String)objectField.getDBType())));
                continue;
            }
            if (!objectField.compareBusinessType("Formula") || (script = objectFieldSettingsValues.get("script")) == null) continue;
            if (columns == null) {
                columns = this._getColumns(objectDefinition);
            }
            DDMExpression ddmExpression = this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)String.valueOf(script)).build());
            ddmExpression.setVariables(columns);
            try {
                Expression expression = ddmExpression.getDSLExpression();
                selectExpressions.add(expression.as(objectField.getName()));
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
        return selectExpressions.toArray(new Expression[0]);
    }

    private Long _getStorageDLFolderId(long companyId, long groupId, ServiceContext serviceContext, String storageDLFolderPath) {
        long storageDLFolderId = 0L;
        for (String name : StringUtil.split((String)storageDLFolderPath, (char)'/')) {
            DLFolder dlFolder = this._dlFolderLocalService.fetchFolder(groupId, storageDLFolderId, name);
            if (dlFolder != null) {
                storageDLFolderId = dlFolder.getFolderId();
                continue;
            }
            try {
                Folder folder = this._dlAppLocalService.addFolder(null, this._userLocalService.getGuestUserId(companyId), groupId, storageDLFolderId, name, null, serviceContext);
                storageDLFolderId = folder.getFolderId();
            }
            catch (PortalException portalException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)portalException);
                }
                return null;
            }
        }
        return storageDLFolderId;
    }

    private Object _getValue(Object object, int sqlType) throws SQLException {
        if (sqlType == -5) {
            return GetterUtil.getLong((Object)object);
        }
        if (sqlType == 16) {
            return GetterUtil.getBoolean((Object)object);
        }
        if (sqlType == 2005) {
            return GetterUtil.getString((Object)object);
        }
        if (sqlType == 91 || sqlType == 93) {
            if (object == null) {
                return null;
            }
            Date date = (Date)object;
            return new Timestamp(date.getTime());
        }
        if (sqlType == 3) {
            return object;
        }
        if (sqlType == 8) {
            return GetterUtil.getDouble((Object)object);
        }
        if (sqlType == 4) {
            return GetterUtil.getInteger((Object)object);
        }
        if (sqlType == 12) {
            return object;
        }
        throw new IllegalArgumentException("Unable to get value with SQL type " + sqlType);
    }

    private Map<String, Serializable> _getValues(long objectDefinitionId, Object[] objects, Expression<?>[] selectExpressions) throws PortalException {
        HashMap<String, Serializable> values = new HashMap<String, Serializable>();
        for (int i = 0; i < selectExpressions.length; ++i) {
            ObjectField objectField;
            Expression<?> selectExpression = selectExpressions[i];
            String columnName = null;
            Class javaTypeClass = null;
            if (selectExpression instanceof Alias) {
                Alias alias = (Alias)selectExpression;
                columnName = alias.getName();
                javaTypeClass = DynamicObjectDefinitionTableUtil.getJavaClass((String)this._getDBType(alias, objectDefinitionId));
            } else if (selectExpression instanceof Column) {
                Column column = (Column)selectExpressions[i];
                columnName = column.getName();
                javaTypeClass = column.getJavaType();
            } else if (selectExpression instanceof ScalarDSLQueryAlias) {
                ScalarDSLQueryAlias scalarDSLQueryAlias = (ScalarDSLQueryAlias)selectExpressions[i];
                columnName = scalarDSLQueryAlias.getName();
                javaTypeClass = scalarDSLQueryAlias.getJavaType();
            }
            if (columnName.endsWith("_") && (objectField = this._objectFieldLocalService.fetchObjectField(objectDefinitionId, columnName = columnName.substring(0, columnName.length() - 1))) != null && objectField.compareBusinessType("Encrypted")) {
                try {
                    objects[i] = this._encryptor.decrypt(this._getKey(), (String)objects[i]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Please insert an encryption key or remove the object's encryption field to recover these entries.", illegalArgumentException);
                }
                catch (Exception exception) {
                    throw new PortalException((Throwable)exception);
                }
            }
            this._putValue(javaTypeClass, columnName, objects[i], values);
        }
        return values;
    }

    private void _insertIntoLocalizationTable(ObjectDefinition objectDefinition, long objectEntryId, Map<String, Serializable> values) throws PortalException {
        DynamicObjectDefinitionLocalizationTable dynamicObjectDefinitionLocalizationTable = DynamicObjectDefinitionLocalizationTableFactory.create(objectDefinition, this._objectFieldLocalService);
        if (dynamicObjectDefinitionLocalizationTable == null) {
            return;
        }
        List objectFields = dynamicObjectDefinitionLocalizationTable.getObjectFields();
        if (objectFields.isEmpty()) {
            return;
        }
        StringBundler sb = new StringBundler();
        sb.append("insert into ");
        sb.append(dynamicObjectDefinitionLocalizationTable.getName());
        sb.append(" (");
        sb.append(dynamicObjectDefinitionLocalizationTable.getForeignKeyColumnName());
        sb.append(", languageId");
        int count = 2;
        for (ObjectField objectField : objectFields) {
            if (objectField.isRequired() && !values.containsKey(objectField.getI18nObjectFieldName())) {
                throw new ObjectEntryValuesException.Required(objectField.getName());
            }
            sb.append(", ");
            sb.append(objectField.getDBColumnName());
            ++count;
        }
        sb.append(") values (?");
        for (int i = 1; i < count; ++i) {
            sb.append(", ?");
        }
        sb.append(")");
        String sql = sb.toString();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("SQL: " + sql));
        }
        Set<Locale> locales = this._getLocales(objectDefinition.getCompanyId(), objectFields, values);
        Connection connection = this._currentConnection.getConnection(this.objectEntryPersistence.getDataSource());
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            for (Locale locale : locales) {
                String languageId = LocaleUtil.toLanguageId((Locale)locale);
                int index = 1;
                this._setColumn(preparedStatement, index++, -5, objectEntryId);
                this._setColumn(preparedStatement, index++, 12, languageId);
                for (ObjectField objectField : objectFields) {
                    Column column = dynamicObjectDefinitionLocalizationTable.getColumn(objectField.getDBColumnName());
                    String value = "";
                    Map localizedValues = (Map)((Object)values.get(objectField.getI18nObjectFieldName()));
                    if (localizedValues != null) {
                        value = Objects.toString(localizedValues.get(languageId), "");
                    }
                    this._setColumn(preparedStatement, index++, column.getSQLType(), value);
                }
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            FinderCacheUtil.clearDSLQueryCache((String)dynamicObjectDefinitionLocalizationTable.getTableName());
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _insertIntoTable(DynamicObjectDefinitionTable dynamicObjectDefinitionTable, long objectEntryId, User user, Map<String, Serializable> values) throws PortalException {
        StringBundler sb = new StringBundler();
        sb.append("insert into ");
        sb.append(dynamicObjectDefinitionTable.getName());
        sb.append(" (");
        Column primaryKeyColumn = dynamicObjectDefinitionTable.getPrimaryKeyColumn();
        sb.append(primaryKeyColumn.getName());
        int count = 1;
        List objectFields = dynamicObjectDefinitionTable.getObjectFields();
        for (ObjectField objectField : objectFields) {
            if (objectField.isLocalized()) continue;
            if (objectField.compareBusinessType("Aggregation") || objectField.compareBusinessType("Formula") || !values.containsKey(objectField.getName())) {
                if (objectField.isRequired()) {
                    throw new ObjectEntryValuesException.Required(objectField.getName());
                }
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("No value was provided for object field \"" + objectField.getName() + "\""));
                continue;
            }
            if (Objects.equals(objectField.getRelationshipType(), "oneToOne")) {
                this._validateOneToOneInsert(objectField.getDBColumnName(), GetterUtil.getLong((Object)values.get(objectField.getName())), dynamicObjectDefinitionTable);
            }
            sb.append(", ");
            sb.append(objectField.getDBColumnName());
            ++count;
        }
        sb.append(") values (?");
        for (int i = 1; i < count; ++i) {
            sb.append(", ?");
        }
        sb.append(")");
        String sql = sb.toString();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("SQL: " + sql));
        }
        Connection connection = this._currentConnection.getConnection(this.objectEntryPersistence.getDataSource());
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            int index = 1;
            this._setColumn(preparedStatement, index++, -5, objectEntryId);
            for (ObjectField objectField : objectFields) {
                if (objectField.compareBusinessType("Aggregation") || objectField.compareBusinessType("Formula") || !values.containsKey(objectField.getName()) || objectField.isLocalized()) continue;
                this._setColumn(dynamicObjectDefinitionTable, index++, objectField, preparedStatement, values);
            }
            preparedStatement.executeUpdate();
            FinderCacheUtil.clearDSLQueryCache((String)dynamicObjectDefinitionTable.getTableName());
        }
        catch (SQLIntegrityConstraintViolationException sqlIntegrityConstraintViolationException) {
            this._validateUniqueValueConstraintViolation(dynamicObjectDefinitionTable, objectFields, sqlIntegrityConstraintViolationException, user, values);
            throw new SystemException((Throwable)sqlIntegrityConstraintViolationException);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private List<Object[]> _list(DSLQuery dslQuery, long objectDefinitionId, Expression<?>[] selectExpressions) throws PortalException {
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        List entriesValues = (List)this.objectEntryPersistence.dslQuery(dslQuery);
        for (Object entryValues : entriesValues) {
            Object[] result = new Object[selectExpressions.length];
            if (selectExpressions.length == 1) {
                result[0] = this._getResult(entryValues, objectDefinitionId, selectExpressions[0]);
            } else {
                for (int i = 0; i < selectExpressions.length; ++i) {
                    result[i] = this._getResult(((Object[])entryValues)[i], objectDefinitionId, selectExpressions[i]);
                }
            }
            results.add(result);
        }
        return results;
    }

    private void _putValue(Class<?> javaTypeClass, String name, Object object, Map<String, Serializable> values) {
        if (javaTypeClass == BigDecimal.class) {
            values.put(name, (BigDecimal)object);
        } else if (javaTypeClass == Blob.class) {
            byte[] bytes = null;
            if (object != null) {
                if (object instanceof Blob) {
                    Blob blob = (Blob)object;
                    try {
                        bytes = blob.getBytes(1L, (int)blob.length());
                    }
                    catch (SQLException sqlException) {
                        throw new SystemException((Throwable)sqlException);
                    }
                } else if (object instanceof byte[]) {
                    bytes = (byte[])object;
                } else {
                    Class<?> objectClass = object.getClass();
                    throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Unable to put \"", name, "\" with unknown object class ", objectClass.getName()}));
                }
            }
            values.put(name, (Serializable)bytes);
        } else if (javaTypeClass == Boolean.class) {
            if (object == null) {
                object = Boolean.FALSE;
            }
            if (object instanceof Byte) {
                Byte byteObject = (Byte)object;
                object = byteObject.intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            values.put(name, (Boolean)object);
        } else if (javaTypeClass == Clob.class) {
            if (object == null) {
                values.put(name, (Serializable)((Object)""));
            } else {
                DB db = DBManagerUtil.getDB();
                if (db.getDBType() == DBType.POSTGRESQL) {
                    values.put(name, (Serializable)((Object)((String)object)));
                } else {
                    Clob clob = (Clob)object;
                    try {
                        InputStream inputStream = clob.getAsciiStream();
                        values.put(name, (Serializable)((Object)GetterUtil.getString((String)IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8))));
                    }
                    catch (IOException | SQLException exception) {
                        throw new SystemException((Throwable)exception);
                    }
                }
            }
        } else if (javaTypeClass == Date.class) {
            values.put(name, (Date)object);
        } else if (javaTypeClass == Double.class) {
            Number number = (Number)object;
            if (number == null) {
                number = 0.0;
            } else if (!(number instanceof Double)) {
                number = number.doubleValue();
            }
            values.put(name, number);
        } else if (javaTypeClass == Integer.class) {
            Number number = (Number)object;
            if (number == null) {
                number = 0;
            } else if (!(number instanceof Integer)) {
                number = number.intValue();
            }
            values.put(name, number);
        } else if (javaTypeClass == Long.class) {
            Number number = (Number)object;
            if (number == null) {
                number = 0L;
            } else if (!(number instanceof Long)) {
                number = number.longValue();
            }
            values.put(name, number);
        } else if (javaTypeClass == String.class) {
            values.put(name, (Serializable)((Object)((String)object)));
        } else if (javaTypeClass == Timestamp.class) {
            values.put(name, (Timestamp)object);
        } else {
            throw new IllegalArgumentException("Unable to put value with class " + javaTypeClass.getName());
        }
    }

    private void _reindex(ObjectEntry objectEntry) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectEntry.getObjectDefinitionId());
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)objectDefinition.getClassName());
        indexer.reindex(objectDefinition.getClassName(), objectEntry.getObjectEntryId());
    }

    private void _setColumn(DynamicObjectDefinitionTable dynamicObjectDefinitionTable, int index, ObjectField objectField, PreparedStatement preparedStatement, Map<String, Serializable> values) throws Exception {
        Column column = dynamicObjectDefinitionTable.getColumn(objectField.getDBColumnName());
        Serializable value = values.get(objectField.getName());
        if (objectField.compareBusinessType("Encrypted")) {
            this._setColumn(preparedStatement, index, column.getSQLType(), this._encryptor.encrypt(this._getKey(), (String)((Object)value)));
        } else if (objectField.compareBusinessType("MultiselectPicklist")) {
            String valueString = String.valueOf(value);
            if (com.liferay.portal.kernel.util.StringUtil.endsWith((String)valueString, (String)"]") && com.liferay.portal.kernel.util.StringUtil.startsWith((String)valueString, (String)"[")) {
                valueString = valueString.substring(1, valueString.length() - 1);
            }
            this._setColumn(preparedStatement, index, column.getSQLType(), valueString);
        } else {
            this._setColumn(preparedStatement, index, column.getSQLType(), value);
        }
    }

    private void _setColumn(PreparedStatement preparedStatement, int index, int sqlType, Object value) throws Exception {
        if (sqlType == -5) {
            preparedStatement.setLong(index, GetterUtil.getLong((Object)value));
        } else if (sqlType == 2004) {
            if (PostgreSQLJDBCUtil.isPGStatement((Statement)preparedStatement)) {
                PostgreSQLJDBCUtil.setLargeObject((PreparedStatement)preparedStatement, (int)index, (byte[])((byte[])value));
            } else {
                preparedStatement.setBytes(index, (byte[])value);
            }
        } else if (sqlType == 16) {
            preparedStatement.setBoolean(index, GetterUtil.getBoolean((Object)value));
        } else if (sqlType == 2005) {
            DB db = DBManagerUtil.getDB();
            if (db.getDBType() == DBType.POSTGRESQL) {
                preparedStatement.setString(index, String.valueOf(value));
            } else {
                preparedStatement.setClob(index, new StringReader(String.valueOf(value)));
            }
        } else if (sqlType == 91 || sqlType == 93) {
            String valueString = GetterUtil.getString((Object)value);
            if (value instanceof Date) {
                Date date = (Date)value;
                preparedStatement.setTimestamp(index, new Timestamp(date.getTime()));
            } else if (value instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)value;
                preparedStatement.setTimestamp(index, Timestamp.valueOf(localDateTime));
            } else if (valueString.isEmpty()) {
                preparedStatement.setTimestamp(index, null);
            } else {
                Date date = DateUtil.parseDate((String)"yyyy-MM-dd", (String)valueString, (Locale)LocaleUtil.getSiteDefault());
                preparedStatement.setTimestamp(index, new Timestamp(date.getTime()));
            }
        } else if (sqlType == 3) {
            if (Validator.isNull((String)String.valueOf(value))) {
                value = BigDecimal.ZERO;
            }
            preparedStatement.setBigDecimal(index, new BigDecimal(this._toPeriodSeparator(String.valueOf(value))));
        } else if (sqlType == 8) {
            preparedStatement.setDouble(index, GetterUtil.getDouble((String)this._toPeriodSeparator(String.valueOf(value))));
        } else if (sqlType == 4) {
            preparedStatement.setInt(index, GetterUtil.getInteger((Object)value));
        } else if (sqlType == 12) {
            preparedStatement.setString(index, String.valueOf(value));
        } else {
            throw new IllegalArgumentException("Unable to set column with SQL type " + sqlType);
        }
    }

    private void _setExternalReferenceCode(ObjectEntry objectEntry, Map<String, Serializable> values) throws PortalException {
        for (Map.Entry<String, Serializable> entry : values.entrySet()) {
            if (!com.liferay.portal.kernel.util.StringUtil.equals((String)entry.getKey(), (String)"externalReferenceCode")) continue;
            String externalReferenceCode = String.valueOf(entry.getValue());
            if (Validator.isNull((String)externalReferenceCode)) {
                externalReferenceCode = objectEntry.getUuid();
            }
            this._validateExternalReferenceCode(externalReferenceCode, objectEntry.getCompanyId(), objectEntry.getObjectDefinitionId(), objectEntry.getObjectEntryId());
            objectEntry.setExternalReferenceCode(externalReferenceCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _startWorkflowInstance(long userId, ObjectEntry objectEntry, ServiceContext serviceContext) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectEntry.getObjectDefinitionId());
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            _skipModelListeners.set(true);
            WorkflowThreadLocal.setEnabled((boolean)true);
            WorkflowHandlerRegistryUtil.startWorkflowInstance((long)objectEntry.getCompanyId(), (long)objectEntry.getNonzeroGroupId(), (long)userId, (String)objectDefinition.getClassName(), (long)objectEntry.getObjectEntryId(), (Object)objectEntry, (ServiceContext)serviceContext);
        }
        finally {
            _skipModelListeners.set(false);
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    private String _toPeriodSeparator(String value) {
        if (Validator.isNull((String)value) || !NumberUtil.hasDecimalSeparator((String)value)) {
            return value;
        }
        return com.liferay.portal.kernel.util.StringUtil.replace((String)value, (char)value.charAt(NumberUtil.getDecimalSeparatorIndex((String)value)), (char)'.');
    }

    private void _updateTable(DynamicObjectDefinitionTable dynamicObjectDefinitionTable, long objectEntryId, User user, Map<String, Serializable> values) throws PortalException {
        StringBundler sb = new StringBundler();
        sb.append("update ");
        sb.append(dynamicObjectDefinitionTable.getName());
        sb.append(" set ");
        int count = 0;
        List objectFields = dynamicObjectDefinitionTable.getObjectFields();
        for (ObjectField objectField : objectFields) {
            if (objectField.compareBusinessType("Aggregation") || objectField.compareBusinessType("Formula") || objectField.isLocalized()) continue;
            if (!values.containsKey(objectField.getName())) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("No value was provided for object field \"" + objectField.getName() + "\""));
                continue;
            }
            if (Objects.equals(objectField.getRelationshipType(), "oneToOne")) {
                this._validateOneToOneUpdate(objectField.getDBColumnName(), GetterUtil.getLong((Object)values.get(objectField.getName())), dynamicObjectDefinitionTable, objectEntryId);
            }
            if (count > 0) {
                sb.append(", ");
            }
            sb.append(objectField.getDBColumnName());
            sb.append(" = ?");
            ++count;
        }
        if (count == 0) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No values were provided for object entry " + objectEntryId));
            }
            return;
        }
        sb.append(" where ");
        Column primaryKeyColumn = dynamicObjectDefinitionTable.getPrimaryKeyColumn();
        sb.append(primaryKeyColumn.getName());
        sb.append(" = ?");
        String sql = sb.toString();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("SQL: " + sql));
        }
        Connection connection = this._currentConnection.getConnection(this.objectEntryPersistence.getDataSource());
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            int index = 1;
            for (ObjectField objectField : objectFields) {
                if (objectField.compareBusinessType("Aggregation") || objectField.compareBusinessType("Formula") || !values.containsKey(objectField.getName()) || objectField.isLocalized()) continue;
                this._setColumn(dynamicObjectDefinitionTable, index++, objectField, preparedStatement, values);
            }
            this._setColumn(preparedStatement, index++, -5, objectEntryId);
            preparedStatement.executeUpdate();
            FinderCacheUtil.clearDSLQueryCache((String)dynamicObjectDefinitionTable.getTableName());
        }
        catch (SQLIntegrityConstraintViolationException sqlIntegrityConstraintViolationException) {
            this._validateUniqueValueConstraintViolation(dynamicObjectDefinitionTable, objectFields, sqlIntegrityConstraintViolationException, user, values);
            throw new SystemException((Throwable)sqlIntegrityConstraintViolationException);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _validateExternalReferenceCode(String externalReferenceCode, long companyId, long objectDefinitionId, long objectEntryId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryPersistence.fetchByERC_C_ODI(externalReferenceCode, companyId, objectDefinitionId);
        if (objectEntry != null && objectEntry.getObjectEntryId() != objectEntryId) {
            throw new ObjectEntryValuesException.MustNotBeDuplicate(externalReferenceCode);
        }
    }

    private void _validateFileExtension(String fileExtension, long objectFieldId, String objectFieldName) throws PortalException {
        ObjectFieldSetting objectFieldSetting = this._objectFieldSettingPersistence.fetchByOFI_N(objectFieldId, "acceptedFileExtensions");
        String acceptedFileExtensions = objectFieldSetting.getValue();
        if (!ArrayUtil.contains((String[])acceptedFileExtensions.split("\\s*,\\s*"), (String)fileExtension, (boolean)true)) {
            throw new ObjectEntryValuesException.InvalidFileExtension(fileExtension, objectFieldName);
        }
    }

    private void _validateFileSize(boolean guestUser, long fileSize, long objectFieldId, String objectFieldName) throws PortalException {
        ObjectFieldSetting objectFieldSetting = this._objectFieldSettingPersistence.fetchByOFI_N(objectFieldId, "maximumFileSize");
        long maximumFileSize = GetterUtil.getLong((String)objectFieldSetting.getValue());
        if (guestUser && (long)this._objectConfiguration.maximumFileSizeForGuestUsers() < maximumFileSize) {
            maximumFileSize = this._objectConfiguration.maximumFileSizeForGuestUsers();
        }
        if (maximumFileSize > 0L && fileSize > maximumFileSize * 1024L * 1024L) {
            throw new ObjectEntryValuesException.ExceedsMaxFileSize(maximumFileSize, objectFieldName);
        }
    }

    private void _validateGroupId(long groupId, String scope) throws PortalException {
        ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(scope);
        if (!objectScopeProvider.isValidGroupId(groupId)) {
            throw new ObjectDefinitionScopeException(StringBundler.concat((Object[])new Object[]{"Group ID ", groupId, " is not valid for scope \"", scope, "\""}));
        }
    }

    private void _validateListTypeEntryKey(String listTypeEntryKey, ObjectField objectField) throws PortalException {
        ListTypeEntry listTypeEntry = this._listTypeEntryLocalService.fetchListTypeEntry(objectField.getListTypeDefinitionId(), listTypeEntryKey);
        if (listTypeEntry == null && (Validator.isNotNull((String)listTypeEntryKey) || objectField.isRequired())) {
            throw new ObjectEntryValuesException.ListTypeEntry(objectField.getName());
        }
    }

    private void _validateObjectStateTransition(Map.Entry<String, Serializable> entry, long listTypeDefinitionId, ObjectEntry objectEntry, long objectFieldId, long userId) throws PortalException {
        Map values = objectEntry.getValues();
        Serializable value = (Serializable)values.get(entry.getKey());
        if (value == null) {
            return;
        }
        ListTypeEntry originalListTypeEntry = this._listTypeEntryLocalService.getListTypeEntry(listTypeDefinitionId, String.valueOf(value));
        ObjectStateFlow objectStateFlow = this._objectStateFlowLocalService.fetchObjectFieldObjectStateFlow(objectFieldId);
        ObjectState sourceObjectState = this._objectStateLocalService.getObjectStateFlowObjectState(originalListTypeEntry.getListTypeEntryId(), objectStateFlow.getObjectStateFlowId());
        ListTypeEntry listTypeEntry = this._listTypeEntryLocalService.getListTypeEntry(listTypeDefinitionId, String.valueOf(entry.getValue()));
        ObjectState targetObjectState = this._objectStateLocalService.getObjectStateFlowObjectState(listTypeEntry.getListTypeEntryId(), objectStateFlow.getObjectStateFlowId());
        if (sourceObjectState.getObjectStateId() == targetObjectState.getObjectStateId()) {
            return;
        }
        boolean invalidObjectStateTransition = true;
        for (ObjectState nextObjectState : this._objectStateLocalService.getNextObjectStates(sourceObjectState.getObjectStateId())) {
            if (nextObjectState.getListTypeEntryId() != targetObjectState.getListTypeEntryId()) continue;
            invalidObjectStateTransition = false;
        }
        if (invalidObjectStateTransition) {
            User user = this._userLocalService.getUser(userId);
            throw new ObjectEntryValuesException.InvalidObjectStateTransition(originalListTypeEntry.getName(user.getLocale()), sourceObjectState, listTypeEntry.getName(user.getLocale()), targetObjectState);
        }
    }

    private void _validateOneToOneInsert(String dbColumnName, long dbColumnValue, DynamicObjectDefinitionTable dynamicObjectDefinitionTable) throws PortalException {
        if (dbColumnValue == 0L) {
            return;
        }
        int count = 0;
        Connection connection = this._currentConnection.getConnection(this.objectEntryPersistence.getDataSource());
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select count(*) from ", dynamicObjectDefinitionTable.getTableName(), " where ", dbColumnName, " = ", dbColumnValue}));
             ResultSet resultSet = preparedStatement.executeQuery();){
            resultSet.next();
            count = resultSet.getInt(1);
        }
        catch (SQLException sqlException) {
            throw new SystemException((Throwable)sqlException);
        }
        if (count > 0) {
            throw new ObjectEntryValuesException.OneToOneConstraintViolation(dbColumnName, dbColumnValue, dynamicObjectDefinitionTable.getTableName());
        }
    }

    private void _validateOneToOneUpdate(String dbColumnName, long dbColumnValue, DynamicObjectDefinitionTable dynamicObjectDefinitionTable, long objectEntryId) throws PortalException {
        if (dbColumnValue == 0L) {
            return;
        }
        int count = 0;
        Connection connection = this._currentConnection.getConnection(this.objectEntryPersistence.getDataSource());
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select count(*) from ", dynamicObjectDefinitionTable.getTableName(), " where ", dynamicObjectDefinitionTable.getPrimaryKeyColumnName(), " != ", objectEntryId, " and ", dbColumnName, " = ", dbColumnValue}));
             ResultSet resultSet = preparedStatement.executeQuery();){
            resultSet.next();
            count = resultSet.getInt(1);
        }
        catch (SQLException sqlException) {
            throw new SystemException((Throwable)sqlException);
        }
        if (count > 0) {
            throw new ObjectEntryValuesException.OneToOneConstraintViolation(dbColumnName, dbColumnValue, dynamicObjectDefinitionTable.getTableName());
        }
    }

    private void _validateTextMaxLength(int defaultMaxLength, String objectEntryValue, long objectFieldId, String objectFieldName) throws PortalException {
        int maxLength = defaultMaxLength;
        ObjectFieldSetting objectFieldSetting = this._objectFieldSettingPersistence.fetchByOFI_N(objectFieldId, "maxLength");
        if (objectFieldSetting != null) {
            maxLength = GetterUtil.getInteger((String)objectFieldSetting.getValue());
        }
        if (objectEntryValue.length() > maxLength) {
            throw new ObjectEntryValuesException.ExceedsTextMaxLength(maxLength, objectFieldName);
        }
    }

    private void _validateTextMaxLength280(ObjectField objectField, String value) throws PortalException {
        this._validateTextMaxLength(280, value, objectField.getObjectFieldId(), objectField.getName());
    }

    private void _validateUniqueValueConstraintViolation(DynamicObjectDefinitionTable dynamicObjectDefinitionTable, List<ObjectField> objectFields, SQLIntegrityConstraintViolationException sqlIntegrityConstraintViolationException, User user, Map<String, Serializable> values) throws PortalException {
        for (ObjectField objectField : objectFields) {
            int count;
            if (!GetterUtil.getBoolean((String)ObjectFieldSettingUtil.getValue((String)"uniqueValues", (ObjectField)objectField))) continue;
            Column column = dynamicObjectDefinitionTable.getColumn(objectField.getDBColumnName());
            Serializable value = values.get(objectField.getName());
            if (column.getSQLType() == 4) {
                value = Integer.valueOf(GetterUtil.getInteger((Object)value));
            }
            if ((count = this.objectEntryPersistence.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.countDistinct((Expression)column).from((Table)dynamicObjectDefinitionTable).where(column.eq((Object)value)))) <= 0) continue;
            throw new ObjectEntryValuesException.UniqueValueConstraintViolation(objectField.getDBColumnName(), value, objectField.getLabel(user.getLocale()), dynamicObjectDefinitionTable.getTableName(), (Throwable)sqlIntegrityConstraintViolationException);
        }
    }

    private void _validateValues(boolean guestUser, long objectDefinitionId, ObjectEntry objectEntry, String portletId, ServiceContext serviceContext, long userId, Map<String, Serializable> values) throws PortalException {
        List objectFields = this._objectFieldLocalService.getLocalizedObjectFields(objectDefinitionId);
        for (ObjectField objectField : objectFields) {
            Map localizedValues = (Map)((Object)values.get(objectField.getI18nObjectFieldName()));
            if (MapUtil.isEmpty((Map)localizedValues)) continue;
            for (Map.Entry entry : localizedValues.entrySet()) {
                if (objectField.compareBusinessType("LongText")) {
                    this._validateTextMaxLength(65000, (String)entry.getValue(), objectField.getObjectFieldId(), objectField.getI18nObjectFieldName());
                    continue;
                }
                if (!objectField.compareBusinessType("Text")) continue;
                this._validateTextMaxLength(280, (String)entry.getValue(), objectField.getObjectFieldId(), objectField.getI18nObjectFieldName());
            }
        }
        for (Map.Entry entry : values.entrySet()) {
            this._validateValues(guestUser, entry, objectDefinitionId, objectEntry, portletId, serviceContext, userId, values);
        }
    }

    private void _validateValues(boolean guestUser, Map.Entry<String, Serializable> entry, long objectDefinitionId, ObjectEntry objectEntry, String portletId, ServiceContext serviceContext, long userId, Map<String, Serializable> values) throws PortalException {
        String entryValueString;
        Serializable entryValue;
        ObjectField objectField = null;
        try {
            objectField = this._objectFieldLocalService.getObjectField(objectDefinitionId, entry.getKey());
        }
        catch (NoSuchObjectFieldException noSuchObjectFieldException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchObjectFieldException);
            }
            return;
        }
        if (Validator.isNull((Object)values.get(objectField.getName())) && objectField.isRequired()) {
            throw new ObjectEntryValuesException.Required(objectField.getName());
        }
        if (com.liferay.portal.kernel.util.StringUtil.equals((String)objectField.getBusinessType(), (String)"Attachment")) {
            DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(GetterUtil.getLong((Object)entry.getValue()));
            if (dlFileEntry != null) {
                this._validateFileExtension(dlFileEntry.getExtension(), objectField.getObjectFieldId(), objectField.getName());
                this._validateFileSize(guestUser, dlFileEntry.getSize(), objectField.getObjectFieldId(), objectField.getName());
                this._addFileEntry(dlFileEntry, entry, objectField.getObjectFieldSettings(), portletId, serviceContext, userId);
                return;
            }
            if (Validator.isNotNull((Object)entry.getValue())) {
                throw new ObjectEntryValuesException.InvalidValue(objectField.getName());
            }
            if (objectField.isRequired()) {
                throw new ObjectEntryValuesException.Required(objectField.getName());
            }
        } else if (objectField.compareBusinessType("Boolean")) {
            if (!GetterUtil.getBoolean((Object)entry.getValue()) && objectField.isRequired()) {
                throw new ObjectEntryValuesException.Required(objectField.getName());
            }
        } else if (objectField.compareBusinessType("Encrypted")) {
            this._validateTextMaxLength280(objectField, GetterUtil.getString((Object)entry.getValue()));
        } else if (com.liferay.portal.kernel.util.StringUtil.equals((String)objectField.getBusinessType(), (String)"LongText")) {
            this._validateTextMaxLength(65000, GetterUtil.getString((Object)entry.getValue()), objectField.getObjectFieldId(), objectField.getName());
        } else if (com.liferay.portal.kernel.util.StringUtil.equals((String)objectField.getBusinessType(), (String)"Relationship")) {
            ObjectDefinition objectDefinition = objectField.getObjectDefinition();
            if (!objectDefinition.isAccountEntryRestricted() || !Objects.equals(objectField.getObjectFieldId(), objectDefinition.getAccountEntryRestrictedObjectFieldId()) || objectEntry == null) {
                return;
            }
        } else if (com.liferay.portal.kernel.util.StringUtil.equals((String)objectField.getDBType(), (String)"Integer")) {
            int value;
            entryValue = entry.getValue();
            entryValueString = entryValue.toString();
            if (!entryValueString.isEmpty() && !com.liferay.portal.kernel.util.StringUtil.equals((String)String.valueOf(value = GetterUtil.getInteger((Object)entryValue)), (String)entryValueString)) {
                throw new ObjectEntryValuesException.ExceedsIntegerSize(9, objectField.getName());
            }
        } else if (com.liferay.portal.kernel.util.StringUtil.equals((String)objectField.getDBType(), (String)"Long")) {
            entryValue = entry.getValue();
            entryValueString = entryValue.toString();
            if (!entryValueString.isEmpty()) {
                long value = GetterUtil.getLong((Object)entryValue);
                if (!com.liferay.portal.kernel.util.StringUtil.equals((String)String.valueOf(value), (String)entryValue.toString())) {
                    throw new ObjectEntryValuesException.ExceedsLongSize(16, objectField.getName());
                }
                if (value > 0x1FFFFFFFFFFFFFL) {
                    throw new ObjectEntryValuesException.ExceedsLongMaxSize(0x1FFFFFFFFFFFFFL, objectField.getName());
                }
                if (value < -9007199254740991L) {
                    throw new ObjectEntryValuesException.ExceedsLongMinSize(-9007199254740991L, objectField.getName());
                }
            }
        } else if (com.liferay.portal.kernel.util.StringUtil.equals((String)objectField.getDBType(), (String)"String")) {
            this._validateTextMaxLength280(objectField, GetterUtil.getString((Object)entry.getValue()));
        }
        if (objectField.getListTypeDefinitionId() != 0L) {
            Serializable value = entry.getValue();
            if (objectField.compareBusinessType("MultiselectPicklist")) {
                List listTypeEntryKeys = null;
                listTypeEntryKeys = value instanceof List ? (List)((Object)value) : ListUtil.fromString((String)GetterUtil.getString((String)String.valueOf(value)), (String)", ");
                if (listTypeEntryKeys.isEmpty() && objectField.isRequired()) {
                    throw new ObjectEntryValuesException.Required(objectField.getName());
                }
                for (String listTypeEntryKey : listTypeEntryKeys) {
                    this._validateListTypeEntryKey(listTypeEntryKey, objectField);
                }
            } else {
                this._validateListTypeEntryKey(String.valueOf(value), objectField);
                if (objectEntry != null && objectField.isState()) {
                    this._validateObjectStateTransition(entry, objectField.getListTypeDefinitionId(), objectEntry, objectField.getObjectFieldId(), userId);
                }
            }
        }
    }
}

