/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.exception.ObjectFolderLabelException;
import com.liferay.object.exception.ObjectFolderNameException;
import com.liferay.object.model.ObjectFolder;
import com.liferay.object.model.ObjectFolderItem;
import com.liferay.object.service.ObjectFolderItemLocalService;
import com.liferay.object.service.base.ObjectFolderLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectFolder"}, service={AopService.class})
public class ObjectFolderLocalServiceImpl
extends ObjectFolderLocalServiceBaseImpl {
    @Reference
    private ObjectFolderItemLocalService _objectFolderItemLocalService;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectFolder addObjectFolder(String externalReferenceCode, long userId, Map<Locale, String> labelMap, String name) throws PortalException {
        this._validateLabel(labelMap);
        User user = this._userLocalService.getUser(userId);
        this._validateName(user.getCompanyId(), name);
        ObjectFolder objectFolder = this.objectFolderPersistence.create(this.counterLocalService.increment());
        objectFolder.setExternalReferenceCode(externalReferenceCode);
        objectFolder.setCompanyId(user.getCompanyId());
        objectFolder.setUserId(userId);
        objectFolder.setUserName(user.getFullName());
        objectFolder.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        objectFolder.setName(name);
        objectFolder = (ObjectFolder)this.objectFolderPersistence.update((BaseModel)objectFolder);
        this._resourceLocalService.addResources(objectFolder.getCompanyId(), 0L, objectFolder.getUserId(), ObjectFolder.class.getName(), objectFolder.getObjectFolderId(), false, true, true);
        return objectFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectFolder addOrGetUncategorizedObjectFolder(long companyId) throws PortalException {
        ObjectFolder objectFolder = this.fetchObjectFolder(companyId, "Uncategorized");
        if (objectFolder != null) {
            return objectFolder;
        }
        ObjectFolderLocalServiceImpl objectFolderLocalServiceImpl = this;
        synchronized (objectFolderLocalServiceImpl) {
            objectFolder = this.fetchObjectFolder(companyId, "Uncategorized");
            if (objectFolder != null) {
                return objectFolder;
            }
            return this.objectFolderLocalService.addObjectFolder("uncategorized", this._userLocalService.getGuestUserId(companyId), LocalizedMapUtil.getLocalizedMap((String)"Uncategorized"), "Uncategorized");
        }
    }

    public void deleteCompanyObjectFolders(long companyId) throws PortalException {
        List objectFolders = this.objectFolderPersistence.findByCompanyId(companyId);
        for (ObjectFolder objectFolder : objectFolders) {
            this.objectFolderLocalService.deleteObjectFolder(objectFolder);
        }
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public ObjectFolder deleteObjectFolder(long objectFolderId) throws PortalException {
        ObjectFolder objectFolder = this.objectFolderPersistence.findByPrimaryKey(objectFolderId);
        return this.objectFolderLocalService.deleteObjectFolder(objectFolder);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectFolder deleteObjectFolder(ObjectFolder objectFolder) throws PortalException {
        if (!PortalInstances.isCurrentCompanyInDeletionProcess() && objectFolder.isUncategorized()) {
            throw new UnsupportedOperationException("Uncategorized cannot be deleted");
        }
        objectFolder = (ObjectFolder)this.objectFolderPersistence.remove((BaseModel)objectFolder);
        this._resourceLocalService.deleteResource((AuditedModel)objectFolder, 4);
        if (PortalInstances.isCurrentCompanyInDeletionProcess()) {
            this._objectFolderItemLocalService.deleteObjectFolderItemByObjectFolderId(objectFolder.getObjectFolderId());
        }
        return objectFolder;
    }

    public ObjectFolder fetchObjectFolder(long companyId, String name) {
        return this.objectFolderPersistence.fetchByC_N(companyId, name);
    }

    public ObjectFolder getObjectFolder(long companyId, String name) throws PortalException {
        return this.objectFolderPersistence.findByC_N(companyId, name);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectFolder updateObjectFolder(String externalReferenceCode, long objectFolderId, Map<Locale, String> labelMap, List<ObjectFolderItem> objectFolderItems) throws PortalException {
        this._validateLabel(labelMap);
        ObjectFolder objectFolder = this.objectFolderPersistence.findByPrimaryKey(objectFolderId);
        for (ObjectFolderItem objectFolderItem : objectFolderItems) {
            this._objectFolderItemLocalService.updateObjectFolderItem(objectFolderItem.getObjectDefinitionId(), objectFolder.getObjectFolderId(), objectFolderItem.getPositionX(), objectFolderItem.getPositionY());
        }
        if (objectFolder.isUncategorized()) {
            return objectFolder;
        }
        objectFolder.setExternalReferenceCode(externalReferenceCode);
        objectFolder.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        return (ObjectFolder)this.objectFolderPersistence.update((BaseModel)objectFolder);
    }

    private void _validateLabel(Map<Locale, String> labelMap) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        if (labelMap == null || Validator.isNull((String)labelMap.get(locale))) {
            throw new ObjectFolderLabelException("Label is null for locale " + locale.getDisplayName());
        }
    }

    private void _validateName(long companyId, String name) throws PortalException {
        char[] nameCharArray;
        if (Validator.isNull((String)name)) {
            throw new ObjectFolderNameException.MustNotBeNull();
        }
        for (char c : nameCharArray = name.toCharArray()) {
            if (Validator.isChar((char)c) || Validator.isDigit((char)c)) continue;
            throw new ObjectFolderNameException.MustOnlyContainLettersAndDigits();
        }
        if (nameCharArray.length > 41) {
            throw new ObjectFolderNameException.MustBeLessThan41Characters();
        }
        if (Validator.isNotNull((Object)this.objectFolderPersistence.fetchByC_N(companyId, name))) {
            throw new ObjectFolderNameException.MustNotBeDuplicate(name);
        }
    }
}

