/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.info.collection.provider.RelatedInfoItemCollectionProvider;
import com.liferay.object.exception.DuplicateObjectRelationshipException;
import com.liferay.object.exception.NoSuchObjectRelationshipException;
import com.liferay.object.exception.ObjectRelationshipEdgeException;
import com.liferay.object.exception.ObjectRelationshipNameException;
import com.liferay.object.exception.ObjectRelationshipParameterObjectFieldIdException;
import com.liferay.object.exception.ObjectRelationshipReverseException;
import com.liferay.object.exception.ObjectRelationshipTypeException;
import com.liferay.object.internal.dao.db.ObjectDBManagerUtil;
import com.liferay.object.internal.info.collection.provider.RelatedInfoCollectionProviderFactory;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.model.ObjectFolderItem;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.model.ObjectRelationshipTable;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionTableUtil;
import com.liferay.object.petra.sql.dsl.DynamicObjectRelationshipMappingTable;
import com.liferay.object.relationship.util.ObjectRelationshipUtil;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.object.service.ObjectFolderItemLocalService;
import com.liferay.object.service.base.ObjectRelationshipLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.object.service.persistence.ObjectFieldPersistence;
import com.liferay.object.service.persistence.ObjectLayoutTabPersistence;
import com.liferay.object.system.JaxRsApplicationDescriptor;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.osgi.util.service.Snapshot;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnection;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.util.Collection;
import java.util.Dictionary;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectRelationship"}, service={AopService.class})
public class ObjectRelationshipLocalServiceImpl
extends ObjectRelationshipLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ObjectRelationshipLocalServiceImpl.class);
    private static final Snapshot<ObjectDefinitionLocalService> _objectDefinitionLocalServiceSnapshot = new Snapshot(ObjectRelationshipLocalServiceImpl.class, ObjectDefinitionLocalService.class, null, true);
    private BundleContext _bundleContext;
    @Reference
    private CurrentConnection _currentConnection;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectFieldPersistence _objectFieldPersistence;
    @Reference
    private ObjectFieldSettingLocalService _objectFieldSettingLocalService;
    @Reference
    private ObjectFolderItemLocalService _objectFolderItemLocalService;
    @Reference
    private ObjectLayoutTabPersistence _objectLayoutTabPersistence;
    @Reference
    private RelatedInfoCollectionProviderFactory _relatedInfoCollectionProviderFactory;
    private final Map<String, ServiceRegistration<?>> _serviceRegistrations = new ConcurrentHashMap();
    @Reference
    private SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectRelationship addObjectRelationship(long userId, long objectDefinitionId1, long objectDefinitionId2, long parameterObjectFieldId, String deletionType, Map<Locale, String> labelMap, String name, String type) throws PortalException {
        return this._addObjectRelationship(userId, objectDefinitionId1, objectDefinitionId2, parameterObjectFieldId, deletionType, labelMap, name, false, type);
    }

    public void addObjectRelationshipMappingTableValues(long userId, long objectRelationshipId, long primaryKey1, long primaryKey2, ServiceContext serviceContext) throws PortalException {
        ObjectRelationship objectRelationship = this.objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId);
        ObjectDefinition objectDefinition1 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1());
        this._validateObjectEntryId(objectDefinition1, primaryKey1);
        ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2());
        if (Objects.equals(objectRelationship.getType(), "manyToMany")) {
            if (this._hasManyToManyObjectRelationshipMappingTableValues(objectDefinition1, objectDefinition2, objectRelationship, primaryKey1, primaryKey2)) {
                return;
            }
            Map pkObjectFieldDBColumnNames = ObjectRelationshipUtil.getPKObjectFieldDBColumnNames((ObjectDefinition)objectDefinition1, (ObjectDefinition)objectDefinition2, (boolean)objectRelationship.isReverse());
            this.runSQL(StringBundler.concat((Object[])new Object[]{"insert into ", objectRelationship.getDBTableName(), " (", pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName1"), ", ", pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName2"), ") values (", primaryKey1, ", ", primaryKey2, ")"}));
            FinderCacheUtil.clearDSLQueryCache((String)objectRelationship.getDBTableName());
            return;
        }
        ObjectField objectField2 = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
        if (objectDefinition2.isUnmodifiableSystemObject()) {
            this._objectEntryLocalService.insertIntoOrUpdateExtensionTable(userId, objectRelationship.getObjectDefinitionId2(), primaryKey2, (Map)HashMapBuilder.put((Object)objectField2.getName(), (Object)primaryKey1).build());
        } else {
            this._objectEntryLocalService.updateObjectEntry(userId, primaryKey2, (Map)HashMapBuilder.put((Object)objectField2.getName(), (Object)primaryKey1).build(), serviceContext);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectRelationship createManyToManyObjectRelationshipTable(long userId, ObjectRelationship objectRelationship) throws PortalException {
        if (Validator.isNotNull((String)objectRelationship.getDBTableName())) {
            return this.objectRelationshipLocalService.updateObjectRelationship(objectRelationship);
        }
        ObjectDefinition objectDefinition1 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1());
        ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2());
        if (!objectDefinition1.isApproved() || !objectDefinition2.isApproved()) {
            return this.objectRelationshipLocalService.updateObjectRelationship(objectRelationship);
        }
        User user = this._userLocalService.getUser(userId);
        objectRelationship.setDBTableName(StringBundler.concat((Object[])new Object[]{"R_", user.getCompanyId(), objectDefinition1.getShortName(), "_", objectDefinition2.getShortName(), "_", objectRelationship.getName()}));
        objectRelationship = this.objectRelationshipLocalService.updateObjectRelationship(objectRelationship);
        ObjectRelationship reverseObjectRelationship = this.fetchReverseObjectRelationship(objectRelationship, true);
        reverseObjectRelationship.setDBTableName(objectRelationship.getDBTableName());
        this.objectRelationshipLocalService.updateObjectRelationship(reverseObjectRelationship);
        Map pkObjectFieldDBColumnNames = ObjectRelationshipUtil.getPKObjectFieldDBColumnNames((ObjectDefinition)objectDefinition1, (ObjectDefinition)objectDefinition2, (boolean)false);
        String pkObjectFieldDBColumnName1 = (String)pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName1");
        String pkObjectFieldDBColumnName2 = (String)pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName2");
        this.runSQL(StringBundler.concat((String[])new String[]{"create table ", objectRelationship.getDBTableName(), " (", pkObjectFieldDBColumnName1, " LONG not null,", pkObjectFieldDBColumnName2, " LONG not null, primary key (", pkObjectFieldDBColumnName1, ", ", pkObjectFieldDBColumnName2, "))"}));
        Connection connection = this._currentConnection.getConnection(this.objectRelationshipPersistence.getDataSource());
        ObjectDBManagerUtil.createIndexMetadata(pkObjectFieldDBColumnName1, connection, objectRelationship.getDBTableName(), false);
        ObjectDBManagerUtil.createIndexMetadata(pkObjectFieldDBColumnName2, connection, objectRelationship.getDBTableName(), false);
        return objectRelationship;
    }

    @Override
    public ObjectRelationship deleteObjectRelationship(long objectRelationshipId) throws PortalException {
        ObjectRelationship objectRelationship = this.objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId);
        return this.objectRelationshipLocalService.deleteObjectRelationship(objectRelationship);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectRelationship deleteObjectRelationship(ObjectRelationship objectRelationship) throws PortalException {
        if (objectRelationship.isEdge()) {
            throw new ObjectRelationshipEdgeException("Edge object relationships cannot be deleted");
        }
        if (objectRelationship.isReverse()) {
            throw new ObjectRelationshipReverseException("Reverse object relationships cannot be deleted");
        }
        objectRelationship = (ObjectRelationship)this.objectRelationshipPersistence.remove((BaseModel)objectRelationship);
        this._deleteObjectFields(objectRelationship.getObjectDefinitionId1(), objectRelationship);
        this._deleteObjectFields(objectRelationship.getObjectDefinitionId2(), objectRelationship);
        ObjectDefinition objectDefinition1 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1());
        this._objectFolderItemLocalService.deleteObjectFolderItem(objectRelationship.getObjectDefinitionId2(), objectDefinition1.getObjectFolderId());
        ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2());
        this._objectFolderItemLocalService.deleteObjectFolderItem(objectRelationship.getObjectDefinitionId1(), objectDefinition2.getObjectFolderId());
        this._objectLayoutTabPersistence.removeByObjectRelationshipId(objectRelationship.getObjectRelationshipId());
        if (Objects.equals(objectRelationship.getType(), "oneToOne") || Objects.equals(objectRelationship.getType(), "oneToMany")) {
            this._objectFieldLocalService.deleteRelationshipTypeObjectField(objectRelationship.getObjectFieldId2());
        } else if (Objects.equals(objectRelationship.getType(), "manyToMany")) {
            if (Validator.isNotNull((String)objectRelationship.getDBTableName())) {
                this.runSQL("drop table " + objectRelationship.getDBTableName());
            }
            ObjectRelationship reverseObjectRelationship = this.fetchReverseObjectRelationship(objectRelationship, true);
            this._objectLayoutTabPersistence.removeByObjectRelationshipId(reverseObjectRelationship.getObjectRelationshipId());
            this.objectRelationshipPersistence.remove(reverseObjectRelationship.getObjectRelationshipId());
            ServiceRegistration<?> serviceRegistration = this._serviceRegistrations.get(this._getServiceRegistrationKey(reverseObjectRelationship));
            if (serviceRegistration != null) {
                serviceRegistration.unregister();
                this._serviceRegistrations.remove(this._getServiceRegistrationKey(reverseObjectRelationship));
            }
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(ObjectRelationship.class);
            indexer.delete((Object)reverseObjectRelationship);
        }
        ServiceRegistration<?> serviceRegistration = this._serviceRegistrations.get(this._getServiceRegistrationKey(objectRelationship));
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
            this._serviceRegistrations.remove(this._getServiceRegistrationKey(objectRelationship));
        }
        return objectRelationship;
    }

    public void deleteObjectRelationshipMappingTableValues(long objectRelationshipId, long primaryKey1) throws PortalException {
        ObjectRelationship objectRelationship = this.objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId);
        if (Objects.equals(objectRelationship.getType(), "manyToMany")) {
            Map pkObjectFieldDBColumnNames = ObjectRelationshipUtil.getPKObjectFieldDBColumnNames((ObjectDefinition)this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1()), (ObjectDefinition)this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2()), (boolean)objectRelationship.isReverse());
            this.runSQL(StringBundler.concat((Object[])new Object[]{"delete from ", objectRelationship.getDBTableName(), " where ", pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName1"), " = ", primaryKey1}));
            FinderCacheUtil.clearDSLQueryCache((String)objectRelationship.getDBTableName());
        }
    }

    public void deleteObjectRelationshipMappingTableValues(long objectRelationshipId, long primaryKey1, long primaryKey2) throws PortalException {
        ObjectRelationship objectRelationship = this.objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId);
        if (Objects.equals(objectRelationship.getType(), "manyToMany")) {
            ObjectDefinition objectDefinition1 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1());
            ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2());
            Map pkObjectFieldDBColumnNames = ObjectRelationshipUtil.getPKObjectFieldDBColumnNames((ObjectDefinition)objectDefinition1, (ObjectDefinition)objectDefinition2, (boolean)objectRelationship.isReverse());
            this.runSQL(StringBundler.concat((Object[])new Object[]{"delete from ", objectRelationship.getDBTableName(), " where ", pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName1"), " = ", primaryKey1, " and ", pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName2"), " = ", primaryKey2}));
            FinderCacheUtil.clearDSLQueryCache((String)objectRelationship.getDBTableName());
        }
    }

    public void deleteObjectRelationships(long objectDefinitionId1) throws PortalException {
        for (ObjectRelationship objectRelationship : this.objectRelationshipPersistence.findByObjectDefinitionId1(objectDefinitionId1)) {
            this.objectRelationshipLocalService.deleteObjectRelationship(objectRelationship);
        }
    }

    public void deleteObjectRelationships(long objectDefinitionId1, boolean reverse) throws PortalException {
        for (ObjectRelationship objectRelationship : this.objectRelationshipPersistence.findByODI1_R(objectDefinitionId1, reverse)) {
            this.objectRelationshipLocalService.deleteObjectRelationship(objectRelationship);
        }
    }

    public ObjectRelationship fetchObjectRelationshipByObjectDefinitionId(long objectDefinitionId, String name) {
        List objectRelationships = (List)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.select().from((Table)ObjectRelationshipTable.INSTANCE).where(Predicate.withParentheses((Predicate)ObjectRelationshipTable.INSTANCE.objectDefinitionId1.eq((Object)objectDefinitionId).or((Expression)ObjectRelationshipTable.INSTANCE.objectDefinitionId2.eq((Object)objectDefinitionId))).and((Expression)ObjectRelationshipTable.INSTANCE.name.eq((Object)name)).and((Expression)ObjectRelationshipTable.INSTANCE.reverse.eq((Object)false))));
        if (objectRelationships.isEmpty()) {
            return null;
        }
        return (ObjectRelationship)objectRelationships.get(0);
    }

    public ObjectRelationship fetchObjectRelationshipByObjectDefinitionId1(long objectDefinitionId1, String name) {
        return this.objectRelationshipPersistence.fetchByODI1_N_First(objectDefinitionId1, name, null);
    }

    public ObjectRelationship fetchObjectRelationshipByObjectFieldId2(long objectFieldId2) {
        return this.objectRelationshipPersistence.fetchByObjectFieldId2(objectFieldId2);
    }

    public ObjectRelationship fetchReverseObjectRelationship(ObjectRelationship objectRelationship, boolean reverse) {
        return this.objectRelationshipPersistence.fetchByODI1_ODI2_N_R_T(objectRelationship.getObjectDefinitionId2(), objectRelationship.getObjectDefinitionId1(), objectRelationship.getName(), reverse, objectRelationship.getType());
    }

    public List<ObjectRelationship> getAllObjectRelationships(long objectDefinitionId) {
        return (List)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.select().from((Table)ObjectRelationshipTable.INSTANCE).where(Predicate.withParentheses((Predicate)ObjectRelationshipTable.INSTANCE.objectDefinitionId1.eq((Object)objectDefinitionId).or((Expression)ObjectRelationshipTable.INSTANCE.objectDefinitionId2.eq((Object)objectDefinitionId))).and((Expression)ObjectRelationshipTable.INSTANCE.reverse.eq((Object)false))));
    }

    public ObjectRelationship getObjectRelationship(long objectDefinitionId1, String name) throws PortalException {
        try {
            return ObjectRelationshipUtil.getObjectRelationship((List)this.objectRelationshipPersistence.findByODI1_N(objectDefinitionId1, name));
        }
        catch (NoSuchObjectRelationshipException noSuchObjectRelationshipException) {
            throw new NoSuchObjectRelationshipException(String.format("No ObjectRelationship exists with the key {objectDefinitionId1=%s, name=%s}", objectDefinitionId1, name), (Throwable)noSuchObjectRelationshipException);
        }
    }

    public ObjectRelationship getObjectRelationshipByObjectDefinitionId(long objectDefinitionId, String name) throws Exception {
        List objectRelationships = (List)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.select().from((Table)ObjectRelationshipTable.INSTANCE).where(Predicate.withParentheses((Predicate)ObjectRelationshipTable.INSTANCE.objectDefinitionId1.eq((Object)objectDefinitionId).or((Expression)ObjectRelationshipTable.INSTANCE.objectDefinitionId2.eq((Object)objectDefinitionId))).and((Expression)ObjectRelationshipTable.INSTANCE.name.eq((Object)name)).and((Expression)ObjectRelationshipTable.INSTANCE.reverse.eq((Object)false))));
        if (objectRelationships.isEmpty()) {
            throw new NoSuchObjectRelationshipException("No object relationship exists with the name " + name);
        }
        return (ObjectRelationship)objectRelationships.get(0);
    }

    public List<ObjectRelationship> getObjectRelationships(long objectDefinitionId1) {
        return this.objectRelationshipPersistence.findByObjectDefinitionId1(objectDefinitionId1);
    }

    public List<ObjectRelationship> getObjectRelationships(long objectDefinitionId1, boolean edge) {
        return this.objectRelationshipPersistence.findByODI1_E(objectDefinitionId1, edge);
    }

    public List<ObjectRelationship> getObjectRelationships(long objectDefinitionId1, int start, int end) {
        return this.objectRelationshipPersistence.findByObjectDefinitionId1(objectDefinitionId1, start, end);
    }

    public List<ObjectRelationship> getObjectRelationships(long objectDefinitionId1, long objectDefinition2, String type) {
        return this.objectRelationshipPersistence.findByODI1_ODI2_T(objectDefinitionId1, objectDefinition2, type);
    }

    public List<ObjectRelationship> getObjectRelationships(long objectDefinitionId, String type) {
        Set objectRelationships = SetUtil.fromList((List)this.objectRelationshipPersistence.findByODI1_R_T(objectDefinitionId, false, type));
        objectRelationships.addAll(this.objectRelationshipPersistence.findByODI2_R_T(objectDefinitionId, false, type));
        return ListUtil.fromCollection((Collection)objectRelationships);
    }

    public List<ObjectRelationship> getObjectRelationships(long objectDefinitionId1, String deletionType, boolean reverse) {
        return this.objectRelationshipPersistence.findByODI1_DT_R(objectDefinitionId1, deletionType, reverse);
    }

    public List<ObjectRelationship> getObjectRelationshipsByObjectDefinitionId2(long objectDefinitionId2) {
        return this.objectRelationshipPersistence.findByObjectDefinitionId2(objectDefinitionId2);
    }

    public void registerObjectRelationshipsRelatedInfoCollectionProviders(ObjectDefinition objectDefinition1, ObjectDefinitionLocalService objectDefinitionLocalService) {
        List objectRelationships = this.objectRelationshipLocalService.getObjectRelationships(objectDefinition1.getObjectDefinitionId());
        for (ObjectRelationship objectRelationship : objectRelationships) {
            if (!objectRelationship.isAllowedObjectRelationshipType(objectRelationship.getType())) continue;
            try {
                ObjectDefinition objectDefinition2 = objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId2());
                this._registerRelatedInfoItemCollectionProvider(objectDefinition1, objectDefinition2, objectRelationship);
                if (!Objects.equals(objectRelationship.getType(), "manyToMany")) continue;
                this._registerRelatedInfoItemCollectionProvider(objectDefinition1, objectDefinition2, this.objectRelationshipLocalService.getObjectRelationship(objectRelationship.getObjectDefinitionId2(), objectRelationship.getName()));
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectRelationship updateObjectRelationship(long objectRelationshipId, long parameterObjectFieldId, String deletionType, boolean edge, Map<Locale, String> labelMap) throws PortalException {
        ObjectRelationship objectRelationship;
        if (Validator.isNull((String)deletionType)) {
            deletionType = "prevent";
        }
        if ((objectRelationship = this.objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId)).isReverse()) {
            throw new ObjectRelationshipReverseException("Reverse object relationships cannot be updated");
        }
        this._validateParameterObjectFieldId(this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1()), this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2()), parameterObjectFieldId, objectRelationship.getType());
        this._validateEdge(edge, objectRelationship);
        if (Objects.equals(objectRelationship.getType(), "manyToMany")) {
            ObjectRelationship reverseObjectRelationship = this.fetchReverseObjectRelationship(objectRelationship, true);
            this._updateObjectRelationship(parameterObjectFieldId, deletionType, false, labelMap, reverseObjectRelationship);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(ObjectRelationship.class);
            indexer.reindex((Object)reverseObjectRelationship);
        }
        if ((objectRelationship = this._updateObjectRelationship(parameterObjectFieldId, deletionType, edge, labelMap, objectRelationship)).getObjectFieldId2() != 0L && StringUtil.equals((String)deletionType, (String)"disassociate")) {
            this._objectFieldLocalService.updateRequired(objectRelationship.getObjectFieldId2(), false);
        }
        return objectRelationship;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    private ObjectField _addObjectField(User user, Map<Locale, String> labelMap, String name, ObjectDefinition objectDefinition1, ObjectDefinition objectDefinition2, String type) throws PortalException {
        ObjectField objectField = this._objectFieldPersistence.create(this.counterLocalService.increment());
        objectField.setCompanyId(user.getCompanyId());
        objectField.setUserId(user.getUserId());
        objectField.setUserName(user.getFullName());
        objectField.setListTypeDefinitionId(0L);
        objectField.setObjectDefinitionId(objectDefinition2.getObjectDefinitionId());
        objectField.setBusinessType("Relationship");
        String dbColumnName = StringBundler.concat((String[])new String[]{"r_", name, "_", objectDefinition1.getPKObjectFieldName()});
        objectField.setDBColumnName(dbColumnName);
        String dbTableName = objectDefinition2.getDBTableName();
        if (objectDefinition2.isApproved()) {
            dbTableName = objectDefinition2.getExtensionDBTableName();
        }
        objectField.setDBTableName(dbTableName);
        objectField.setDBType("Long");
        objectField.setIndexed(true);
        objectField.setIndexedAsKeyword(false);
        objectField.setIndexedLanguageId(null);
        objectField.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        objectField.setName(dbColumnName);
        objectField.setReadOnly("false");
        objectField.setReadOnlyConditionExpression("");
        objectField.setRelationshipType(type);
        objectField.setRequired(false);
        objectField = this._objectFieldLocalService.updateObjectField(objectField);
        this._objectFieldSettingLocalService.addObjectFieldSetting(user.getUserId(), objectField.getObjectFieldId(), "objectDefinition1ShortName", objectDefinition1.getShortName());
        this._objectFieldSettingLocalService.addObjectFieldSetting(user.getUserId(), objectField.getObjectFieldId(), "objectRelationshipERCObjectFieldName", StringUtil.replaceLast((String)objectField.getName(), (String)"Id", (String)"ERC"));
        if (!objectDefinition2.isApproved()) {
            return objectField;
        }
        this.runSQL(DynamicObjectDefinitionTableUtil.getAlterTableAddColumnSQL((String)dbTableName, (String)objectField.getDBColumnName(), (String)"Long"));
        ObjectDBManagerUtil.createIndexMetadata(objectField.getDBColumnName(), this._currentConnection.getConnection(this.objectRelationshipPersistence.getDataSource()), dbTableName, false);
        ObjectDefinitionLocalService objectDefinitionLocalService = (ObjectDefinitionLocalService)_objectDefinitionLocalServiceSnapshot.get();
        if (objectDefinitionLocalService != null) {
            objectDefinitionLocalService.deployObjectDefinition(objectDefinition2);
        }
        return objectField;
    }

    private void _addObjectFolderItem(long userId, long objectDefinitionId, long objectFolderId) throws PortalException {
        ObjectFolderItem objectFolderItem = this._objectFolderItemLocalService.fetchObjectFolderItem(objectDefinitionId, objectFolderId);
        if (objectFolderItem != null) {
            return;
        }
        this._objectFolderItemLocalService.addObjectFolderItem(userId, objectDefinitionId, objectFolderId, 0, 0);
    }

    private ObjectRelationship _addObjectRelationship(long userId, long objectDefinitionId1, long objectDefinitionId2, long parameterObjectFieldId, String deletionType, Map<Locale, String> labelMap, String name, boolean reverse, String type) throws PortalException {
        this._validateName(objectDefinitionId1, name);
        ObjectDefinition objectDefinition1 = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId1);
        ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId2);
        this._validateType(objectDefinition1, objectDefinition2, name, parameterObjectFieldId, type);
        ObjectRelationship objectRelationship = this.objectRelationshipPersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        objectRelationship.setCompanyId(user.getCompanyId());
        objectRelationship.setUserId(user.getUserId());
        objectRelationship.setUserName(user.getFullName());
        objectRelationship.setObjectDefinitionId1(objectDefinitionId1);
        objectRelationship.setObjectDefinitionId2(objectDefinitionId2);
        objectRelationship.setParameterObjectFieldId(parameterObjectFieldId);
        objectRelationship.setDeletionType(GetterUtil.getString((String)deletionType, (String)"prevent"));
        objectRelationship.setLabelMap(labelMap);
        objectRelationship.setName(name);
        objectRelationship.setReverse(reverse);
        objectRelationship.setType(type);
        this._addObjectFolderItem(userId, objectDefinition1.getObjectDefinitionId(), objectDefinition2.getObjectFolderId());
        this._addObjectFolderItem(userId, objectDefinition2.getObjectDefinitionId(), objectDefinition1.getObjectFolderId());
        if (Objects.equals(type, "oneToOne") || Objects.equals(type, "oneToMany")) {
            ObjectField objectField = this._addObjectField(user, objectRelationship.getLabelMap(), name, objectDefinition1, objectDefinition2, type);
            objectRelationship.setObjectFieldId2(objectField.getObjectFieldId());
        } else if (Objects.equals(type, "manyToMany") && !reverse) {
            this._registerRelatedInfoItemCollectionProvider(objectDefinition1, objectDefinition2, objectRelationship);
            this._addObjectRelationship(userId, objectDefinitionId2, objectDefinitionId1, parameterObjectFieldId, deletionType, labelMap, name, true, type);
            return this.objectRelationshipLocalService.createManyToManyObjectRelationshipTable(userId, objectRelationship);
        }
        this._registerRelatedInfoItemCollectionProvider(objectDefinition1, objectDefinition2, objectRelationship);
        return this.objectRelationshipLocalService.updateObjectRelationship(objectRelationship);
    }

    private void _deleteObjectFields(long objectDefinitionId, ObjectRelationship objectRelationship) throws PortalException {
        for (ObjectField objectField : this._objectFieldPersistence.findByObjectDefinitionId(objectDefinitionId)) {
            ObjectFieldSetting objectFieldSetting = this._objectFieldSettingLocalService.fetchObjectFieldSetting(objectField.getObjectFieldId(), "objectRelationshipName");
            if (objectFieldSetting == null || !StringUtil.equals((String)objectFieldSetting.getValue(), (String)objectRelationship.getName())) continue;
            this._objectFieldLocalService.deleteObjectField(objectField.getObjectFieldId());
        }
    }

    private String _getServiceRegistrationKey(ObjectRelationship objectRelationship) {
        return StringBundler.concat((Object[])new Object[]{objectRelationship.getCompanyId(), "#", objectRelationship.getObjectRelationshipId()});
    }

    private boolean _hasManyToManyObjectRelationshipMappingTableValues(ObjectDefinition objectDefinition1, ObjectDefinition objectDefinition2, ObjectRelationship objectRelationship, long primaryKey1, long primaryKey2) {
        Map pkObjectFieldDBColumnNames = ObjectRelationshipUtil.getPKObjectFieldDBColumnNames((ObjectDefinition)objectDefinition1, (ObjectDefinition)objectDefinition2, (boolean)objectRelationship.isReverse());
        DynamicObjectRelationshipMappingTable dynamicObjectRelationshipMappingTable = new DynamicObjectRelationshipMappingTable((String)pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName1"), (String)pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName2"), objectRelationship.getDBTableName());
        Column primaryKeyColumn1 = dynamicObjectRelationshipMappingTable.getPrimaryKeyColumn1();
        Column primaryKeyColumn2 = dynamicObjectRelationshipMappingTable.getPrimaryKeyColumn2();
        int count = this.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.count().from((Table)dynamicObjectRelationshipMappingTable).where(primaryKeyColumn1.eq((Object)primaryKey1).and((Expression)primaryKeyColumn2.eq((Object)primaryKey2))));
        return count > 0;
    }

    private void _registerRelatedInfoItemCollectionProvider(ObjectDefinition objectDefinition1, ObjectDefinition objectDefinition2, ObjectRelationship objectRelationship) throws PortalException {
        RelatedInfoItemCollectionProvider relatedInfoItemCollectionProvider = this._relatedInfoCollectionProviderFactory.create(objectDefinition1, objectDefinition2, objectRelationship);
        if (relatedInfoItemCollectionProvider == null) {
            return;
        }
        this._serviceRegistrations.computeIfAbsent(this._getServiceRegistrationKey(objectRelationship), serviceRegistrationKey -> this._bundleContext.registerService(RelatedInfoItemCollectionProvider.class, (Object)relatedInfoItemCollectionProvider, (Dictionary)HashMapDictionaryBuilder.put((Object)"company.id", (Object)objectDefinition1.getCompanyId()).put((Object)"item.class.name", (Object)objectDefinition1.getClassName()).build()));
    }

    private ObjectRelationship _updateObjectRelationship(long parameterObjectFieldId, String deletionType, boolean edge, Map<Locale, String> labelMap, ObjectRelationship objectRelationship) {
        objectRelationship.setParameterObjectFieldId(parameterObjectFieldId);
        objectRelationship.setDeletionType(deletionType);
        objectRelationship.setEdge(edge);
        objectRelationship.setLabelMap(labelMap);
        return (ObjectRelationship)this.objectRelationshipPersistence.update((BaseModel)objectRelationship);
    }

    private void _validateEdge(boolean edge, ObjectRelationship objectRelationship) throws PortalException {
        if (!edge) {
            return;
        }
        if (!Objects.equals(objectRelationship.getType(), "oneToMany")) {
            throw new ObjectRelationshipEdgeException("Object relationship must be one to many to be an edge of a root context");
        }
        if (objectRelationship.isSelf()) {
            throw new ObjectRelationshipEdgeException("Object relationship must not be a self-relationship to be an edge of a root context");
        }
        ObjectDefinitionLocalService objectDefinitionLocalService = (ObjectDefinitionLocalService)_objectDefinitionLocalServiceSnapshot.get();
        ObjectDefinition objectDefinition1 = objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
        ObjectDefinition objectDefinition2 = objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId2());
        if (objectDefinition1.isUnmodifiableSystemObject() || objectDefinition2.isUnmodifiableSystemObject()) {
            throw new ObjectRelationshipEdgeException("Object relationship must not be between unmodifiable system object definitions to be an edge of a root context");
        }
    }

    private void _validateName(long objectDefinitionId1, String name) throws PortalException {
        char[] nameCharArray;
        if (Validator.isNull((String)name)) {
            throw new ObjectRelationshipNameException("Name is null");
        }
        for (char c : nameCharArray = name.toCharArray()) {
            if (Validator.isChar((char)c) || Validator.isDigit((char)c)) continue;
            throw new ObjectRelationshipNameException("Name must only contain letters and digits");
        }
        if (!Character.isLowerCase(nameCharArray[0])) {
            throw new ObjectRelationshipNameException("The first character of a name must be a lower case letter");
        }
        if (nameCharArray.length > 41) {
            throw new ObjectRelationshipNameException("Name must be less than 41 characters");
        }
        int count = this.objectRelationshipPersistence.countByODI1_N(objectDefinitionId1, name);
        if (count > 0) {
            throw new DuplicateObjectRelationshipException("Duplicate name " + name);
        }
    }

    private void _validateObjectEntryId(ObjectDefinition objectDefinition, long primaryKey) throws PortalException {
        if (objectDefinition.isUnmodifiableSystemObject()) {
            SystemObjectDefinitionManager systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(objectDefinition.getName());
            systemObjectDefinitionManager.getBaseModelExternalReferenceCode(primaryKey);
        } else {
            this._objectEntryLocalService.getObjectEntry(primaryKey);
        }
    }

    private void _validateParameterObjectFieldId(ObjectDefinition objectDefinition1, ObjectDefinition objectDefinition2, long parameterObjectFieldId, String type) throws PortalException {
        String restContextPath = "";
        if (!objectDefinition1.isUnmodifiableSystemObject()) {
            restContextPath = objectDefinition1.getRESTContextPath();
        } else {
            SystemObjectDefinitionManager systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(objectDefinition1.getName());
            if (systemObjectDefinitionManager != null) {
                JaxRsApplicationDescriptor jaxRsApplicationDescriptor = systemObjectDefinitionManager.getJaxRsApplicationDescriptor();
                restContextPath = jaxRsApplicationDescriptor.getRESTContextPath();
            }
        }
        boolean parameterRequired = restContextPath.matches(".*/\\{\\w+}/.*");
        if (parameterObjectFieldId == 0L && parameterRequired) {
            throw new ObjectRelationshipParameterObjectFieldIdException("Object definition " + objectDefinition1.getName() + " requires a parameter object field ID");
        }
        if (parameterObjectFieldId > 0L) {
            if (!Objects.equals(type, "oneToMany")) {
                throw new ObjectRelationshipParameterObjectFieldIdException("Object relationship type " + type + " does not allow a parameter object field ID");
            }
            if (!parameterRequired) {
                throw new ObjectRelationshipParameterObjectFieldIdException("Object definition " + objectDefinition1.getName() + " does not allow a parameter object field ID");
            }
            ObjectField objectField = this._objectFieldLocalService.fetchObjectField(parameterObjectFieldId);
            if (objectField == null) {
                throw new ObjectRelationshipParameterObjectFieldIdException("Parameter object field ID " + parameterObjectFieldId + " does not exist");
            }
            if (objectDefinition2.getObjectDefinitionId() != objectField.getObjectDefinitionId()) {
                throw new ObjectRelationshipParameterObjectFieldIdException(StringBundler.concat((Object[])new Object[]{"Parameter object field ID ", parameterObjectFieldId, " does not belong to object definition ", objectDefinition2.getName()}));
            }
            if (!Objects.equals(objectField.getBusinessType(), "Relationship")) {
                throw new ObjectRelationshipParameterObjectFieldIdException("Parameter object field ID " + parameterObjectFieldId + " does not belong to a relationship object field");
            }
        }
    }

    private void _validateType(ObjectDefinition objectDefinition1, ObjectDefinition objectDefinition2, String name, long parameterObjectFieldId, String type) throws PortalException {
        int count;
        Set defaultObjectRelationshipTypes = ObjectRelationshipUtil.getDefaultObjectRelationshipTypes();
        if (!defaultObjectRelationshipTypes.contains(type)) {
            throw new ObjectRelationshipTypeException("Invalid type " + type);
        }
        if ((Objects.equals(type, "manyToMany") || Objects.equals(type, "oneToOne")) && (count = this.objectRelationshipPersistence.countByODI1_ODI2_N_T(objectDefinition2.getObjectDefinitionId(), objectDefinition1.getObjectDefinitionId(), name, type)) > 0) {
            throw new ObjectRelationshipTypeException("Inverse type already exists");
        }
        if (objectDefinition1.isUnmodifiableSystemObject()) {
            if (objectDefinition2.isUnmodifiableSystemObject()) {
                throw new ObjectRelationshipTypeException("Relationships are not allowed between system objects");
            }
            SystemObjectDefinitionManager systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(objectDefinition1.getName());
            Set allowedObjectRelationshipTypes = systemObjectDefinitionManager.getAllowedObjectRelationshipTypes();
            if (!allowedObjectRelationshipTypes.contains(type)) {
                throw new ObjectRelationshipTypeException("Invalid type for system object definition " + objectDefinition1.getObjectDefinitionId());
            }
        }
        this._validateParameterObjectFieldId(objectDefinition1, objectDefinition2, parameterObjectFieldId, type);
    }
}

