/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.object.exception.ObjectValidationRuleEngineException;
import com.liferay.object.exception.ObjectValidationRuleNameException;
import com.liferay.object.exception.ObjectValidationRuleOutputTypeException;
import com.liferay.object.exception.ObjectValidationRuleScriptException;
import com.liferay.object.exception.ObjectValidationRuleSettingNameException;
import com.liferay.object.exception.ObjectValidationRuleSettingValueException;
import com.liferay.object.internal.action.util.ObjectEntryVariablesUtil;
import com.liferay.object.internal.validation.rule.FunctionObjectValidationRuleEngineImpl;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectValidationRule;
import com.liferay.object.model.ObjectValidationRuleSetting;
import com.liferay.object.scripting.exception.ObjectScriptingException;
import com.liferay.object.scripting.validator.ObjectScriptingValidator;
import com.liferay.object.service.ObjectValidationRuleSettingLocalService;
import com.liferay.object.service.base.ObjectValidationRuleLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.object.service.persistence.ObjectFieldPersistence;
import com.liferay.object.service.persistence.ObjectValidationRuleSettingPersistence;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.object.validation.rule.ObjectValidationRuleEngine;
import com.liferay.object.validation.rule.ObjectValidationRuleEngineRegistry;
import com.liferay.object.validation.rule.ObjectValidationRuleResult;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectValidationRule"}, service={AopService.class})
public class ObjectValidationRuleLocalServiceImpl
extends ObjectValidationRuleLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ObjectValidationRuleLocalServiceImpl.class);
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private Language _language;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectFieldPersistence _objectFieldPersistence;
    @Reference
    private ObjectScriptingValidator _objectScriptingValidator;
    @Reference
    private ObjectValidationRuleEngineRegistry _objectValidationRuleEngineRegistry;
    @Reference
    private ObjectValidationRuleSettingLocalService _objectValidationRuleSettingLocalService;
    @Reference
    private ObjectValidationRuleSettingPersistence _objectValidationRuleSettingPersistence;
    @Reference
    private SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectValidationRule addObjectValidationRule(long userId, long objectDefinitionId, boolean active, String engine, Map<Locale, String> errorLabelMap, Map<Locale, String> nameMap, String outputType, String script, List<ObjectValidationRuleSetting> objectValidationRuleSettings) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        this._validate(user.getCompanyId(), engine, nameMap, outputType, script, objectValidationRuleSettings);
        ObjectValidationRule objectValidationRule = this.objectValidationRulePersistence.create(this.counterLocalService.increment());
        objectValidationRule.setCompanyId(user.getCompanyId());
        objectValidationRule.setUserId(user.getUserId());
        objectValidationRule.setUserName(user.getFullName());
        objectValidationRule.setObjectDefinitionId(objectDefinitionId);
        objectValidationRule.setActive(active);
        objectValidationRule.setEngine(engine);
        objectValidationRule.setErrorLabelMap(errorLabelMap);
        objectValidationRule.setNameMap(nameMap);
        objectValidationRule.setOutputType(outputType);
        objectValidationRule.setScript(script);
        objectValidationRule = (ObjectValidationRule)this.objectValidationRulePersistence.update((BaseModel)objectValidationRule);
        objectValidationRule.setObjectValidationRuleSettings(this._addObjectValidationRuleSettings(objectValidationRule, objectValidationRuleSettings));
        return objectValidationRule;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public ObjectValidationRule deleteObjectValidationRule(long objectValidationRuleId) throws PortalException {
        ObjectValidationRule objectValidationRule = this.objectValidationRulePersistence.findByPrimaryKey(objectValidationRuleId);
        return this.deleteObjectValidationRule(objectValidationRule);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectValidationRule deleteObjectValidationRule(ObjectValidationRule objectValidationRule) {
        objectValidationRule = (ObjectValidationRule)this.objectValidationRulePersistence.remove((BaseModel)objectValidationRule);
        this._objectValidationRuleSettingPersistence.removeByObjectValidationRuleId(objectValidationRule.getObjectValidationRuleId());
        return objectValidationRule;
    }

    public void deleteObjectValidationRules(Long objectDefinitionId) throws PortalException {
        for (ObjectValidationRule objectValidationRule : this.objectValidationRulePersistence.findByObjectDefinitionId(objectDefinitionId.longValue())) {
            this.objectValidationRuleLocalService.deleteObjectValidationRule(objectValidationRule);
        }
    }

    @Override
    public ObjectValidationRule getObjectValidationRule(long objectValidationRuleId) throws PortalException {
        ObjectValidationRule objectValidationRule = this.objectValidationRulePersistence.findByPrimaryKey(objectValidationRuleId);
        objectValidationRule.setObjectValidationRuleSettings(this._objectValidationRuleSettingPersistence.findByObjectValidationRuleId(objectValidationRuleId));
        return objectValidationRule;
    }

    public List<ObjectValidationRule> getObjectValidationRules(long objectDefinitionId) {
        return this._getObjectValidationRules(this.objectValidationRulePersistence.findByObjectDefinitionId(objectDefinitionId));
    }

    public List<ObjectValidationRule> getObjectValidationRules(long objectDefinitionId, boolean active) {
        return this._getObjectValidationRules(this.objectValidationRulePersistence.findByODI_A(objectDefinitionId, active));
    }

    public int getObjectValidationRulesCount(long objectDefinitionId, boolean active) {
        return this.objectValidationRulePersistence.countByODI_A(objectDefinitionId, active);
    }

    public void unassociateObjectField(ObjectField objectField) {
        for (ObjectValidationRule objectValidationRule : this.objectValidationRulePersistence.findByODI_O(objectField.getObjectDefinitionId(), "partialValidation")) {
            ObjectValidationRuleSetting objectValidationRuleSetting = this._objectValidationRuleSettingPersistence.fetchByOVRI_N_V(objectValidationRule.getObjectValidationRuleId(), "objectFieldId", String.valueOf(objectField.getObjectFieldId()));
            if (objectValidationRuleSetting == null) continue;
            this._objectValidationRuleSettingPersistence.remove((BaseModel)objectValidationRuleSetting);
            int count = this._objectValidationRuleSettingPersistence.countByOVRI_N(objectValidationRule.getObjectValidationRuleId(), "objectFieldId");
            if (count != 0) continue;
            objectValidationRule.setOutputType("fullValidation");
            this.objectValidationRulePersistence.update((BaseModel)objectValidationRule);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectValidationRule updateObjectValidationRule(long objectValidationRuleId, boolean active, String engine, Map<Locale, String> errorLabelMap, Map<Locale, String> nameMap, String outputType, String script, List<ObjectValidationRuleSetting> objectValidationRuleSettings) throws PortalException {
        ObjectValidationRule objectValidationRule = this.objectValidationRulePersistence.findByPrimaryKey(objectValidationRuleId);
        this._validate(objectValidationRule.getCompanyId(), engine, nameMap, outputType, script, objectValidationRuleSettings);
        objectValidationRule.setActive(active);
        objectValidationRule.setEngine(engine);
        objectValidationRule.setErrorLabelMap(errorLabelMap);
        objectValidationRule.setNameMap(nameMap);
        objectValidationRule.setOutputType(outputType);
        objectValidationRule.setScript(script);
        objectValidationRule = (ObjectValidationRule)this.objectValidationRulePersistence.update((BaseModel)objectValidationRule);
        this._objectValidationRuleSettingPersistence.removeByObjectValidationRuleId(objectValidationRuleId);
        objectValidationRule.setObjectValidationRuleSettings(this._addObjectValidationRuleSettings(objectValidationRule, objectValidationRuleSettings));
        return objectValidationRule;
    }

    @Transactional(readOnly=true)
    public void validate(BaseModel<?> baseModel, long objectDefinitionId, JSONObject payloadJSONObject, long userId) throws PortalException {
        if (baseModel == null) {
            return;
        }
        List objectValidationRules = this.objectValidationRuleLocalService.getObjectValidationRules(objectDefinitionId, true);
        if (ListUtil.isEmpty((List)objectValidationRules)) {
            return;
        }
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
        Map<String, Object> variables = ObjectEntryVariablesUtil.getVariables(this._dtoConverterRegistry, objectDefinition, payloadJSONObject, this._systemObjectDefinitionManagerRegistry);
        ArrayList<ObjectValidationRuleResult> objectValidationRuleResults = new ArrayList<ObjectValidationRuleResult>();
        for (ObjectValidationRule objectValidationRule : objectValidationRules) {
            Map results = new HashMap();
            ObjectValidationRuleEngine objectValidationRuleEngine = this._objectValidationRuleEngineRegistry.getObjectValidationRuleEngine(objectValidationRule.getCompanyId(), objectValidationRule.getEngine());
            results = StringUtil.equals((String)objectValidationRuleEngine.getKey(), (String)"ddm") ? objectValidationRuleEngine.execute(variables, objectValidationRule.getScript()) : (StringUtil.equals((String)objectValidationRuleEngine.getKey(), (String)"groovy") ? objectValidationRuleEngine.execute((Map)variables.get("baseModel"), objectValidationRule.getScript()) : objectValidationRuleEngine.execute((Map)variables.get("entryDTO"), null));
            Locale locale = LocaleUtil.getMostRelevantLocale();
            User user = this._userLocalService.fetchUser(userId);
            if (user != null) {
                locale = user.getLocale();
            }
            if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-187846")) {
                if (!GetterUtil.getBoolean(results.get("validationCriteriaMet"))) {
                    throw new ObjectValidationRuleEngineException.InvalidFields(objectValidationRule.getErrorLabel(locale));
                }
                if (!GetterUtil.getBoolean(results.get("invalidScript"))) continue;
                throw new ObjectValidationRuleEngineException.InvalidScript();
            }
            String errorMessage = null;
            if (!GetterUtil.getBoolean(results.get("validationCriteriaMet"))) {
                errorMessage = objectValidationRule.getErrorLabel(locale);
            } else if (GetterUtil.getBoolean(results.get("invalidScript"))) {
                errorMessage = this._language.get(locale, "there-was-an-error-validating-your-data");
            }
            if (Validator.isNull((String)errorMessage)) continue;
            if (objectValidationRule.compareOutputType("partialValidation")) {
                for (ObjectValidationRuleSetting objectValidationRuleSetting : this._objectValidationRuleSettingPersistence.findByOVRI_N(objectValidationRule.getObjectValidationRuleId(), "objectFieldId")) {
                    ObjectField objectField = this._objectFieldPersistence.fetchByPrimaryKey(GetterUtil.getLong((String)objectValidationRuleSetting.getValue()));
                    if (objectField == null) continue;
                    objectValidationRuleResults.add(new ObjectValidationRuleResult(errorMessage, objectField.getName()));
                }
                continue;
            }
            objectValidationRuleResults.add(new ObjectValidationRuleResult(errorMessage));
        }
        if (ListUtil.isNotEmpty(objectValidationRuleResults)) {
            throw new ObjectValidationRuleEngineException(objectValidationRuleResults);
        }
    }

    private List<ObjectValidationRuleSetting> _addObjectValidationRuleSettings(ObjectValidationRule objectValidationRule, List<ObjectValidationRuleSetting> objectValidationRuleSettings) {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-187846")) {
            return Collections.emptyList();
        }
        return TransformUtil.transform(objectValidationRuleSettings, objectValidationRuleSetting -> this._objectValidationRuleSettingLocalService.addObjectValidationRuleSetting(objectValidationRule.getUserId(), objectValidationRule.getObjectValidationRuleId(), objectValidationRuleSetting.getName(), objectValidationRuleSetting.getValue()));
    }

    private List<ObjectValidationRule> _getObjectValidationRules(List<ObjectValidationRule> objectValidationRules) {
        for (ObjectValidationRule objectValidationRule : objectValidationRules) {
            objectValidationRule.setObjectValidationRuleSettings(this._objectValidationRuleSettingPersistence.findByObjectValidationRuleId(objectValidationRule.getObjectValidationRuleId()));
        }
        return objectValidationRules;
    }

    private void _validate(long companyId, String engine, Map<Locale, String> nameMap, String outputType, String script, List<ObjectValidationRuleSetting> objectValidationRuleSettings) throws PortalException {
        if (Validator.isNull((String)engine)) {
            throw new ObjectValidationRuleEngineException.MustNotBeNull();
        }
        ObjectValidationRuleEngine objectValidationRuleEngine = this._objectValidationRuleEngineRegistry.getObjectValidationRuleEngine(companyId, engine);
        if (objectValidationRuleEngine == null) {
            throw new ObjectValidationRuleEngineException.NoSuchEngine(engine);
        }
        Locale locale = LocaleUtil.getSiteDefault();
        if (nameMap == null || Validator.isNull((String)nameMap.get(locale))) {
            throw new ObjectValidationRuleNameException("Name is null for locale " + locale.getDisplayName());
        }
        if (FeatureFlagManagerUtil.isEnabled((String)"LPS-187846") && !StringUtil.equals((String)outputType, (String)"fullValidation") && !StringUtil.equals((String)outputType, (String)"partialValidation")) {
            throw new ObjectValidationRuleOutputTypeException("Invalid output type " + outputType);
        }
        if (Validator.isNull((String)script) && !(objectValidationRuleEngine instanceof FunctionObjectValidationRuleEngineImpl)) {
            throw new ObjectValidationRuleScriptException("The script is required", "required");
        }
        try {
            if (Objects.equals(engine, "ddm")) {
                this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)script).build());
            } else if (Objects.equals(engine, "groovy")) {
                this._objectScriptingValidator.validate("groovy", script);
            }
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            if (portalException instanceof ObjectScriptingException) {
                ObjectScriptingException objectScriptingException = (ObjectScriptingException)((Object)portalException);
                throw new ObjectValidationRuleScriptException(objectScriptingException.getMessage(), objectScriptingException.getMessageKey());
            }
            throw new ObjectValidationRuleScriptException("The script syntax is invalid", "syntax-error");
        }
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-187846")) {
            return;
        }
        if (StringUtil.equals((String)outputType, (String)"partialValidation") && ListUtil.isEmpty(objectValidationRuleSettings)) {
            throw new ObjectValidationRuleSettingNameException.MissingRequiredName("objectFieldId");
        }
        for (ObjectValidationRuleSetting objectValidationRuleSetting : objectValidationRuleSettings) {
            if (StringUtil.equals((String)outputType, (String)"fullValidation") || !objectValidationRuleSetting.compareName("objectFieldId")) {
                throw new ObjectValidationRuleSettingNameException.NotAllowedName(objectValidationRuleSetting.getName());
            }
            ObjectField objectField = this._objectFieldPersistence.fetchByPrimaryKey(GetterUtil.getLong((String)objectValidationRuleSetting.getValue()));
            if (objectField != null && !objectField.isSystem()) continue;
            throw new ObjectValidationRuleSettingValueException.InvalidValue(objectValidationRuleSetting.getName(), objectValidationRuleSetting.getValue());
        }
    }
}

