/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.persistence.impl;

import com.liferay.object.exception.NoSuchObjectFilterException;
import com.liferay.object.model.ObjectFilter;
import com.liferay.object.model.ObjectFilterTable;
import com.liferay.object.model.impl.ObjectFilterImpl;
import com.liferay.object.model.impl.ObjectFilterModelImpl;
import com.liferay.object.service.persistence.ObjectFilterPersistence;
import com.liferay.object.service.persistence.ObjectFilterUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUID;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectFilterPersistence.class})
public class ObjectFilterPersistenceImpl
extends BasePersistenceImpl<ObjectFilter>
implements ObjectFilterPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ObjectFilterImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "objectFilter.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(objectFilter.uuid IS NULL OR objectFilter.uuid = '')";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "objectFilter.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(objectFilter.uuid IS NULL OR objectFilter.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "objectFilter.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByObjectFieldId;
    private FinderPath _finderPathWithoutPaginationFindByObjectFieldId;
    private FinderPath _finderPathCountByObjectFieldId;
    private static final String _FINDER_COLUMN_OBJECTFIELDID_OBJECTFIELDID_2 = "objectFilter.objectFieldId = ?";
    private int _valueObjectFinderCacheListThreshold;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_OBJECTFILTER = "SELECT objectFilter FROM ObjectFilter objectFilter";
    private static final String _SQL_SELECT_OBJECTFILTER_WHERE = "SELECT objectFilter FROM ObjectFilter objectFilter WHERE ";
    private static final String _SQL_COUNT_OBJECTFILTER = "SELECT COUNT(objectFilter) FROM ObjectFilter objectFilter";
    private static final String _SQL_COUNT_OBJECTFILTER_WHERE = "SELECT COUNT(objectFilter) FROM ObjectFilter objectFilter WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "objectFilter.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ObjectFilter exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ObjectFilter exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(ObjectFilterPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});
    @Reference
    private PortalUUID _portalUUID;

    public List<ObjectFilter> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<ObjectFilter> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<ObjectFilter> findByUuid(String uuid, int start, int end, OrderByComparator<ObjectFilter> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<ObjectFilter> findByUuid(String uuid, int start, int end, OrderByComparator<ObjectFilter> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (ObjectFilter objectFilter : list) {
                if (uuid.equals(objectFilter.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OBJECTFILTER_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY objectFilter.objectFilterId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ObjectFilter findByUuid_First(String uuid, OrderByComparator<ObjectFilter> orderByComparator) throws NoSuchObjectFilterException {
        ObjectFilter objectFilter = this.fetchByUuid_First(uuid, orderByComparator);
        if (objectFilter != null) {
            return objectFilter;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchObjectFilterException(sb.toString());
    }

    public ObjectFilter fetchByUuid_First(String uuid, OrderByComparator<ObjectFilter> orderByComparator) {
        List<ObjectFilter> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectFilter findByUuid_Last(String uuid, OrderByComparator<ObjectFilter> orderByComparator) throws NoSuchObjectFilterException {
        ObjectFilter objectFilter = this.fetchByUuid_Last(uuid, orderByComparator);
        if (objectFilter != null) {
            return objectFilter;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchObjectFilterException(sb.toString());
    }

    public ObjectFilter fetchByUuid_Last(String uuid, OrderByComparator<ObjectFilter> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<ObjectFilter> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectFilter[] findByUuid_PrevAndNext(long objectFilterId, String uuid, OrderByComparator<ObjectFilter> orderByComparator) throws NoSuchObjectFilterException {
        uuid = Objects.toString(uuid, "");
        ObjectFilter objectFilter = this.findByPrimaryKey(objectFilterId);
        Session session = null;
        try {
            session = this.openSession();
            ObjectFilter[] array = new ObjectFilterImpl[]{this.getByUuid_PrevAndNext(session, objectFilter, uuid, orderByComparator, true), objectFilter, this.getByUuid_PrevAndNext(session, objectFilter, uuid, orderByComparator, false)};
            ObjectFilter[] objectFilterArray = array;
            return objectFilterArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectFilter getByUuid_PrevAndNext(Session session, ObjectFilter objectFilter, String uuid, OrderByComparator<ObjectFilter> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OBJECTFILTER_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY objectFilter.objectFilterId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)objectFilter)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ObjectFilter)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (ObjectFilter objectFilter : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)objectFilter);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OBJECTFILTER_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ObjectFilter> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<ObjectFilter> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<ObjectFilter> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<ObjectFilter> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<ObjectFilter> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<ObjectFilter> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (ObjectFilter objectFilter : list) {
                if (uuid.equals(objectFilter.getUuid()) && companyId == objectFilter.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_OBJECTFILTER_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY objectFilter.objectFilterId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ObjectFilter findByUuid_C_First(String uuid, long companyId, OrderByComparator<ObjectFilter> orderByComparator) throws NoSuchObjectFilterException {
        ObjectFilter objectFilter = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (objectFilter != null) {
            return objectFilter;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchObjectFilterException(sb.toString());
    }

    public ObjectFilter fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<ObjectFilter> orderByComparator) {
        List<ObjectFilter> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectFilter findByUuid_C_Last(String uuid, long companyId, OrderByComparator<ObjectFilter> orderByComparator) throws NoSuchObjectFilterException {
        ObjectFilter objectFilter = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (objectFilter != null) {
            return objectFilter;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchObjectFilterException(sb.toString());
    }

    public ObjectFilter fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<ObjectFilter> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<ObjectFilter> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectFilter[] findByUuid_C_PrevAndNext(long objectFilterId, String uuid, long companyId, OrderByComparator<ObjectFilter> orderByComparator) throws NoSuchObjectFilterException {
        uuid = Objects.toString(uuid, "");
        ObjectFilter objectFilter = this.findByPrimaryKey(objectFilterId);
        Session session = null;
        try {
            session = this.openSession();
            ObjectFilter[] array = new ObjectFilterImpl[]{this.getByUuid_C_PrevAndNext(session, objectFilter, uuid, companyId, orderByComparator, true), objectFilter, this.getByUuid_C_PrevAndNext(session, objectFilter, uuid, companyId, orderByComparator, false)};
            ObjectFilter[] objectFilterArray = array;
            return objectFilterArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectFilter getByUuid_C_PrevAndNext(Session session, ObjectFilter objectFilter, String uuid, long companyId, OrderByComparator<ObjectFilter> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_OBJECTFILTER_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
        }
        sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY objectFilter.objectFilterId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)objectFilter)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ObjectFilter)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (ObjectFilter objectFilter : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)objectFilter);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_OBJECTFILTER_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ObjectFilter> findByObjectFieldId(long objectFieldId) {
        return this.findByObjectFieldId(objectFieldId, -1, -1, null);
    }

    public List<ObjectFilter> findByObjectFieldId(long objectFieldId, int start, int end) {
        return this.findByObjectFieldId(objectFieldId, start, end, null);
    }

    public List<ObjectFilter> findByObjectFieldId(long objectFieldId, int start, int end, OrderByComparator<ObjectFilter> orderByComparator) {
        return this.findByObjectFieldId(objectFieldId, start, end, orderByComparator, true);
    }

    public List<ObjectFilter> findByObjectFieldId(long objectFieldId, int start, int end, OrderByComparator<ObjectFilter> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByObjectFieldId;
                finderArgs = new Object[]{objectFieldId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByObjectFieldId;
            finderArgs = new Object[]{objectFieldId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (ObjectFilter objectFilter : list) {
                if (objectFieldId == objectFilter.getObjectFieldId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OBJECTFILTER_WHERE);
            sb.append(_FINDER_COLUMN_OBJECTFIELDID_OBJECTFIELDID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY objectFilter.objectFilterId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(objectFieldId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ObjectFilter findByObjectFieldId_First(long objectFieldId, OrderByComparator<ObjectFilter> orderByComparator) throws NoSuchObjectFilterException {
        ObjectFilter objectFilter = this.fetchByObjectFieldId_First(objectFieldId, orderByComparator);
        if (objectFilter != null) {
            return objectFilter;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("objectFieldId=");
        sb.append(objectFieldId);
        sb.append("}");
        throw new NoSuchObjectFilterException(sb.toString());
    }

    public ObjectFilter fetchByObjectFieldId_First(long objectFieldId, OrderByComparator<ObjectFilter> orderByComparator) {
        List<ObjectFilter> list = this.findByObjectFieldId(objectFieldId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectFilter findByObjectFieldId_Last(long objectFieldId, OrderByComparator<ObjectFilter> orderByComparator) throws NoSuchObjectFilterException {
        ObjectFilter objectFilter = this.fetchByObjectFieldId_Last(objectFieldId, orderByComparator);
        if (objectFilter != null) {
            return objectFilter;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("objectFieldId=");
        sb.append(objectFieldId);
        sb.append("}");
        throw new NoSuchObjectFilterException(sb.toString());
    }

    public ObjectFilter fetchByObjectFieldId_Last(long objectFieldId, OrderByComparator<ObjectFilter> orderByComparator) {
        int count = this.countByObjectFieldId(objectFieldId);
        if (count == 0) {
            return null;
        }
        List<ObjectFilter> list = this.findByObjectFieldId(objectFieldId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectFilter[] findByObjectFieldId_PrevAndNext(long objectFilterId, long objectFieldId, OrderByComparator<ObjectFilter> orderByComparator) throws NoSuchObjectFilterException {
        ObjectFilter objectFilter = this.findByPrimaryKey(objectFilterId);
        Session session = null;
        try {
            session = this.openSession();
            ObjectFilter[] array = new ObjectFilterImpl[]{this.getByObjectFieldId_PrevAndNext(session, objectFilter, objectFieldId, orderByComparator, true), objectFilter, this.getByObjectFieldId_PrevAndNext(session, objectFilter, objectFieldId, orderByComparator, false)};
            ObjectFilter[] objectFilterArray = array;
            return objectFilterArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectFilter getByObjectFieldId_PrevAndNext(Session session, ObjectFilter objectFilter, long objectFieldId, OrderByComparator<ObjectFilter> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OBJECTFILTER_WHERE);
        sb.append(_FINDER_COLUMN_OBJECTFIELDID_OBJECTFIELDID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY objectFilter.objectFilterId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(objectFieldId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)objectFilter)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ObjectFilter)list.get(1);
        }
        return null;
    }

    public void removeByObjectFieldId(long objectFieldId) {
        for (ObjectFilter objectFilter : this.findByObjectFieldId(objectFieldId, -1, -1, null)) {
            this.remove((BaseModel)objectFilter);
        }
    }

    public int countByObjectFieldId(long objectFieldId) {
        FinderPath finderPath = this._finderPathCountByObjectFieldId;
        Object[] finderArgs = new Object[]{objectFieldId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OBJECTFILTER_WHERE);
            sb.append(_FINDER_COLUMN_OBJECTFIELDID_OBJECTFIELDID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(objectFieldId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ObjectFilterPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(ObjectFilter.class);
        this.setModelImplClass(ObjectFilterImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)ObjectFilterTable.INSTANCE);
    }

    public void cacheResult(ObjectFilter objectFilter) {
        this.entityCache.putResult(ObjectFilterImpl.class, (Serializable)Long.valueOf(objectFilter.getPrimaryKey()), (Serializable)objectFilter);
    }

    public void cacheResult(List<ObjectFilter> objectFilters) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && objectFilters.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (ObjectFilter objectFilter : objectFilters) {
            if (this.entityCache.getResult(ObjectFilterImpl.class, (Serializable)Long.valueOf(objectFilter.getPrimaryKey())) != null) continue;
            this.cacheResult(objectFilter);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(ObjectFilterImpl.class);
        this.finderCache.clearCache(ObjectFilterImpl.class);
    }

    public void clearCache(ObjectFilter objectFilter) {
        this.entityCache.removeResult(ObjectFilterImpl.class, (BaseModel)objectFilter);
    }

    public void clearCache(List<ObjectFilter> objectFilters) {
        for (ObjectFilter objectFilter : objectFilters) {
            this.entityCache.removeResult(ObjectFilterImpl.class, (BaseModel)objectFilter);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(ObjectFilterImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(ObjectFilterImpl.class, primaryKey);
        }
    }

    public ObjectFilter create(long objectFilterId) {
        ObjectFilterImpl objectFilter = new ObjectFilterImpl();
        objectFilter.setNew(true);
        objectFilter.setPrimaryKey(objectFilterId);
        String uuid = this._portalUUID.generate();
        objectFilter.setUuid(uuid);
        objectFilter.setCompanyId(CompanyThreadLocal.getCompanyId());
        return objectFilter;
    }

    public ObjectFilter remove(long objectFilterId) throws NoSuchObjectFilterException {
        return this.remove(Long.valueOf(objectFilterId));
    }

    public ObjectFilter remove(Serializable primaryKey) throws NoSuchObjectFilterException {
        Session session = null;
        try {
            session = this.openSession();
            ObjectFilter objectFilter = (ObjectFilter)session.get(ObjectFilterImpl.class, primaryKey);
            if (objectFilter == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchObjectFilterException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            ObjectFilter objectFilter2 = (ObjectFilter)this.remove((BaseModel)objectFilter);
            return objectFilter2;
        }
        catch (NoSuchObjectFilterException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectFilter removeImpl(ObjectFilter objectFilter) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)objectFilter)) {
                objectFilter = (ObjectFilter)session.get(ObjectFilterImpl.class, objectFilter.getPrimaryKeyObj());
            }
            if (objectFilter != null) {
                session.delete((Object)objectFilter);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (objectFilter != null) {
            this.clearCache(objectFilter);
        }
        return objectFilter;
    }

    public ObjectFilter updateImpl(ObjectFilter objectFilter) {
        boolean isNew = objectFilter.isNew();
        if (!(objectFilter instanceof ObjectFilterModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(objectFilter.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)objectFilter);
                throw new IllegalArgumentException("Implement ModelWrapper in objectFilter proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom ObjectFilter implementation " + objectFilter.getClass());
        }
        ObjectFilterModelImpl objectFilterModelImpl = (ObjectFilterModelImpl)objectFilter;
        if (Validator.isNull((String)objectFilter.getUuid())) {
            String uuid = this._portalUUID.generate();
            objectFilter.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && objectFilter.getCreateDate() == null) {
            if (serviceContext == null) {
                objectFilter.setCreateDate(date);
            } else {
                objectFilter.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!objectFilterModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                objectFilter.setModifiedDate(date);
            } else {
                objectFilter.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)objectFilter);
            } else {
                objectFilter = (ObjectFilter)session.merge((Object)objectFilter);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(ObjectFilterImpl.class, (BaseModel)objectFilterModelImpl, false, true);
        if (isNew) {
            objectFilter.setNew(false);
        }
        objectFilter.resetOriginalValues();
        return objectFilter;
    }

    public ObjectFilter findByPrimaryKey(Serializable primaryKey) throws NoSuchObjectFilterException {
        ObjectFilter objectFilter = (ObjectFilter)this.fetchByPrimaryKey(primaryKey);
        if (objectFilter == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchObjectFilterException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return objectFilter;
    }

    public ObjectFilter findByPrimaryKey(long objectFilterId) throws NoSuchObjectFilterException {
        return this.findByPrimaryKey(Long.valueOf(objectFilterId));
    }

    public ObjectFilter fetchByPrimaryKey(long objectFilterId) {
        return (ObjectFilter)this.fetchByPrimaryKey(Long.valueOf(objectFilterId));
    }

    public List<ObjectFilter> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<ObjectFilter> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<ObjectFilter> findAll(int start, int end, OrderByComparator<ObjectFilter> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<ObjectFilter> findAll(int start, int end, OrderByComparator<ObjectFilter> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_OBJECTFILTER);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_OBJECTFILTER;
                sql = sql.concat(" ORDER BY objectFilter.objectFilterId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (ObjectFilter objectFilter : this.findAll()) {
            this.remove((BaseModel)objectFilter);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_OBJECTFILTER);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "objectFilterId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_OBJECTFILTER;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return ObjectFilterModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathCountByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, false);
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathCountByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, false);
        this._finderPathWithPaginationFindByObjectFieldId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByObjectFieldId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"objectFieldId"}, true);
        this._finderPathWithoutPaginationFindByObjectFieldId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByObjectFieldId", new String[]{Long.class.getName()}, new String[]{"objectFieldId"}, true);
        this._finderPathCountByObjectFieldId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByObjectFieldId", new String[]{Long.class.getName()}, new String[]{"objectFieldId"}, false);
        ObjectFilterUtil.setPersistence((ObjectFilterPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        ObjectFilterUtil.setPersistence(null);
        this.entityCache.removeCache(ObjectFilterImpl.class.getName());
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.object.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.object.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.object.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }
}

