/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

export default function ObjectDefinitionFDSPropsTransformer({...otherProps}) {
	return {
		...otherProps,
		onActionDropdownItemClick({
			action,
			itemData,
		}: {
			action: {data: {id: string}};
			itemData: {id: string};
		}) {
			if (action.data.id === 'deleteObjectDefinition') {
				Liferay.fire('deleteObjectDefinition', {itemData});
			}
		},
	};
}
