/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.on.demand.admin.internal.security.permission.wrapper;

import com.liferay.on.demand.admin.manager.OnDemandAdminManager;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.wrapper.PermissionCheckerWrapper;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.function.Supplier;

public class OnDemandAdminPermissionCheckerWrapper
extends PermissionCheckerWrapper {
    private final OnDemandAdminManager _onDemandAdminManager;
    private final UserLocalService _userLocalService;

    public OnDemandAdminPermissionCheckerWrapper(PermissionChecker permissionChecker, OnDemandAdminManager onDemandAdminManager, UserLocalService userLocalService) {
        super(permissionChecker);
        this._onDemandAdminManager = onDemandAdminManager;
        this._userLocalService = userLocalService;
    }

    public boolean hasPermission(Group group, String name, long primKey, String actionId) {
        return this._hasPermission(name, primKey, () -> super.hasPermission(group, name, primKey, actionId));
    }

    public boolean hasPermission(Group group, String name, String primKey, String actionId) {
        return this._hasPermission(name, GetterUtil.getLong((String)primKey), () -> super.hasPermission(group, name, primKey, actionId));
    }

    public boolean hasPermission(long groupId, String name, long primKey, String actionId) {
        return this._hasPermission(name, primKey, () -> super.hasPermission(groupId, name, primKey, actionId));
    }

    public boolean hasPermission(long groupId, String name, String primKey, String actionId) {
        return this._hasPermission(name, GetterUtil.getLong((String)primKey), () -> super.hasPermission(groupId, name, primKey, actionId));
    }

    private boolean _hasPermission(String name, long primKey, Supplier<Boolean> hasPermissionSupplier) {
        if (!StringUtil.equals((String)name, (String)User.class.getName())) {
            return hasPermissionSupplier.get();
        }
        User user = this._userLocalService.fetchUser(primKey);
        if (user != null && this._onDemandAdminManager.isOnDemandAdminUser(user)) {
            return false;
        }
        return hasPermissionSupplier.get();
    }
}

