/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.organizations.search;

import com.liferay.organizations.search.OrganizationDisplayTerms;
import com.liferay.organizations.search.OrganizationSearchTerms;
import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.SearchOrderByUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class OrganizationSearch
extends SearchContainer<Organization> {
    public static final String EMPTY_RESULTS_MESSAGE = "no-organizations-were-found";
    public static List<String> headerNames = new ArrayList<String>(){
        {
            this.add("name");
            this.add("parent-organization");
            this.add("type");
            this.add("city");
            this.add("region");
            this.add("country");
        }
    };
    public static Map<String, String> orderableHeaders = HashMapBuilder.put((Object)"name", (Object)"name").put((Object)"type", (Object)"type").build();
    private static final Log _log = LogFactoryUtil.getLog(OrganizationSearch.class);

    public OrganizationSearch(PortletRequest portletRequest, PortletURL iteratorURL) {
        this(portletRequest, "cur", iteratorURL);
    }

    public OrganizationSearch(PortletRequest portletRequest, String curParam, PortletURL iteratorURL) {
        super(portletRequest, (DisplayTerms)new OrganizationDisplayTerms(portletRequest), (DisplayTerms)new OrganizationSearchTerms(portletRequest), curParam, DEFAULT_DELTA, iteratorURL, headerNames, EMPTY_RESULTS_MESSAGE);
        OrganizationDisplayTerms displayTerms = (OrganizationDisplayTerms)this.getDisplayTerms();
        iteratorURL.setParameter("city", displayTerms.getCity());
        iteratorURL.setParameter("countryId", String.valueOf(displayTerms.getCountryId()));
        iteratorURL.setParameter("name", displayTerms.getName());
        iteratorURL.setParameter("parentOrganizationId", String.valueOf(displayTerms.getParentOrganizationId()));
        iteratorURL.setParameter("regionId", String.valueOf(displayTerms.getRegionId()));
        iteratorURL.setParameter("street", displayTerms.getStreet());
        iteratorURL.setParameter("type", displayTerms.getType());
        iteratorURL.setParameter("zip", displayTerms.getZip());
        try {
            this.setOrderableHeaders(orderableHeaders);
            String portletId = PortletProviderUtil.getPortletId((String)User.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
            String orderByCol = SearchOrderByUtil.getOrderByCol((PortletRequest)portletRequest, (String)portletId, (String)"organizations-order-by-col", (String)"name");
            this.setOrderByCol(orderByCol);
            String orderByType = SearchOrderByUtil.getOrderByType((PortletRequest)portletRequest, (String)portletId, (String)"organizations-order-by-type", (String)"asc");
            this.setOrderByComparator(UsersAdminUtil.getOrganizationOrderByComparator((String)orderByCol, (String)orderByType));
            this.setOrderByType(orderByType);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to initialize organization search", (Throwable)exception);
        }
    }
}

