/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.organizations.internal.search.spi.model.index.contributor;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchCountryException;
import com.liferay.portal.kernel.exception.NoSuchRegionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.service.CountryService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.RegionService;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.kernel.model.Organization"}, service={ModelDocumentContributor.class})
public class OrganizationModelDocumentContributor
implements ModelDocumentContributor<Organization> {
    private static final Log _log = LogFactoryUtil.getLog(OrganizationModelDocumentContributor.class);
    @Reference
    private CountryService _countryService;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private RegionService _regionService;

    public void contribute(Document document, Organization organization) {
        try {
            document.addKeyword("companyId", organization.getCompanyId());
            document.addText("name", organization.getName());
            document.addKeyword("organizationId", organization.getOrganizationId());
            document.addKeyword("treePath", organization.buildTreePath());
            document.addKeyword("type", organization.getType());
            document.addTextSortable("type", organization.getType());
            document.addTextSortable("nameTreePath", this._buildNameTreePath(organization));
            document.addKeyword("parentOrganizationId", organization.getParentOrganizationId());
            document.remove("userName");
            this._populateAddresses(document, organization.getAddresses(), organization.getRegionId(), organization.getCountryId());
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    private String _buildNameTreePath(Organization organization) throws PortalException {
        ArrayList<Organization> organizations = new ArrayList<Organization>();
        while (organization != null) {
            organizations.add(organization);
            organization = this._organizationLocalService.fetchOrganization(organization.getParentOrganizationId());
        }
        int size = organizations.size();
        StringBundler sb = new StringBundler((size - 1) * 4 + 1);
        organization = (Organization)organizations.get(size - 1);
        sb.append(organization.getName());
        for (int i = size - 2; i >= 0; --i) {
            organization = (Organization)organizations.get(i);
            sb.append(" ");
            sb.append(">");
            sb.append(" ");
            sb.append(organization.getName());
        }
        return sb.toString();
    }

    private Set<String> _getLocalizedCountryNames(Country country) {
        HashSet<String> countryNames = new HashSet<String>();
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            String countryName = country.getName(locale);
            countryName = StringUtil.toLowerCase((String)countryName);
            countryNames.add(countryName);
        }
        return countryNames;
    }

    private void _populateAddresses(Document document, List<Address> addresses, long regionId, long countryId) throws PortalException {
        ArrayList<String> regions;
        ArrayList<String> countries;
        ArrayList<String> cities;
        block8: {
            block7: {
                cities = new ArrayList<String>();
                countries = new ArrayList<String>();
                if (countryId > 0L) {
                    try {
                        countries.addAll(this._getLocalizedCountryNames(this._countryService.getCountry(countryId)));
                    }
                    catch (NoSuchCountryException noSuchCountryException) {
                        if (!_log.isWarnEnabled()) break block7;
                        _log.warn((Object)noSuchCountryException.getMessage());
                    }
                }
            }
            regions = new ArrayList<String>();
            if (regionId > 0L) {
                try {
                    Region region = this._regionService.getRegion(regionId);
                    regions.add(StringUtil.toLowerCase((String)region.getName()));
                }
                catch (NoSuchRegionException noSuchRegionException) {
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn((Object)noSuchRegionException.getMessage());
                }
            }
        }
        ArrayList<String> streets = new ArrayList<String>();
        ArrayList<String> zips = new ArrayList<String>();
        for (Address address : addresses) {
            cities.add(StringUtil.toLowerCase((String)address.getCity()));
            countries.addAll(this._getLocalizedCountryNames(address.getCountry()));
            Region region = address.getRegion();
            regions.add(StringUtil.toLowerCase((String)region.getName()));
            streets.add(StringUtil.toLowerCase((String)address.getStreet1()));
            streets.add(StringUtil.toLowerCase((String)address.getStreet2()));
            streets.add(StringUtil.toLowerCase((String)address.getStreet3()));
            zips.add(StringUtil.toLowerCase((String)address.getZip()));
        }
        document.addText("city", cities.toArray(new String[0]));
        document.addText("country", countries.toArray(new String[0]));
        document.addText("region", regions.toArray(new String[0]));
        document.addKeyword(Field.getSortableFieldName((String)"region"), regions.toArray(new String[0]));
        document.addText("street", streets.toArray(new String[0]));
        document.addText("zip", zips.toArray(new String[0]));
    }
}

