/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.organizations.internal.search.spi.model.query.contributor;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.search.generic.TermQueryImpl;
import com.liferay.portal.kernel.search.generic.WildcardQueryImpl;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import java.util.LinkedHashMap;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.kernel.model.Organization"}, service={ModelPreFilterContributor.class})
public class OrganizationModelPreFilterContributor
implements ModelPreFilterContributor {
    public void contribute(BooleanFilter contextBooleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        List organizationsTree;
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params == null) {
            return;
        }
        List excludedOrganizationIds = (List)params.get("excludedOrganizationIds");
        if (ListUtil.isNotEmpty((List)excludedOrganizationIds)) {
            TermsFilter termsFilter = new TermsFilter("organizationId");
            termsFilter.addValues(ArrayUtil.toStringArray((Object[])excludedOrganizationIds.toArray(new Long[0])));
            contextBooleanFilter.add((Filter)termsFilter, BooleanClauseOccur.MUST_NOT);
        }
        if ((organizationsTree = (List)params.get("organizationsTree")) != null) {
            BooleanFilter booleanFilter = new BooleanFilter();
            if (organizationsTree.isEmpty()) {
                TermQueryImpl termQuery = new TermQueryImpl("treePath", "");
                booleanFilter.add((Filter)new QueryFilter((Query)termQuery));
            }
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            for (Organization organization : organizationsTree) {
                String treePath;
                try {
                    treePath = organization.buildTreePath();
                    if (permissionChecker != null && (permissionChecker.isOrganizationAdmin(organization.getOrganizationId()) || permissionChecker.isOrganizationOwner(organization.getOrganizationId()) || OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (Organization)organization, (String)"MANAGE_SUBORGANIZATIONS"))) {
                        treePath = treePath + "*";
                    }
                }
                catch (PortalException portalException) {
                    throw new RuntimeException(portalException);
                }
                WildcardQueryImpl wildcardQuery = new WildcardQueryImpl("treePath", treePath);
                booleanFilter.add((Filter)new QueryFilter((Query)wildcardQuery));
            }
            contextBooleanFilter.add((Filter)booleanFilter, BooleanClauseOccur.MUST);
        } else {
            long parentOrganizationId = GetterUtil.getLong((Object)searchContext.getAttribute("parentOrganizationId"));
            if (parentOrganizationId != -1L) {
                contextBooleanFilter.addRequiredTerm("parentOrganizationId", parentOrganizationId);
            }
        }
    }
}

