/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.organizations.internal.settings;

import com.liferay.organizations.internal.configuration.OrganizationTypeConfigurationWrapper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.users.admin.kernel.organization.types.OrganizationTypesSettings;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={OrganizationTypesSettings.class})
public class OrganizationTypesSettingsImpl
implements OrganizationTypesSettings {
    private static final Log _log = LogFactoryUtil.getLog(OrganizationTypesSettingsImpl.class);
    private final Map<String, OrganizationTypeConfigurationWrapper> _organizationTypeConfigurationWrappers = new ConcurrentHashMap<String, OrganizationTypeConfigurationWrapper>();

    public String[] getChildrenTypes(String type) {
        OrganizationTypeConfigurationWrapper organizationTypeConfigurationWrapper = this.getOrganizationTypeConfigurationWrapper(type);
        if (organizationTypeConfigurationWrapper == null) {
            return new String[0];
        }
        return organizationTypeConfigurationWrapper.getChildrenTypes();
    }

    public String[] getTypes() {
        return ArrayUtil.toStringArray(this._organizationTypeConfigurationWrappers.keySet());
    }

    public boolean isCountryEnabled(String type) {
        OrganizationTypeConfigurationWrapper organizationTypeConfigurationWrapper = this.getOrganizationTypeConfigurationWrapper(type);
        if (organizationTypeConfigurationWrapper == null) {
            return false;
        }
        return organizationTypeConfigurationWrapper.isCountryEnabled();
    }

    public boolean isCountryRequired(String type) {
        OrganizationTypeConfigurationWrapper organizationTypeConfigurationWrapper = this.getOrganizationTypeConfigurationWrapper(type);
        if (organizationTypeConfigurationWrapper == null) {
            return false;
        }
        return organizationTypeConfigurationWrapper.isCountryRequired();
    }

    public boolean isRootable(String type) {
        OrganizationTypeConfigurationWrapper organizationTypeConfigurationWrapper = this.getOrganizationTypeConfigurationWrapper(type);
        if (organizationTypeConfigurationWrapper == null) {
            return false;
        }
        return organizationTypeConfigurationWrapper.isRootable();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addOrganizationTypeConfigurationWrapper(OrganizationTypeConfigurationWrapper organizationTypeConfigurationWrapper) {
        this._organizationTypeConfigurationWrappers.put(organizationTypeConfigurationWrapper.getName(), organizationTypeConfigurationWrapper);
    }

    protected OrganizationTypeConfigurationWrapper getOrganizationTypeConfigurationWrapper(String type) {
        OrganizationTypeConfigurationWrapper organizationTypeConfigurationWrapper = this._organizationTypeConfigurationWrappers.get(type);
        if (organizationTypeConfigurationWrapper == null) {
            _log.error((Object)("Unable to get organization type: " + type));
        }
        return organizationTypeConfigurationWrapper;
    }

    protected void removeOrganizationTypeConfigurationWrapper(OrganizationTypeConfigurationWrapper organizationTypeConfigurationWrapper) {
        this._organizationTypeConfigurationWrappers.remove(organizationTypeConfigurationWrapper.getName());
    }
}

