/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.organizations.internal.upgrade.v1_0_0;

import com.liferay.organizations.internal.configuration.OrganizationTypeConfiguration;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.Validator;
import java.util.Arrays;
import java.util.Dictionary;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class OrganizationTypesConfigurationUpgradeProcess
extends UpgradeProcess {
    private static final String _FACTORY_PID = OrganizationTypeConfiguration.class.getName();
    private final ConfigurationAdmin _configurationAdmin;
    private final OrganizationTypeConfiguration _organizationTypeConfiguration = (OrganizationTypeConfiguration)ConfigurableUtil.createConfigurable(OrganizationTypeConfiguration.class, (Dictionary)new HashMapDictionary());
    private final Props _props;

    public OrganizationTypesConfigurationUpgradeProcess(ConfigurationAdmin configurationAdmin, Props props) {
        this._configurationAdmin = configurationAdmin;
        this._props = props;
    }

    protected void doUpgrade() throws Exception {
        for (String organizationType : this._props.getArray("organizations.types")) {
            this.upgradeOrganizationTypeConfiguration(organizationType);
        }
    }

    protected void upgradeOrganizationTypeConfiguration(String organizationType) throws Exception {
        Object[] childrenTypes;
        Configuration[] configurations = this._configurationAdmin.listConfigurations(StringBundler.concat((String[])new String[]{"(&(", "service.factoryPid", "=", _FACTORY_PID, ")(name=", organizationType, "))"}));
        if (configurations != null) {
            return;
        }
        HashMapDictionary properties = new HashMapDictionary();
        if (!organizationType.equals(this._organizationTypeConfiguration.name())) {
            properties.put("name", organizationType);
        }
        Filter filter = new Filter(organizationType);
        if (this._props.contains(this._getPropertyName("organizations.children.types", organizationType)) && !Arrays.equals(childrenTypes = this._props.getArray("organizations.children.types", filter), this._organizationTypeConfiguration.childrenTypes())) {
            properties.put("childrenTypes", childrenTypes);
        }
        boolean defaultCountryEnabled = this._organizationTypeConfiguration.countryEnabled();
        boolean countryEnabled = GetterUtil.getBoolean((String)this._props.get("organizations.country.enabled", filter), (boolean)defaultCountryEnabled);
        if (countryEnabled != defaultCountryEnabled) {
            properties.put("countryEnabled", countryEnabled);
        }
        boolean defaultCountryRequired = this._organizationTypeConfiguration.countryRequired();
        boolean countryRequired = GetterUtil.getBoolean((String)this._props.get("organizations.country.required", filter), (boolean)defaultCountryRequired);
        if (countryRequired != defaultCountryRequired) {
            properties.put("countryRequired", countryRequired);
        }
        boolean defaultRootable = this._organizationTypeConfiguration.rootable();
        boolean rootable = GetterUtil.getBoolean((String)this._props.get("organizations.rootable", filter), (boolean)defaultRootable);
        if (rootable != defaultRootable) {
            properties.put("rootable", rootable);
        }
        if (properties.isEmpty()) {
            return;
        }
        if (Validator.isNull(properties.get("name"))) {
            properties.put("name", organizationType);
        }
        Configuration configuration = this._configurationAdmin.createFactoryConfiguration(_FACTORY_PID, "?");
        configuration.update((Dictionary)properties);
    }

    private String _getPropertyName(String basePropertyName, String organizationType) {
        return StringBundler.concat((String[])new String[]{basePropertyName, "[", organizationType, "]"});
    }
}

