/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osgi.log.service.extender.internal.activator;

import com.liferay.osgi.log.service.extender.internal.osgi.commands.LoggingLevelsOSGiCommands;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.log4j.Log4JUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.admin.LoggerAdmin;
import org.osgi.service.log.admin.LoggerContext;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class OSGiLogServiceExtenderBundleActivator
implements BundleActivator {
    private static final Log _log = LogFactoryUtil.getLog(OSGiLogServiceExtenderBundleActivator.class);
    private volatile ServiceTracker<LoggerAdmin, Tracked> _serviceTracker;

    public void start(BundleContext bundleContext) {
        this._serviceTracker = new ServiceTracker(bundleContext, LoggerAdmin.class, (ServiceTrackerCustomizer)new LoggerAdminServiceTrackerCustomizer(bundleContext));
        this._serviceTracker.open();
    }

    public void stop(BundleContext bundleContext) {
        this._serviceTracker.close();
    }

    private static Map<String, LogLevel> _loadLogConfigurations(Bundle bundle) {
        HashMap<String, LogLevel> logLevels = new HashMap<String, LogLevel>();
        try {
            OSGiLogServiceExtenderBundleActivator._loadLogConfigurations(bundle, "osgi-logging.properties", logLevels);
            OSGiLogServiceExtenderBundleActivator._loadLogConfigurations(bundle, "osgi-logging-ext.properties", logLevels);
        }
        catch (IOException ioException) {
            _log.error((Object)("Unable to load OSGi logging configurations for " + bundle), (Throwable)ioException);
            return Collections.emptyMap();
        }
        return logLevels;
    }

    private static Map<String, LogLevel> _loadLogConfigurations(Bundle bundle, String resourcePath, Map<String, LogLevel> logLevels) throws IOException {
        Enumeration enumeration = bundle.findEntries("META-INF", resourcePath, false);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                URL url = (URL)enumeration.nextElement();
                Properties properties = new Properties();
                try (InputStream inputStream = url.openStream();){
                    properties.load(inputStream);
                }
                for (String name : properties.stringPropertyNames()) {
                    String value = properties.getProperty(name);
                    try {
                        logLevels.put(name, LogLevel.valueOf((String)value));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Bundle ", bundle, ", resource ", resourcePath, ", and logger ", name, " contains an invalid log level \"", value, "\""}), (Throwable)illegalArgumentException);
                    }
                }
            }
        }
        return logLevels;
    }

    private static class LoggerContextBundleTrackerCustomizer
    implements BundleTrackerCustomizer<LoggerContext> {
        private final LoggerAdmin _loggerAdmin;

        public LoggerContext addingBundle(Bundle bundle, BundleEvent bundleEvent) {
            Map logLevels = OSGiLogServiceExtenderBundleActivator._loadLogConfigurations(bundle);
            if (logLevels.isEmpty()) {
                return null;
            }
            for (Map.Entry entry : logLevels.entrySet()) {
                String name = "osgi.logging.".concat((String)entry.getKey());
                LogLevel logLevel = (LogLevel)entry.getValue();
                Log4JUtil.setLevel((String)name, (String)logLevel.toString(), (boolean)false);
            }
            LoggerContext loggerContext = this._loggerAdmin.getLoggerContext(StringBundler.concat((Object[])new Object[]{bundle.getSymbolicName(), "|", bundle.getVersion(), "|", bundle.getLocation()}));
            loggerContext.setLogLevels(logLevels);
            return loggerContext;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, LoggerContext loggerContext) {
        }

        public void removedBundle(Bundle bundle, BundleEvent bundleEvent, LoggerContext loggerContext) {
            loggerContext.clear();
        }

        private LoggerContextBundleTrackerCustomizer(LoggerAdmin loggerAdmin) {
            this._loggerAdmin = loggerAdmin;
        }
    }

    private static class LoggerAdminServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<LoggerAdmin, Tracked> {
        private final BundleContext _bundleContext;

        public Tracked addingService(ServiceReference<LoggerAdmin> serviceReference) {
            LoggerAdmin loggerAdmin = (LoggerAdmin)this._bundleContext.getService(serviceReference);
            BundleTracker bundleTracker = new BundleTracker(this._bundleContext, 32, (BundleTrackerCustomizer)new LoggerContextBundleTrackerCustomizer(loggerAdmin));
            bundleTracker.open();
            LoggingLevelsOSGiCommands loggingLevelsOSGiCommands = new LoggingLevelsOSGiCommands(loggerAdmin);
            ServiceRegistration serviceRegistration = this._bundleContext.registerService(LoggingLevelsOSGiCommands.class, (Object)loggingLevelsOSGiCommands, (Dictionary)HashMapDictionaryBuilder.put((Object)"osgi.command.function", (Object)new String[]{"levels", "level"}).put((Object)"osgi.command.scope", (Object)"logging").build());
            return new Tracked((BundleTracker<LoggerContext>)bundleTracker, (ServiceRegistration<LoggingLevelsOSGiCommands>)serviceRegistration);
        }

        public void modifiedService(ServiceReference<LoggerAdmin> serviceReference, Tracked tracked) {
        }

        public void removedService(ServiceReference<LoggerAdmin> serviceReference, Tracked tracked) {
            ServiceRegistration serviceRegistration = (ServiceRegistration)tracked.getValue();
            serviceRegistration.unregister();
            BundleTracker bundleTracker = (BundleTracker)tracked.getKey();
            bundleTracker.close();
            this._bundleContext.ungetService(serviceReference);
        }

        private LoggerAdminServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }
    }

    public static class Tracked
    extends AbstractMap.SimpleEntry<BundleTracker<LoggerContext>, ServiceRegistration<LoggingLevelsOSGiCommands>> {
        public Tracked(BundleTracker<LoggerContext> bundleTracker, ServiceRegistration<LoggingLevelsOSGiCommands> serviceRegistration) {
            super(bundleTracker, serviceRegistration);
        }
    }
}

