/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osgi.log.service.extender.internal.osgi.commands;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.log4j.Log4JUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.admin.LoggerAdmin;
import org.osgi.service.log.admin.LoggerContext;

public class LoggingLevelsOSGiCommands {
    private final LoggerAdmin _loggerAdmin;

    public LoggingLevelsOSGiCommands(LoggerAdmin loggerAdmin) {
        this._loggerAdmin = loggerAdmin;
    }

    public String level(String context, String name, String level) {
        Objects.requireNonNull(name);
        LoggerContext loggerContext = this._loggerAdmin.getLoggerContext(context);
        Map logLevels = loggerContext.getLogLevels();
        LogLevel logLevel = LogLevel.ERROR;
        try {
            if (level == null) {
                logLevels.remove(name);
            } else {
                logLevel = LogLevel.valueOf((String)StringUtil.toUpperCase((String)level));
                logLevels.put(name, logLevel);
            }
            Log4JUtil.setLevel((String)"osgi.logging.".concat(name), (String)logLevel.name(), (boolean)false);
            loggerContext.setLogLevels(logLevels);
            return StringBundler.concat((String[])new String[]{name, "=", logLevel.name()});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "Invalid log level: " + level;
        }
    }

    public String[] levels(String context) {
        LoggerContext loggerContext = this._loggerAdmin.getLoggerContext(context);
        ArrayList<String> categories = new ArrayList<String>();
        Map logLevels = loggerContext.getLogLevels();
        for (Map.Entry entry : logLevels.entrySet()) {
            LogLevel logLevel = (LogLevel)entry.getValue();
            categories.add(StringBundler.concat((String[])new String[]{(String)entry.getKey(), "=", logLevel.name()}));
        }
        return categories.toArray(new String[0]);
    }
}

