/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osgi.service.tracker.collections.internal.list;

import com.liferay.osgi.service.tracker.collections.EagerServiceTrackerCustomizer;
import com.liferay.osgi.service.tracker.collections.ServiceReferenceServiceTuple;
import com.liferay.osgi.service.tracker.collections.internal.ServiceReferenceServiceTupleComparator;
import com.liferay.osgi.service.tracker.collections.internal.ServiceTrackerManager;
import com.liferay.osgi.service.tracker.collections.internal.ServiceTrackerUtil;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTrackerListImpl<S, T>
implements ServiceTrackerList<T> {
    private final BundleContext _bundleContext;
    private final Comparator<ServiceReferenceServiceTuple<S, ?>> _comparator;
    private final List<ServiceReferenceServiceTuple<S, T>> _services = new CopyOnWriteArrayList<ServiceReferenceServiceTuple<S, T>>();
    private final ServiceTracker<S, T> _serviceTracker;
    private final ServiceTrackerCustomizer<S, T> _serviceTrackerCustomizer;
    private final ServiceTrackerManager _serviceTrackerManager;

    public ServiceTrackerListImpl(BundleContext bundleContext, Class<S> clazz, String filterString, ServiceTrackerCustomizer<S, T> serviceTrackerCustomizer, Comparator<ServiceReference<S>> comparator) {
        this._bundleContext = bundleContext;
        this._serviceTrackerCustomizer = serviceTrackerCustomizer;
        this._comparator = comparator == null ? Collections.reverseOrder() : new ServiceReferenceServiceTupleComparator<S>(comparator);
        this._serviceTracker = ServiceTrackerUtil.createServiceTracker(this._bundleContext, clazz, filterString, new ServiceReferenceServiceTrackerCustomizer());
        this._serviceTrackerManager = new ServiceTrackerManager(this._serviceTracker, false);
        if (this._serviceTrackerCustomizer instanceof EagerServiceTrackerCustomizer) {
            this._serviceTrackerManager.open();
        }
    }

    @Override
    public void close() {
        this._serviceTrackerManager.close();
    }

    @Override
    public void forEach(Consumer<? super T> consumer) {
        this._serviceTrackerManager.open();
        this._services.forEach(serviceReferenceServiceTuple -> consumer.accept((Object)serviceReferenceServiceTuple.getService()));
    }

    @Override
    public Iterator<T> iterator() {
        this._serviceTrackerManager.open();
        return new ServiceTrackerListIterator(this._services.iterator());
    }

    @Override
    public int size() {
        this._serviceTrackerManager.open();
        return this._services.size();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        List<E> list = this.toList();
        return list.toArray(array);
    }

    @Override
    public List<T> toList() {
        this._serviceTrackerManager.open();
        ArrayList list = new ArrayList(this._services.size());
        this._services.forEach(serviceReferenceServiceTuple -> list.add(serviceReferenceServiceTuple.getService()));
        return list;
    }

    private class ServiceReferenceServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<S, T> {
        private ServiceReferenceServiceTrackerCustomizer() {
        }

        public T addingService(ServiceReference<S> serviceReference) {
            Object service = ServiceTrackerListImpl.this._serviceTrackerCustomizer.addingService(serviceReference);
            if (service == null) {
                return null;
            }
            this._update(serviceReference, service, false);
            return service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modifiedService(ServiceReference<S> serviceReference, T service) {
            ServiceTrackerListImpl.this._serviceTrackerCustomizer.modifiedService(serviceReference, service);
            List list = ServiceTrackerListImpl.this._services;
            synchronized (list) {
                ServiceTrackerListImpl.this._services.sort(ServiceTrackerListImpl.this._comparator);
            }
        }

        public void removedService(ServiceReference<S> serviceReference, T service) {
            ServiceTrackerListImpl.this._serviceTrackerCustomizer.removedService(serviceReference, service);
            this._update(serviceReference, service, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _update(ServiceReference<S> serviceReference, T service, boolean remove) {
            ServiceReferenceServiceTuple serviceReferenceServiceTuple = new ServiceReferenceServiceTuple(serviceReference, service);
            List list = ServiceTrackerListImpl.this._services;
            synchronized (list) {
                int index = Collections.binarySearch(ServiceTrackerListImpl.this._services, serviceReferenceServiceTuple, ServiceTrackerListImpl.this._comparator);
                if (remove) {
                    if (index >= 0) {
                        ServiceTrackerListImpl.this._services.remove(index);
                    }
                } else if (index < 0) {
                    ServiceTrackerListImpl.this._services.add(-index - 1, serviceReferenceServiceTuple);
                }
            }
        }
    }

    private static class ServiceTrackerListIterator<S, T>
    implements Iterator<T> {
        private final Iterator<ServiceReferenceServiceTuple<S, T>> _iterator;

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public T next() {
            ServiceReferenceServiceTuple<S, T> serviceReferenceServiceTuple = this._iterator.next();
            return serviceReferenceServiceTuple.getService();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private ServiceTrackerListIterator(Iterator<ServiceReferenceServiceTuple<S, T>> iterator) {
            this._iterator = iterator;
        }
    }
}

