/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osgi.service.tracker.collections.internal.map;

import com.liferay.osgi.service.tracker.collections.ServiceReferenceServiceTuple;
import com.liferay.osgi.service.tracker.collections.internal.ServiceReferenceServiceTupleComparator;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerBucket;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerBucketFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.osgi.framework.ServiceReference;

public class MultiValueServiceTrackerBucketFactory<SR, TS>
implements ServiceTrackerBucketFactory<SR, TS, List<TS>> {
    private final Comparator<ServiceReference<SR>> _comparator;

    public MultiValueServiceTrackerBucketFactory() {
        this._comparator = Collections.reverseOrder();
    }

    public MultiValueServiceTrackerBucketFactory(Comparator<ServiceReference<SR>> comparator) {
        this._comparator = comparator;
    }

    @Override
    public ServiceTrackerBucket<SR, TS, List<TS>> create() {
        return new ListServiceTrackerBucket();
    }

    private class ListServiceTrackerBucket
    implements ServiceTrackerBucket<SR, TS, List<TS>> {
        private final ServiceReferenceServiceTupleComparator<SR> _serviceReferenceServiceTupleComparator;
        private final List<ServiceReferenceServiceTuple<SR, TS>> _serviceReferenceServiceTuples;
        private List<TS> _services;

        private ListServiceTrackerBucket() {
            this._serviceReferenceServiceTupleComparator = new ServiceReferenceServiceTupleComparator(MultiValueServiceTrackerBucketFactory.this._comparator);
            this._serviceReferenceServiceTuples = new ArrayList();
            this._services = new ArrayList();
        }

        @Override
        public List<TS> getContent() {
            return this._services;
        }

        @Override
        public synchronized boolean isDisposable() {
            return this._serviceReferenceServiceTuples.isEmpty();
        }

        @Override
        public synchronized void remove(ServiceReferenceServiceTuple<SR, TS> serviceReferenceServiceTuple) {
            this._serviceReferenceServiceTuples.remove(serviceReferenceServiceTuple);
            this._rebuild();
        }

        @Override
        public synchronized void store(ServiceReferenceServiceTuple<SR, TS> serviceReferenceServiceTuple) {
            int index = Collections.binarySearch(this._serviceReferenceServiceTuples, serviceReferenceServiceTuple, this._serviceReferenceServiceTupleComparator);
            if (index < 0) {
                index = -index - 1;
            }
            this._serviceReferenceServiceTuples.add(index, serviceReferenceServiceTuple);
            this._rebuild();
        }

        private void _rebuild() {
            this._services = new ArrayList(this._serviceReferenceServiceTuples.size());
            for (ServiceReferenceServiceTuple serviceReferenceServiceTuple : this._serviceReferenceServiceTuples) {
                this._services.add(serviceReferenceServiceTuple.getService());
            }
            this._services = Collections.unmodifiableList(this._services);
        }
    }
}

