/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osgi.service.tracker.collections.map;

import com.liferay.osgi.service.tracker.collections.map.ServiceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class ServiceReferenceMapperFactory {
    public static <K, S> ServiceReferenceMapper<K, S> create(BundleContext bundleContext, ServiceMapper<K, S> serviceMapper) {
        return (serviceReference, emitter) -> {
            Object service = bundleContext.getService(serviceReference);
            try {
                serviceMapper.map(service, emitter);
            }
            finally {
                bundleContext.ungetService(serviceReference);
            }
        };
    }

    public static <K, S> Function<BundleContext, ServiceReferenceMapper<K, S>> createFromBiFunction(BiFunction<ServiceReference<S>, S, K> biFunction) {
        return bundleContext -> (serviceReference, emitter) -> {
            Object service = bundleContext.getService(serviceReference);
            try {
                emitter.emit(biFunction.apply(serviceReference, service));
            }
            catch (Exception exception) {
                bundleContext.ungetService(serviceReference);
            }
        };
    }

    @Deprecated
    public static <K, S> Function<BundleContext, ServiceReferenceMapper<K, S>> createFromFunction(BiFunction<ServiceReference<S>, S, K> biFunction) {
        return ServiceReferenceMapperFactory.createFromBiFunction(biFunction);
    }

    public static <K, S> ServiceReferenceMapper<K, S> createFromFunction(BundleContext bundleContext, Function<S, K> function) {
        return (serviceReference, emitter) -> {
            Object service = bundleContext.getService(serviceReference);
            try {
                emitter.emit(function.apply(service));
            }
            finally {
                bundleContext.ungetService(serviceReference);
            }
        };
    }
}

