/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osgi.service.tracker.collections.map;

import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ScopedServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapListener;
import java.util.List;
import java.util.function.Supplier;
import org.osgi.framework.BundleContext;

public class ScopedServiceTrackerMapFactory<T> {
    public static <T> ScopedServiceTrackerMap<T> create(BundleContext bundleContext, Class<T> clazz, String property, String filterString, Supplier<T> defaultServiceSupplier) {
        return ScopedServiceTrackerMapFactory.create(bundleContext, clazz, property, filterString, defaultServiceSupplier, () -> {});
    }

    public static <T> ScopedServiceTrackerMap<T> create(BundleContext bundleContext, Class<T> clazz, String property, String filterString, Supplier<T> defaultServiceSupplier, Runnable onChangeRunnable) {
        return new ScopedServiceTrackerMapImpl(bundleContext, clazz, property, filterString, defaultServiceSupplier, onChangeRunnable);
    }

    public static <T> ScopedServiceTrackerMap<T> create(BundleContext bundleContext, Class<T> clazz, String property, Supplier<T> defaultServiceSupplier) {
        return ScopedServiceTrackerMapFactory.create(bundleContext, clazz, property, "", defaultServiceSupplier, () -> {});
    }

    private static class ScopedServiceTrackerMapImpl<T>
    implements ScopedServiceTrackerMap<T> {
        private final Supplier<T> _defaultServiceSupplier;
        private final Runnable _onChangeRunnable;
        private final ServiceTrackerMap<String, List<T>> _servicesByCompany;
        private final ServiceTrackerMap<String, List<T>> _servicesByCompanyAndKey;
        private final ServiceTrackerMap<String, List<T>> _servicesByKey;

        @Override
        public void close() {
            this._servicesByCompany.close();
            this._servicesByCompanyAndKey.close();
            this._servicesByKey.close();
        }

        @Override
        public T getService(long companyId, String key) {
            String companyIdString = String.valueOf(companyId);
            List<T> services = this._servicesByCompanyAndKey.getService(companyIdString + "-" + key);
            if (services != null && !services.isEmpty()) {
                return services.get(0);
            }
            services = this._servicesByKey.getService(key);
            if (services != null && !services.isEmpty()) {
                return services.get(0);
            }
            services = this._servicesByCompany.getService(companyIdString);
            if (services != null && !services.isEmpty()) {
                return services.get(0);
            }
            return this._defaultServiceSupplier.get();
        }

        private ScopedServiceTrackerMapImpl(BundleContext bundleContext, Class<T> clazz, String property, String filterString, Supplier<T> defaultServiceSupplier, Runnable onChangeRunnable) {
            this._defaultServiceSupplier = defaultServiceSupplier;
            this._onChangeRunnable = onChangeRunnable;
            this._servicesByCompany = ServiceTrackerMapFactory.openMultiValueMap(bundleContext, clazz, "(&(companyId=*)(!(" + property + "=*))" + filterString + ")", new PropertyServiceReferenceMapper("companyId"), new ServiceTrackerMapListenerImpl());
            this._servicesByCompanyAndKey = ServiceTrackerMapFactory.openMultiValueMap(bundleContext, clazz, "(&(companyId=*)(" + property + "=*)" + filterString + ")", (serviceReference, emitter) -> {
                PropertyServiceReferenceMapper companyMapper = new PropertyServiceReferenceMapper("companyId");
                PropertyServiceReferenceMapper nameMapper = new PropertyServiceReferenceMapper(property);
                companyMapper.map(serviceReference, key1 -> nameMapper.map(serviceReference, key2 -> emitter.emit(key1 + "-" + key2)));
            }, new ServiceTrackerMapListenerImpl());
            this._servicesByKey = ServiceTrackerMapFactory.openMultiValueMap(bundleContext, clazz, "(&(" + property + "=*)(|(!(companyId=*))(companyId=0))" + filterString + ")", new PropertyServiceReferenceMapper(property), new ServiceTrackerMapListenerImpl());
        }

        private class ServiceTrackerMapListenerImpl
        implements ServiceTrackerMapListener<String, T, List<T>> {
            private ServiceTrackerMapListenerImpl() {
            }

            @Override
            public void keyEmitted(ServiceTrackerMap<String, List<T>> serviceTrackerMap, String key, T service, List<T> content) {
                ScopedServiceTrackerMapImpl.this._onChangeRunnable.run();
            }

            @Override
            public void keyRemoved(ServiceTrackerMap<String, List<T>> serviceTrackerMap, String key, T service, List<T> content) {
                ScopedServiceTrackerMapImpl.this._onChangeRunnable.run();
            }
        }
    }
}

