/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osgi.util.service;

import com.liferay.osgi.util.service.Reference;
import com.liferay.osgi.util.service.UnavailableServiceException;
import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ReflectionServiceTracker
implements Closeable {
    private static final InvocationHandler _invocationHandler = new InvocationHandler(){

        @Override
        public Object invoke(Object object, Method method, Object[] parameters) throws Throwable {
            throw new UnavailableServiceException(method.getDeclaringClass());
        }
    };
    private final List<ServiceTracker<?, ?>> _serviceTrackers = new ArrayList();
    private Object _unavailableServiceProxy;

    public ReflectionServiceTracker(Object target) {
        Class<?> targetClass = target.getClass();
        Bundle bundle = FrameworkUtil.getBundle(targetClass);
        BundleContext bundleContext = bundle.getBundleContext();
        List<InjectionPoint> injectionPoints = this.getInjectionPoints(target);
        for (InjectionPoint injectionPoint : injectionPoints) {
            ServiceTracker<?, ?> serviceTracker = this.track(bundleContext, target, injectionPoint);
            this._serviceTrackers.add(serviceTracker);
        }
    }

    @Override
    public void close() {
        for (ServiceTracker<?, ?> serviceTracker : this._serviceTrackers) {
            try {
                serviceTracker.close();
            }
            catch (Exception exception) {}
        }
        this._serviceTrackers.clear();
    }

    protected InjectionPoint createInjectionPoint(Object target, Method method) {
        Class<?> clazz = method.getParameterTypes()[0];
        if (clazz.isInterface()) {
            return new UnavailableProxyInjectionPoint(target, method, this._unavailableServiceProxy);
        }
        return new InjectionPoint(target, method);
    }

    protected List<Method> getInjectionPointMethods(Object target) {
        Method[] methods;
        ArrayList<Method> injectionPointMethods = new ArrayList<Method>();
        Class<?> targetClass = target.getClass();
        for (Method method : methods = targetClass.getDeclaredMethods()) {
            boolean annotationPresent = method.isAnnotationPresent(Reference.class);
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            if (!annotationPresent || parameterTypes.length != 1 || !returnType.equals(Void.TYPE)) continue;
            injectionPointMethods.add(method);
        }
        return injectionPointMethods;
    }

    protected List<InjectionPoint> getInjectionPoints(Object target) {
        Class<?> targetClass = target.getClass();
        ClassLoader classLoader = targetClass.getClassLoader();
        ArrayList interfaceClasses = new ArrayList();
        List<Method> injectionPointMethods = this.getInjectionPointMethods(target);
        for (Method injectionPointMethod : injectionPointMethods) {
            Class<?> parameterType = injectionPointMethod.getParameterTypes()[0];
            if (!parameterType.isInterface()) continue;
            interfaceClasses.add(parameterType);
        }
        this._unavailableServiceProxy = Proxy.newProxyInstance(classLoader, interfaceClasses.toArray(new Class[0]), _invocationHandler);
        ArrayList<InjectionPoint> injectionPoints = new ArrayList<InjectionPoint>();
        for (Method injectionPointMethod : injectionPointMethods) {
            InjectionPoint injectionPoint = this.createInjectionPoint(target, injectionPointMethod);
            if (injectionPoint == null) continue;
            injectionPoints.add(injectionPoint);
        }
        return injectionPoints;
    }

    protected ServiceTracker<?, ?> track(BundleContext bundleContext, final Object target, final InjectionPoint injectionPoint) {
        try {
            injectionPoint.reset();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to unset " + injectionPoint.getName() + " on " + target, e);
        }
        ServiceTracker<Object, Object> serviceTracker = new ServiceTracker<Object, Object>(bundleContext, injectionPoint.getParameterType(), null){

            public Object addingService(ServiceReference<Object> serviceReference) {
                Object service = super.addingService(serviceReference);
                ServiceReference currentServiceReference = this.getServiceReference();
                if (currentServiceReference == null || serviceReference.compareTo((Object)currentServiceReference) > 0) {
                    try {
                        injectionPoint.inject(service);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to set service reference using " + injectionPoint.getName() + " on " + target, e);
                    }
                }
                return service;
            }

            public void modifiedService(ServiceReference<Object> reference, Object service) {
                super.modifiedService(reference, service);
                ServiceReference currentServiceReference = this.getServiceReference();
                Object currentService = this.getService(currentServiceReference);
                try {
                    injectionPoint.inject(currentService);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to set injection point " + injectionPoint.getName() + " on " + target, e);
                }
            }

            public void removedService(ServiceReference<Object> serviceReference, Object service) {
                try {
                    super.removedService(serviceReference, service);
                    ServiceReference currentServiceReference = this.getServiceReference();
                    if (currentServiceReference == null) {
                        injectionPoint.reset();
                    } else {
                        Object currentService = this.getService(currentServiceReference);
                        injectionPoint.inject(currentService);
                    }
                }
                catch (IllegalStateException ise) {
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to set injection point " + injectionPoint.getName() + " on " + target, e);
                }
            }
        };
        serviceTracker.open();
        return serviceTracker;
    }

    private static class UnavailableProxyInjectionPoint
    extends InjectionPoint {
        private final Object _proxy;

        public UnavailableProxyInjectionPoint(Object target, Method method, Object proxy) {
            super(target, method);
            this._proxy = proxy;
        }

        @Override
        public void reset() throws IllegalAccessException, InvocationTargetException {
            super.inject(this._proxy);
        }
    }

    private static class InjectionPoint {
        private final Method _method;
        private final Object _target;

        public String getName() {
            return this._method.getName();
        }

        public Class<?> getParameterType() {
            return this._method.getParameterTypes()[0];
        }

        public void inject(Object value) throws IllegalAccessException, InvocationTargetException {
            this._method.invoke(this._target, value);
        }

        public void reset() throws IllegalAccessException, InvocationTargetException {
            this._method.invoke(this._target, new Object[]{null});
        }

        private InjectionPoint(Object target, Method method) {
            this._target = target;
            this._method = method;
        }
    }
}

