/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.lang;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClassLoaderPool {
    private static final Map<String, ClassLoader> _classLoaders = new ConcurrentHashMap<String, ClassLoader>();
    private static final Map<ClassLoader, String> _contextNames = new ConcurrentHashMap<ClassLoader, String>();

    public static ClassLoader getClassLoader(String contextName) {
        ClassLoader classLoader = null;
        if (contextName != null && !contextName.equals("null")) {
            classLoader = _classLoaders.get(contextName);
        }
        if (classLoader == null) {
            Thread currentThread = Thread.currentThread();
            classLoader = currentThread.getContextClassLoader();
        }
        return classLoader;
    }

    public static String getContextName(ClassLoader classLoader) {
        if (classLoader == null) {
            return "null";
        }
        String contextName = _contextNames.get(classLoader);
        if (contextName == null) {
            contextName = "null";
        }
        return contextName;
    }

    public static void register(String contextName, ClassLoader classLoader) {
        _classLoaders.put(contextName, classLoader);
        _contextNames.put(classLoader, contextName);
    }

    public static void unregister(ClassLoader classLoader) {
        String contextName = _contextNames.remove(classLoader);
        if (contextName != null) {
            _classLoaders.remove(contextName);
        }
    }

    public static void unregister(String contextName) {
        ClassLoader classLoader = _classLoaders.remove(contextName);
        if (classLoader != null) {
            _contextNames.remove(classLoader);
        }
    }

    static {
        ClassLoaderPool.register("GlobalClassLoader", ClassLoaderPool.class.getClassLoader());
    }
}

