/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.nio;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;

public class CharsetDecoderUtil {
    public static CharBuffer decode(String charsetName, ByteBuffer byteBuffer) {
        try {
            return CharsetDecoderUtil.decode(charsetName, CodingErrorAction.REPLACE, byteBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new Error(characterCodingException);
        }
    }

    public static CharBuffer decode(String charsetName, CodingErrorAction codingErrorAction, ByteBuffer byteBuffer) throws CharacterCodingException {
        CharsetDecoder charsetDecoder = CharsetDecoderUtil.getCharsetDecoder(charsetName, codingErrorAction);
        return charsetDecoder.decode(byteBuffer);
    }

    public static CharsetDecoder getCharsetDecoder(String charsetName) {
        return CharsetDecoderUtil.getCharsetDecoder(charsetName, CodingErrorAction.REPLACE);
    }

    public static CharsetDecoder getCharsetDecoder(String charsetName, CodingErrorAction codingErrorAction) {
        Charset charset = Charset.forName(charsetName);
        CharsetDecoder charsetDecoder = charset.newDecoder();
        charsetDecoder.onMalformedInput(codingErrorAction);
        charsetDecoder.onUnmappableCharacter(codingErrorAction);
        return charsetDecoder;
    }
}

