/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.apio.test.util;

import io.restassured.RestAssured;
import io.restassured.response.ExtractableResponse;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.AuthenticationSpecification;
import io.restassured.specification.PreemptiveAuthSpec;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApioClientBuilder {
    public static RequestSpecification given() {
        return new RequestSpecification(Authentication.EMPTY, Collections.emptyMap());
    }

    protected static class MultipartImpl
    implements Multipart {
        private final String _key;
        private final Object _value;

        @Override
        public io.restassured.specification.RequestSpecification multipart(io.restassured.specification.RequestSpecification requestSpecification) {
            if (this._value instanceof File) {
                return requestSpecification.multiPart(this._key, (File)this._value);
            }
            if (this._value instanceof String) {
                return requestSpecification.multiPart(this._key, (String)this._value);
            }
            return requestSpecification.multiPart(this._key, this._value);
        }

        protected MultipartImpl(String key, Object value) {
            this._key = key;
            this._value = value;
        }
    }

    protected static class BodyImpl
    implements Body {
        private String _body;

        @Override
        public io.restassured.specification.RequestSpecification body(io.restassured.specification.RequestSpecification requestSpecification) {
            return requestSpecification.body(this._body);
        }

        protected BodyImpl(String body) {
            this._body = body;
        }
    }

    protected static class BasicAuthentication
    implements Authentication {
        private final String _password;
        private final String _user;

        @Override
        public io.restassured.specification.RequestSpecification auth(io.restassured.specification.RequestSpecification requestSpecification) {
            AuthenticationSpecification authenticationSpecification = requestSpecification.auth();
            PreemptiveAuthSpec preemptiveAuthSpec = authenticationSpecification.preemptive();
            return preemptiveAuthSpec.basic(this._user, this._password);
        }

        protected BasicAuthentication(String user, String password) {
            this._user = user;
            this._password = password;
        }
    }

    public static interface Multipart {
        public static final Multipart EMPTY = requestSpecification -> requestSpecification;

        public io.restassured.specification.RequestSpecification multipart(io.restassured.specification.RequestSpecification var1);
    }

    public static interface Body {
        public static final Body EMPTY = requestSpecification -> requestSpecification;

        public io.restassured.specification.RequestSpecification body(io.restassured.specification.RequestSpecification var1);
    }

    public static interface Authentication {
        public static final Authentication EMPTY = requestSpecification -> requestSpecification;

        public io.restassured.specification.RequestSpecification auth(io.restassured.specification.RequestSpecification var1);
    }

    public static class Response {
        private final RequestSpecification _requestSpecification;
        private final ValidatableResponse _validatableResponse;

        public Response(ValidatableResponse validatableResponse, RequestSpecification requestSpecification) {
            this._validatableResponse = validatableResponse;
            this._requestSpecification = requestSpecification;
        }

        public Response delete(String href) {
            io.restassured.specification.RequestSpecification requestSpecification = this._requestSpecification.getRestAssuredRequestSpecification();
            io.restassured.response.Response response = (io.restassured.response.Response)requestSpecification.delete(href, new Object[0]);
            return new Response((ValidatableResponse)response.then(), this._requestSpecification);
        }

        public Response follow(String jsonPath) {
            ExtractableResponse extractableResponse = this._validatableResponse.extract();
            return this.get((String)extractableResponse.path(jsonPath, new String[0]));
        }

        public Response get(String href) {
            io.restassured.specification.RequestSpecification requestSpecification = this._requestSpecification.getRestAssuredRequestSpecification();
            io.restassured.response.Response response = (io.restassured.response.Response)requestSpecification.get(href, new Object[0]);
            return new Response((ValidatableResponse)response.then(), this._requestSpecification);
        }

        public Response post(String href) {
            io.restassured.specification.RequestSpecification requestSpecification = this._requestSpecification.getRestAssuredRequestSpecification();
            io.restassured.response.Response response = (io.restassured.response.Response)requestSpecification.post(href, new Object[0]);
            return new Response((ValidatableResponse)response.then(), this._requestSpecification);
        }

        public Response put(String href) {
            io.restassured.specification.RequestSpecification requestSpecification = this._requestSpecification.getRestAssuredRequestSpecification();
            io.restassured.response.Response response = (io.restassured.response.Response)requestSpecification.put(href, new Object[0]);
            return new Response((ValidatableResponse)response.then(), this._requestSpecification);
        }

        public ValidatableResponse then() {
            return this._validatableResponse;
        }
    }

    public static class RequestSpecification {
        private final Authentication _authentication;
        private final Body _body;
        private final Map<String, String> _headers;
        private final List<Multipart> _multiparts;

        public RequestSpecification(Authentication authentication, Map<String, String> headers) {
            this(authentication, headers, Body.EMPTY);
        }

        public RequestSpecification(Authentication authentication, Map<String, String> headers, Body body) {
            this(authentication, headers, body, Collections.emptyList());
        }

        public RequestSpecification(Authentication authentication, Map<String, String> headers, Body body, List<Multipart> multiparts) {
            this._authentication = authentication;
            this._headers = headers == null ? Collections.emptyMap() : Collections.unmodifiableMap(headers);
            this._body = body == null ? Body.EMPTY : body;
            this._multiparts = multiparts == null ? Collections.emptyList() : multiparts;
        }

        public RequestSpecification(Authentication authentication, Map<String, String> headers, List<Multipart> multiparts) {
            this(authentication, headers, Body.EMPTY, multiparts);
        }

        public RequestSpecification basicAuth(String user, String password) {
            return new RequestSpecification((Authentication)new BasicAuthentication(user, password), this._headers, this._body);
        }

        public RequestSpecification body(String body) {
            return new RequestSpecification(this._authentication, this._headers, new BodyImpl(body));
        }

        public RequestSpecification header(String name, String value) {
            HashMap<String, String> headers = new HashMap<String, String>(this._headers);
            headers.put(name, value);
            return new RequestSpecification(this._authentication, headers, this._body);
        }

        public RequestSpecification multipart(String key, Object value) {
            ArrayList<Multipart> multiparts = new ArrayList<Multipart>(this._multiparts);
            multiparts.add(new MultipartImpl(key, value));
            return new RequestSpecification(this._authentication, this._headers, multiparts);
        }

        public Response when() {
            return new Response(null, this);
        }

        protected io.restassured.specification.RequestSpecification getRestAssuredRequestSpecification() {
            io.restassured.specification.RequestSpecification requestSpecification = this._body.body(this._authentication.auth(RestAssured.given()));
            for (Multipart multipart : this._multiparts) {
                multipart.multipart(requestSpecification);
            }
            return requestSpecification.headers(this._headers);
        }
    }
}

