/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.async.advice.internal;

import com.liferay.portal.async.advice.internal.AsyncCallable;
import com.liferay.portal.async.advice.internal.AsyncInvokeThreadLocal;
import com.liferay.portal.async.advice.internal.configuration.AsyncAdviceConfiguration;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.aop.AopMethodInvocation;
import com.liferay.portal.kernel.aop.ChainableMethodAdvice;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.async.Async;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.async.advice.internal.configuration.AsyncAdviceConfiguration"}, service={ChainableMethodAdvice.class})
public class AsyncAdvice
extends ChainableMethodAdvice {
    private static final Log _log = LogFactoryUtil.getLog(AsyncAdvice.class);
    private volatile AsyncAdviceConfiguration _asyncAdviceConfiguration;
    private volatile Map<String, String> _destinationNames;
    @Reference
    private MessageBus _messageBus;

    public Object createMethodContext(Class<?> targetClass, Method method, Map<Class<? extends Annotation>, Annotation> annotations) {
        Annotation annotation = annotations.get(Async.class);
        if (annotation == null) {
            return null;
        }
        if (method.getReturnType() != Void.TYPE) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Async annotation on method " + method.getName() + " does not return void"));
            }
            return null;
        }
        String destinationName = null;
        if (this._destinationNames != null) {
            destinationName = this._destinationNames.get(targetClass.getName());
        }
        if (destinationName == null) {
            return this._asyncAdviceConfiguration.defaultDestinationName();
        }
        return destinationName;
    }

    @Activate
    @Modified
    protected void activate(Map<String, String> properties) {
        this._asyncAdviceConfiguration = (AsyncAdviceConfiguration)ConfigurableUtil.createConfigurable(AsyncAdviceConfiguration.class, properties);
        String[] targetClassNamesToDestinationNames = this._asyncAdviceConfiguration.targetClassNamesToDestinationNames();
        if (targetClassNamesToDestinationNames == null) {
            return;
        }
        HashMap<String, String> destinationNames = new HashMap<String, String>();
        for (String targetClassNameToDestinationName : targetClassNamesToDestinationNames) {
            int index = targetClassNameToDestinationName.indexOf(61);
            if (index <= 0) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Invalid target class name to destination name \"" + targetClassNameToDestinationName + "\""));
                continue;
            }
            destinationNames.put(targetClassNameToDestinationName.substring(0, index), targetClassNameToDestinationName.substring(index + 1));
        }
        if (!destinationNames.isEmpty()) {
            this._destinationNames = destinationNames;
        }
    }

    protected Object before(AopMethodInvocation aopMethodInvocation, Object[] arguments) {
        if (AsyncInvokeThreadLocal.isEnabled()) {
            return null;
        }
        String destinationName = (String)aopMethodInvocation.getAdviceMethodContext();
        TransactionCommitCallbackUtil.registerCallback(() -> {
            Message message = new Message();
            message.setPayload((Object)new AsyncCallable(aopMethodInvocation, arguments));
            this._messageBus.sendMessage(destinationName, message);
            return null;
        });
        return nullResult;
    }
}

