/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.internal;

import com.liferay.portal.background.task.internal.messaging.BackgroundTaskMessageListener;
import com.liferay.portal.background.task.internal.messaging.BackgroundTaskQueuingMessageListener;
import com.liferay.portal.background.task.internal.messaging.RemoveOnCompletionBackgroundTaskStatusMessageListener;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutorRegistry;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusRegistry;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocalManager;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={BackgroundTaskMessagingConfigurator.class})
public class BackgroundTaskMessagingConfigurator {
    @Reference
    private BackgroundTaskExecutorRegistry _backgroundTaskExecutorRegistry;
    @Reference
    private BackgroundTaskLocalService _backgroundTaskLocalService;
    @Reference
    private BackgroundTaskStatusRegistry _backgroundTaskStatusRegistry;
    @Reference
    private BackgroundTaskThreadLocalManager _backgroundTaskThreadLocalManager;
    @Reference
    private DestinationFactory _destinationFactory;
    @Reference
    private LockManager _lockManager;
    @Reference
    private MessageBus _messageBus;
    private final List<ServiceRegistration<Destination>> _serviceRegistrations = new ArrayList<ServiceRegistration<Destination>>();

    @Activate
    protected void activate(BundleContext bundleContext) {
        Destination backgroundTaskDestination = this._registerDestination(bundleContext, "parallel", "liferay/background_task", 5, 10);
        backgroundTaskDestination.register((MessageListener)new BackgroundTaskMessageListener(this._backgroundTaskExecutorRegistry, this._backgroundTaskLocalService, this._backgroundTaskStatusRegistry, this._backgroundTaskThreadLocalManager, this._lockManager, this._messageBus));
        Destination backgroundTaskStatusDestination = this._registerDestination(bundleContext, "serial", "liferay/background_task_status", 1, 1);
        backgroundTaskStatusDestination.register((MessageListener)new BackgroundTaskQueuingMessageListener(this._backgroundTaskLocalService, this._lockManager));
        backgroundTaskStatusDestination.register((MessageListener)new RemoveOnCompletionBackgroundTaskStatusMessageListener(this._backgroundTaskLocalService));
    }

    @Deactivate
    protected void deactivate() {
        for (ServiceRegistration<Destination> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    private Destination _registerDestination(BundleContext bundleContext, String destinationType, String destinationName, int workersCoreSize, int workersMaxSize) {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration(destinationType, destinationName);
        destinationConfiguration.setWorkersCoreSize(workersCoreSize);
        destinationConfiguration.setWorkersMaxSize(workersMaxSize);
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        this._serviceRegistrations.add((ServiceRegistration<Destination>)bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName())));
        return destination;
    }
}

