/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.internal;

import com.liferay.portal.background.task.internal.lock.helper.BackgroundTaskLockHelper;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.DelegatingBackgroundTaskExecutor;
import com.liferay.portal.kernel.lock.DuplicateLockException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManager;

public class SerialBackgroundTaskExecutor
extends DelegatingBackgroundTaskExecutor {
    private final BackgroundTaskLockHelper _backgroundTaskLockHelper;
    private final LockManager _lockManager;

    public SerialBackgroundTaskExecutor(BackgroundTaskExecutor backgroundTaskExecutor, LockManager lockManager) {
        super(backgroundTaskExecutor);
        this._lockManager = lockManager;
        this._backgroundTaskLockHelper = new BackgroundTaskLockHelper(lockManager);
    }

    public BackgroundTaskExecutor clone() {
        return new SerialBackgroundTaskExecutor(this.getBackgroundTaskExecutor(), this._lockManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        Lock lock = null;
        try {
            if (this.isSerial()) {
                lock = this._acquireLock(backgroundTask);
            }
            BackgroundTaskExecutor backgroundTaskExecutor = this.getBackgroundTaskExecutor();
            BackgroundTaskResult backgroundTaskResult = backgroundTaskExecutor.execute(backgroundTask);
            return backgroundTaskResult;
        }
        finally {
            if (lock != null) {
                this._backgroundTaskLockHelper.unlockBackgroundTask(backgroundTask);
            }
        }
    }

    private Lock _acquireLock(BackgroundTask backgroundTask) throws DuplicateLockException {
        Lock lock = this._backgroundTaskLockHelper.lockBackgroundTask(backgroundTask);
        if (!lock.isNew()) {
            throw new DuplicateLockException(lock);
        }
        return lock;
    }
}

