/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.model.impl;

import com.liferay.portal.background.task.model.impl.BackgroundTaskBaseImpl;
import com.liferay.portal.background.task.service.BackgroundTaskLocalServiceUtil;
import com.liferay.portal.kernel.backgroundtask.constants.BackgroundTaskConstants;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class BackgroundTaskImpl
extends BackgroundTaskBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(BackgroundTaskImpl.class);
    private long _attachmentsFolderId;

    public void addAttachment(long userId, String fileName, File file) throws PortalException {
        BackgroundTaskLocalServiceUtil.addBackgroundTaskAttachment((long)userId, (long)this.getBackgroundTaskId(), (String)fileName, (File)file);
    }

    public void addAttachment(long userId, String fileName, InputStream inputStream) throws PortalException {
        BackgroundTaskLocalServiceUtil.addBackgroundTaskAttachment((long)userId, (long)this.getBackgroundTaskId(), (String)fileName, (InputStream)inputStream);
    }

    public Folder addAttachmentsFolder() throws PortalException {
        if (this._attachmentsFolderId != 0L) {
            return PortletFileRepositoryUtil.getPortletFolder((long)this._attachmentsFolderId);
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Repository repository = PortletFileRepositoryUtil.addPortletRepository((long)this.getGroupId(), (String)"189", (ServiceContext)serviceContext);
        Folder folder = PortletFileRepositoryUtil.addPortletFolder((long)this.getUserId(), (long)repository.getRepositoryId(), (long)0L, (String)String.valueOf(this.getBackgroundTaskId()), (ServiceContext)serviceContext);
        this._attachmentsFolderId = folder.getFolderId();
        return folder;
    }

    public List<FileEntry> getAttachmentsFileEntries() throws PortalException {
        return this.getAttachmentsFileEntries(-1, -1);
    }

    public List<FileEntry> getAttachmentsFileEntries(int start, int end) throws PortalException {
        List<Object> fileEntries = new ArrayList<FileEntry>();
        long attachmentsFolderId = this.getAttachmentsFolderId();
        if (attachmentsFolderId != 0L) {
            fileEntries = PortletFileRepositoryUtil.getPortletFileEntries((long)this.getGroupId(), (long)attachmentsFolderId, (int)0, (int)start, (int)end, null);
        }
        return fileEntries;
    }

    public int getAttachmentsFileEntriesCount() throws PortalException {
        int attachmentsFileEntriesCount = 0;
        long attachmentsFolderId = this.getAttachmentsFolderId();
        if (attachmentsFolderId != 0L) {
            attachmentsFileEntriesCount = PortletFileRepositoryUtil.getPortletFileEntriesCount((long)this.getGroupId(), (long)attachmentsFolderId, (int)0);
        }
        return attachmentsFileEntriesCount;
    }

    public long getAttachmentsFolderId() {
        block4: {
            if (this._attachmentsFolderId != 0L) {
                return this._attachmentsFolderId;
            }
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            Repository repository = PortletFileRepositoryUtil.fetchPortletRepository((long)this.getGroupId(), (String)"189");
            if (repository == null) {
                return 0L;
            }
            try {
                Folder folder = PortletFileRepositoryUtil.getPortletFolder((long)repository.getRepositoryId(), (long)0L, (String)String.valueOf(this.getBackgroundTaskId()));
                this._attachmentsFolderId = folder.getFolderId();
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)("No portlet repository for background task " + this.getBackgroundTaskId()), (Throwable)exception);
            }
        }
        return this._attachmentsFolderId;
    }

    public String getStatusLabel() {
        return BackgroundTaskConstants.getStatusLabel((int)this.getStatus());
    }

    public boolean isInProgress() {
        return this.getStatus() == 1;
    }
}

